/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.webui.component.explorer.UIDriveSelector;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDriveSelector.gtmpl", events={@EventConfig(listeners={AddDriveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIDriveSelector
extends UIContainer {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "DriveSelectorList");

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getListDrive() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getDrives("repository"), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public List<String> getDrives(String repoName) throws Exception {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        ManageableRepository repository = rservice.getRepository(repoName);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        Session session = null;
        List drives = driveService.getAllDrives(repoName);
        if (drives != null && drives.size() > 0) {
            for (DriveData drive : drives) {
                if (drive.getIcon() != null && drive.getIcon().length() > 0) {
                    try {
                        String[] iconPath = drive.getIcon().split(":/");
                        session = repository.getSystemSession(iconPath[0]);
                        Node node = (Node)session.getItem("/" + iconPath[1]);
                        Node jcrContentNode = node.getNode("jcr:content");
                        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
                        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
                        dresource.setDownloadName(node.getName());
                        drive.setIcon(dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource)));
                        session.logout();
                    }
                    catch (PathNotFoundException pnf) {
                        drive.setIcon("");
                    }
                }
                if (!this.isExistWorspace(repository, drive)) continue;
                driveList.add(drive);
            }
        }
        ArrayList<String> driveListName = new ArrayList<String>();
        for (DriveData driveData : driveList) {
            driveListName.add(driveData.getName());
        }
        Collections.sort(driveListName);
        return driveListName;
    }

    private boolean isExistWorspace(ManageableRepository repository, DriveData drive) {
        for (String ws : repository.getWorkspaceNames()) {
            if (!ws.equals(drive.getWorkspace())) continue;
            return true;
        }
        return false;
    }
}

