/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesBrowser;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/UIDrivesBrowser.gtmpl", events={@EventConfig(listeners={SelectRepoActionListener.class}), @EventConfig(listeners={SelectDriveActionListener.class})})
public class UIDrivesBrowser
extends UIContainer {
    public static final String FIELD_SELECTREPO = "selectRepo";
    private String repoName_;
    private RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);

    public UIDrivesBrowser() throws Exception {
        this.repoName_ = this.rService.getDefaultRepository().getConfiguration().getName();
        this.initRepoList(this.repoName_);
    }

    private void initRepoList(String defaultRepo) throws Exception {
    }

    public List<String> getRepositoryList() {
        ArrayList<String> repositories = new ArrayList<String>();
        for (RepositoryEntry re : this.rService.getConfig().getRepositoryConfigurations()) {
            repositories.add(re.getName());
        }
        return repositories;
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getRepository() {
        return this.repoName_;
    }

    public void setRepository(String repoName) {
        this.repoName_ = repoName;
    }

    private List<SelectItemOption<String>> getRepoItem() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        Iterator i$ = this.rService.getConfig().getRepositoryConfigurations().iterator();
        while (i$.hasNext()) {
            RepositoryEntry obj;
            RepositoryEntry repo = obj = (RepositoryEntry)i$.next();
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    public List<DriveData> getDrives(String repoName) throws Exception {
        String[] allPermission;
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        List userRoles = Utils.getMemberships();
        List allDrives = driveService.getAllDrives(repoName);
        HashSet<DriveData> temp = new HashSet<DriveData>();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId != null) {
            block0: for (DriveData driveData : allDrives) {
                allPermission = driveData.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : userRoles) {
                        if (!driveData.hasPermission(allPermission, rolse)) continue;
                        temp.add(driveData);
                        continue block1;
                    }
                }
            }
        } else {
            block3: for (DriveData driveData : allDrives) {
                for (String permission : allPermission = driveData.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    temp.add(driveData);
                    continue block3;
                }
            }
        }
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            driveList.add((DriveData)iterator.next());
        }
        Collections.sort(driveList);
        return driveList;
    }

    public List<DriveData> generalDrives(List<DriveData> driveList) throws Exception {
        ArrayList<DriveData> generalDrives = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driveList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrives.add(drive);
        }
        return generalDrives;
    }

    public List<DriveData> groupDrives(List<DriveData> driveList) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        ArrayList<DriveData> groupDrives = new ArrayList<DriveData>();
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        List groups = Utils.getGroups();
        block0: for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrives.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrives);
        return groupDrives;
    }

    public List<DriveData> personalDrives(List<DriveData> driveList) {
        ArrayList<DriveData> personalDrives = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(userPath + "/${userId}/")) continue;
            personalDrives.add(drive);
        }
        Collections.sort(personalDrives);
        return personalDrives;
    }

    static /* synthetic */ String access$000(UIDrivesBrowser x0) {
        return x0.repoName_;
    }
}

