/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.List;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesBrowserContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditForm;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIJCRExplorerPortlet
extends UIPortletApplication {
    public static final String REPOSITORY = "repository";
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String ISDIRECTLY_DRIVE = "isDirectlyDrive";
    public static final String DRIVE_NAME = "driveName";
    public static final String USECASE = "usecase";
    public static final String JAILED = "jailed";
    public static final String SOCIAL = "social";
    public static final String SELECTION = "selection";
    public static final String PERSONAL = "personal";
    private boolean flagSelect = false;

    public UIJCRExplorerPortlet() throws Exception {
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.addChild(UIJcrExplorerContainer.class, null, null);
        explorerContainer.setFlag(false);
        explorerContainer.init();
        ((UIJcrExplorerEditContainer)this.addChild(UIJcrExplorerEditContainer.class, null, null)).setRendered(false);
    }

    public boolean isFlagSelect() {
        return this.flagSelect;
    }

    public void setFlagSelect(boolean flagSelect) {
        this.flagSelect = flagSelect;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.getChild(UIJcrExplorerContainer.class);
        UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class);
        context.getJavascriptManager().importJavascript("eXo.ecm.ECMUtils", "/ecm/javascript/");
        context.getJavascriptManager().addJavascript((CharSequence)"eXo.ecm.ECMUtils.init('UIJCRExplorerPortlet') ;");
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences portletPref = pcontext.getRequest().getPreferences();
            String usecase = portletPref.getValue(USECASE, "").trim();
            if (usecase.equals(JAILED)) {
                this.initwhenDirect(explorerContainer, editContainer, portletPref);
            } else if (usecase.equals(SOCIAL)) {
                this.initwhenDirect(explorerContainer, editContainer, portletPref);
            } else {
                this.initwhenSelect(explorerContainer);
            }
            explorerContainer.setRendered(true);
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(false);
        } else if (portletReqContext.getApplicationMode() == PortletMode.HELP) {
            System.out.println("\n\n>>>>>>>>>>>>>>>>>>> IN HELP  MODE \n");
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            explorerContainer.setRendered(false);
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(true);
        }
        super.processRender(app, context);
    }

    public void initwhenSelect(UIJcrExplorerContainer explorerContainer) throws Exception {
        explorerContainer.setFlag(true);
        if (!this.isFlagSelect()) {
            UIDrivesBrowserContainer browserContainer = (UIDrivesBrowserContainer)explorerContainer.getChild(UIDrivesBrowserContainer.class);
            if (browserContainer != null) {
                browserContainer.setRendered(true);
            } else {
                ((UIDrivesBrowserContainer)explorerContainer.addChild(UIDrivesBrowserContainer.class, null, null)).setRendered(true);
            }
            ((UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class)).setRendered(false);
        } else {
            UIDrivesBrowserContainer driveBrowserContainer = (UIDrivesBrowserContainer)explorerContainer.getChild(UIDrivesBrowserContainer.class);
            if (driveBrowserContainer == null) {
                explorerContainer.setFlag(false);
                ((UIDrivesBrowserContainer)explorerContainer.getChild(UIDrivesBrowserContainer.class)).setRendered(false);
                ((UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class)).setRendered(true);
            }
        }
    }

    public void initwhenDirect(UIJcrExplorerContainer explorerContainer, UIJcrExplorerEditContainer editContainer, PortletPreferences portletPref) throws Exception {
        explorerContainer.setFlag(false);
        String driveName = portletPref.getValue(DRIVE_NAME, "").trim();
        List listDriveName = explorerContainer.getDrives();
        for (String driveDataName : listDriveName) {
            if (!driveDataName.trim().equals(driveName)) continue;
            explorerContainer.setFlag(true);
            break;
        }
        if (((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).isFlagSelectRender()) {
            explorerContainer.initExplorer(driveName, portletPref);
            ((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).setFlagSelectRender(false);
        }
        ((UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class)).setRendered(true);
        ((UIDrivesBrowserContainer)explorerContainer.getChild(UIDrivesBrowserContainer.class)).setRendered(false);
    }

    public String getPreferenceRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        return repository;
    }
}

