/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesBrowserContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.control.UIViewBar;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/webui/component/explorer/UIJCRExporerPortlet.gtmpl")
public class UIJcrExplorerContainer
extends UIContainer {
    private boolean flag = false;

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public void init() throws Exception {
        PortletPreferences portletPref = this.getPreference();
        String isDirectlyDrive = portletPref.getValue("isDirectlyDrive", "").trim();
        if (isDirectlyDrive.equals("true")) {
            if (this.getChild(UIJCRExplorer.class) == null) {
                this.addChild(UIJCRExplorer.class, null, null);
            }
            if (this.getChild(UIDrivesBrowserContainer.class) == null) {
                ((UIDrivesBrowserContainer)this.addChild(UIDrivesBrowserContainer.class, null, null)).setRendered(false);
            }
            String driveName = portletPref.getValue("driveName", "").trim();
            List listDriver = this.getDrives(portletPref);
            for (DriveData driveData : listDriver) {
                if (!driveData.getName().trim().equals(driveName)) continue;
                this.flag = true;
                break;
            }
            if (this.flag) {
                this.initExplorer(driveName, portletPref);
            }
        } else {
            this.flag = true;
            if (this.getChild(UIDrivesBrowserContainer.class) == null) {
                this.addChild(UIDrivesBrowserContainer.class, null, null);
            }
            if (this.getChild(UIJCRExplorer.class) == null) {
                ((UIJCRExplorer)this.addChild(UIJCRExplorer.class, null, null)).setRendered(false);
            }
        }
    }

    private PortletPreferences getPreference() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    public List<String> getDrives() throws Exception {
        List driveList = new ArrayList();
        driveList = this.getDrives(this.getPreference());
        ArrayList listDriveAll = new ArrayList();
        ArrayList<String> listDriveNameAll = new ArrayList<String>();
        List generalDrives = this.generalDrives(driveList);
        List groupDrives = this.groupDrives(driveList);
        List personalDrives = this.personalDrives(driveList);
        listDriveAll.addAll(generalDrives);
        listDriveAll.addAll(groupDrives);
        listDriveAll.addAll(personalDrives);
        for (DriveData driveData : listDriveAll) {
            listDriveNameAll.add(driveData.getName());
        }
        return listDriveNameAll;
    }

    public List<DriveData> getDrives(PortletPreferences portletPref) throws Exception {
        String[] allPermission;
        ManageDriveService driveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        ArrayList<DriveData> driveList = new ArrayList<DriveData>();
        List userRoles = Utils.getMemberships();
        List allDrives = driveService.getAllDrives(portletPref.getValue(Utils.REPOSITORY, ""));
        HashSet<DriveData> temp = new HashSet<DriveData>();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (userId != null) {
            block0: for (DriveData driveData : allDrives) {
                allPermission = driveData.getAllPermissions();
                boolean flag = false;
                block1: for (String permission : allPermission) {
                    if (permission.equalsIgnoreCase("${userId}")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (permission.equalsIgnoreCase("*")) {
                        temp.add(driveData);
                        flag = true;
                        continue block0;
                    }
                    if (flag) continue;
                    for (String rolse : userRoles) {
                        if (!driveData.hasPermission(allPermission, rolse)) continue;
                        temp.add(driveData);
                        continue block1;
                    }
                }
            }
        } else {
            block3: for (DriveData driveData : allDrives) {
                for (String permission : allPermission = driveData.getAllPermissions()) {
                    if (!permission.equalsIgnoreCase("*")) continue;
                    temp.add(driveData);
                    continue block3;
                }
            }
        }
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            driveList.add((DriveData)iterator.next());
        }
        Collections.sort(driveList);
        return driveList;
    }

    public List<DriveData> generalDrives(List<DriveData> driveList) throws Exception {
        ArrayList<DriveData> generalDrives = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driveList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrives.add(drive);
        }
        return generalDrives;
    }

    public List<DriveData> groupDrives(List<DriveData> driveList) throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        ArrayList<DriveData> groupDrives = new ArrayList<DriveData>();
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        List groups = Utils.getGroups();
        block0: for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(groupPath)) continue;
            for (String group : groups) {
                if (!drive.getHomePath().equals(groupPath + group)) continue;
                groupDrives.add(drive);
                continue block0;
            }
        }
        Collections.sort(groupDrives);
        return groupDrives;
    }

    public List<DriveData> personalDrives(List<DriveData> driveList) {
        ArrayList<DriveData> personalDrives = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        for (DriveData drive : driveList) {
            if (!drive.getHomePath().startsWith(userPath + "/${userId}/")) continue;
            personalDrives.add(drive);
        }
        Collections.sort(personalDrives);
        return personalDrives;
    }

    public void initExplorer(String driveName, PortletPreferences portletPref) throws Exception {
        try {
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
            ManageDriveService dservice = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
            DriveData drive = dservice.getDriveByName(driveName, portletPref.getValue(Utils.REPOSITORY, ""));
            String userId = Util.getPortalRequestContext().getRemoteUser();
            UIApplication uiApp = (UIApplication)this.getApplicationComponent(UIApplication.class);
            ArrayList<String> viewLists = new ArrayList<String>();
            for (String role : Utils.getMemberships()) {
                for (String viewName : drive.getViews().split(",")) {
                    if (viewLists.contains(viewName.trim())) continue;
                    Node viewNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), portletPref.getValue(Utils.REPOSITORY, ""), SessionProviderFactory.createSystemProvider());
                    String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                    if (permiss.contains("${userId}")) {
                        permiss = permiss.replace("${userId}", userId);
                    }
                    String[] viewPermissions = permiss.split(",");
                    if (permiss.equals("*")) {
                        viewLists.add(viewName.trim());
                    }
                    if (!drive.hasPermission(viewPermissions, role)) continue;
                    viewLists.add(viewName.trim());
                }
            }
            if (viewLists.isEmpty()) {
                return;
            }
            String viewListStr = "";
            ArrayList<SelectItemOption> viewOptions = new ArrayList<SelectItemOption>();
            ResourceBundle res = context.getApplicationResourceBundle();
            String viewLabel = null;
            for (String viewName : viewLists) {
                try {
                    viewLabel = res.getString("Views.label." + viewName);
                }
                catch (MissingResourceException e) {
                    viewLabel = viewName;
                }
                viewOptions.add(new SelectItemOption(viewLabel, (Object)viewName));
                if (viewListStr.length() > 0) {
                    viewListStr = viewListStr + "," + viewName;
                    continue;
                }
                viewListStr = viewName;
            }
            drive.setViews(viewListStr);
            String homePath = drive.getHomePath();
            if (homePath.contains("${userId}")) {
                homePath = homePath.replace("${userId}", userId);
            }
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getChild(UIJCRExplorer.class);
            Preference pref = new Preference();
            pref.setShowSideBar(drive.getViewSideBar());
            pref.setShowNonDocumentType(drive.getViewNonDocument());
            pref.setShowPreferenceDocuments(drive.getViewPreferences());
            pref.setAllowCreateFoder(drive.getAllowCreateFolder());
            pref.setShowHiddenNode(drive.getShowHiddenNode());
            uiJCRExplorer.setPreferences(pref);
            uiJCRExplorer.setDriveData(drive);
            uiJCRExplorer.setIsReferenceNode(false);
            SessionProvider provider = SessionProviderFactory.createSessionProvider();
            ManageableRepository repository = rservice.getRepository(portletPref.getValue(Utils.REPOSITORY, ""));
            Node node = null;
            try {
                Session session = provider.getSession(drive.getWorkspace(), repository);
                node = (Node)session.getItem(homePath);
            }
            catch (AccessDeniedException ace) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.access-denied", args, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (NoSuchWorkspaceException nosuchWS) {
                Object[] args = new Object[]{driveName};
                uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.workspace-not-exist", args, 1));
                context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                return;
            }
            uiJCRExplorer.getAllClipBoard().clear();
            uiJCRExplorer.setRepositoryName(portletPref.getValue(Utils.REPOSITORY, ""));
            uiJCRExplorer.setWorkspaceName(drive.getWorkspace());
            uiJCRExplorer.setRootPath(homePath);
            uiJCRExplorer.setSelectNode(node);
            uiJCRExplorer.refreshExplorer();
            UIControl uiControl = (UIControl)uiJCRExplorer.getChild(UIControl.class);
            UIActionBar uiActionbar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            UIViewBar uiViewBar = (UIViewBar)uiControl.getChild(UIViewBar.class);
            uiViewBar.setViewOptions(viewOptions);
            uiActionbar.setTabOptions((String)viewLists.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

