/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectDriveActionListener.class})})
public class UIJcrExplorerEditForm
extends UIForm {
    private boolean flagSelectRender = false;

    public UIJcrExplorerEditForm() throws Exception {
        UIFormSelectBox repository = new UIFormSelectBox("repository", "repository", this.getRepoOption());
        String repositoryValue = this.getPreference().getValue("repository", "");
        repository.setValue(repositoryValue);
        repository.setEnable(false);
        this.addChild((UIComponent)repository);
        UIFormCheckBoxInput checkBoxCategory = new UIFormCheckBoxInput("categoryMandatoryWhenFileUpload", null, null);
        checkBoxCategory.setChecked(Boolean.parseBoolean(this.getPreference().getValue("categoryMandatoryWhenFileUpload", "")));
        checkBoxCategory.setEnable(false);
        this.addChild((UIComponent)checkBoxCategory);
        ArrayList<SelectItemOption> listType = new ArrayList<SelectItemOption>();
        String usecase = this.getPreference().getValue("usecase", "");
        listType.add(new SelectItemOption("Selection", (Object)"selection"));
        listType.add(new SelectItemOption("Jailed", (Object)"jailed"));
        listType.add(new SelectItemOption("Personal", (Object)"personal"));
        listType.add(new SelectItemOption("Social", (Object)"social"));
        UIFormSelectBox typeSelectBox = new UIFormSelectBox("usecase", "usecase", listType);
        typeSelectBox.setValue(usecase);
        typeSelectBox.setEnable(false);
        typeSelectBox.setOnChange("SelectType");
        this.addChild((UIComponent)typeSelectBox);
        UIFormInputSetWithAction driveNameInput = new UIFormInputSetWithAction("DriveNameInput");
        UIFormStringInput stringInputDrive = new UIFormStringInput("driveName", "driveName", null);
        stringInputDrive.setValue((Object)this.getPreference().getValue("driveName", ""));
        stringInputDrive.setEnable(false);
        driveNameInput.addUIFormInput((UIFormInput)stringInputDrive);
        driveNameInput.setActionInfo("driveName", new String[]{"SelectDrive"});
        this.addUIComponentInput((UIComponent)driveNameInput);
        if (usecase.equals("jailed")) {
            driveNameInput.setRendered(true);
            this.setFlagSelectRender(true);
        } else if (usecase.equals("social")) {
            this.getGroupId();
            this.setFlagSelectRender(true);
            driveNameInput.setRendered(false);
        } else if (usecase.equals("selection")) {
            driveNameInput.setRendered(false);
        } else {
            driveNameInput.setRendered(false);
        }
        this.setActions(new String[]{"Edit"});
    }

    public String getGroupId() {
        try {
            Method[] methods;
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            String requestUrl = pcontext.getRequestURI();
            String portalUrl = pcontext.getPortalURI();
            String spaceUrl = requestUrl.replace(portalUrl, "");
            if (spaceUrl.contains("/")) {
                spaceUrl = spaceUrl.split("/")[0];
            }
            Object space = this.getSpaceByUrl(spaceUrl);
            Class<?> clazzSpace = Class.forName("org.exoplatform.social.space.Space");
            for (Method m : methods = clazzSpace.getDeclaredMethods()) {
                if (!m.getName().trim().equals("getGroupId")) continue;
                return (String)m.invoke(space, new Object[0]);
            }
        }
        catch (Exception e) {
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)this.getChildById("usecase");
            typeSelectBox.setValue("selection");
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)this.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            stringInputDrive.setValue((Object)"");
        }
        return null;
    }

    public Object getSpaceByUrl(String url) throws Exception {
        Method[] methods;
        Class<?> clazz = Class.forName("org.exoplatform.social.space.SpaceService");
        Object obj = PortalContainer.getInstance().getComponentInstanceOfType(clazz);
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!m.getName().trim().equals("getSpaceByUrl")) continue;
            return m.invoke(obj, url);
        }
        return null;
    }

    public boolean isFlagSelectRender() {
        return this.flagSelectRender;
    }

    public void setFlagSelectRender(boolean flagSelectRender) {
        this.flagSelectRender = flagSelectRender;
    }

    public void setEditable(boolean isEditable) {
        UIFormSelectBox repository = (UIFormSelectBox)this.getChild(UIFormSelectBox.class);
        repository.setEnable(isEditable);
        UIFormCheckBoxInput checkBoxCategory = (UIFormCheckBoxInput)this.getChildById("categoryMandatoryWhenFileUpload");
        checkBoxCategory.setEnable(isEditable);
        UIFormSelectBox typeSelectBox = (UIFormSelectBox)this.getChildById("usecase");
        typeSelectBox.setEnable(isEditable);
    }

    private PortletPreferences getPreference() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    private List<SelectItemOption<String>> getRepoOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        for (RepositoryEntry repo : repositoryService.getConfig().getRepositoryConfigurations()) {
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    static /* synthetic */ PortletPreferences access$000(UIJcrExplorerEditForm x0) {
        return x0.getPreference();
    }
}

