/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.comparator.ItemOptionNameComparator;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIDocumentFormController
extends UIContainer
implements UIPopupComponent {
    private String defaultDocument_;
    private static String DEFAULT_VALUE = "exo:article";
    private Node currentNode_;
    private String repository_;

    public UIDocumentFormController() throws Exception {
        this.addChild(UISelectDocumentForm.class, null, null);
        UIDocumentForm uiDocumentForm = (UIDocumentForm)this.createUIComponent(UIDocumentForm.class, null, null);
        uiDocumentForm.setContentType(DEFAULT_VALUE);
        uiDocumentForm.addNew(true);
        this.addChild((UIComponent)uiDocumentForm);
    }

    public void setCurrentNode(Node node) {
        this.currentNode_ = node;
    }

    public void setRepository(String repository) {
        this.repository_ = repository;
    }

    public void initPopup(UIComponent uiComp) throws Exception {
        this.removeChildById("PopupComponent");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupComponent");
        uiPopup.setUIComponent(uiComp);
        uiPopup.setWindowSize(640, 300);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public List<SelectItemOption<String>> getListFileType() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List acceptableContentTypes = templateService.getCreationableContentTypes(this.currentNode_);
        if (acceptableContentTypes.size() == 0) {
            return options;
        }
        for (String contentType : acceptableContentTypes) {
            String label = templateService.getTemplateLabel(contentType, this.repository_);
            options.add((SelectItemOption<String>)new SelectItemOption(label, (Object)contentType));
        }
        Collections.sort(options, new ItemOptionNameComparator());
        if (options.size() > 0) {
            this.defaultDocument_ = (String)((SelectItemOption)options.get(0)).getValue();
            if (options.size() > 1) {
                UISelectDocumentForm uiSelectForm = (UISelectDocumentForm)this.getChild(UISelectDocumentForm.class);
                UIFormSelectBox uiSelectBox = uiSelectForm.getUIFormSelectBox("selectTemplate");
                uiSelectBox.setValue(this.defaultDocument_);
                uiSelectBox.setOptions(options);
            } else {
                this.removeChild(UISelectDocumentForm.class);
            }
        }
        return options;
    }

    public void init() throws Exception {
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setRepositoryName(this.repository_);
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setContentType(this.defaultDocument_);
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setWorkspace(this.currentNode_.getSession().getWorkspace().getName());
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setStoredPath(this.currentNode_.getPath());
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).resetProperties();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

