/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SetDefaultActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMultiLanguageForm
extends UIForm {
    public UIMultiLanguageForm() throws Exception {
        ArrayList languages = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("languages", "languages", languages));
    }

    public void doSelect(Node currentNode) throws Exception {
        ArrayList<SelectItemOption> languages = new ArrayList<SelectItemOption>();
        if (!currentNode.hasProperty("exo:language")) {
            currentNode.addMixin("mix:i18n");
            currentNode.save();
        }
        String defaultLang = currentNode.getProperty("exo:language").getString();
        UIMultiLanguageManager uiMultiLanguageManager = (UIMultiLanguageManager)this.getParent();
        List listLang = uiMultiLanguageManager.languages();
        String defaultLangName = "";
        for (SelectItemOption item : listLang) {
            if (!((String)item.getValue()).trim().equals(defaultLang)) continue;
            defaultLangName = item.getLabel();
            break;
        }
        languages.add(new SelectItemOption(defaultLangName + "(default)", (Object)defaultLang));
        if (currentNode.hasNode("languages")) {
            Node languageNode = currentNode.getNode("languages");
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                Node lang = iter.nextNode();
                if (lang.getName().equals(defaultLang)) continue;
                String label = lang.getName();
                for (SelectItemOption item : listLang) {
                    if (!((String)item.getValue()).trim().equals(lang.getName())) continue;
                    label = item.getLabel();
                    break;
                }
                languages.add(new SelectItemOption(label, (Object)lang.getName()));
            }
        }
        this.getUIFormSelectBox("languages").setOptions(languages);
        this.getUIFormSelectBox("languages").setValue(defaultLang);
    }
}

