/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UITaggingForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={AddTagActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaggingForm
extends UIForm
implements UIPopupComponent {
    public static final String TAG_NAMES = "names";
    public static final String LINKED_TAGS = "linked";
    public static final String LINKED_TAGS_SET = "tagSet";
    public static final String TAG_STATUS_PROP = "exo:tagStatus".intern();
    public static final String TAG_NAME_ACTION = "tagNameAct".intern();
    public static final String ASCENDING_ORDER = "Ascending".intern();

    public UITaggingForm() throws Exception {
        UIFormInputSetWithAction uiInputSet = new UIFormInputSetWithAction(LINKED_TAGS_SET);
        uiInputSet.addUIFormInput((UIFormInput)new UIFormStringInput(TAG_NAMES, TAG_NAMES, null));
        uiInputSet.addUIFormInput((UIFormInput)new UIFormInputInfo(LINKED_TAGS, LINKED_TAGS, null));
        uiInputSet.setIntroduction(TAG_NAMES, "UITaggingForm.introduction.tagName");
        this.addUIComponentInput((UIComponent)uiInputSet);
        uiInputSet.setIsView(false);
    }

    public void activate() throws Exception {
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        FolksonomyService folksonomyService = (FolksonomyService)this.getApplicationComponent(FolksonomyService.class);
        StringBuilder linkedTags = new StringBuilder();
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        for (Node tag : folksonomyService.getLinkedTagsOfDocument(currentNode, repository)) {
            if (linkedTags.length() > 0) {
                linkedTags = linkedTags.append(",");
            }
            linkedTags.append(tag.getName());
        }
        UIFormInputSetWithAction uiLinkedInput = (UIFormInputSetWithAction)this.getChildById(LINKED_TAGS_SET);
        uiLinkedInput.setInfoField(LINKED_TAGS, linkedTags.toString());
        uiLinkedInput.setIsShowOnly(true);
    }

    public void deActivate() throws Exception {
    }
}

