/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActivePublication;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPublicationManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.ecm.publication.AlreadyInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationPresentationService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.webui.UIPublicationLogList;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.form.UIForm;

@ComponentConfig(template="app:/groovy/webui/component/UIGridWithButton.gtmpl", events={@EventConfig(listeners={EnrolActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIActivePublication
extends UIGrid
implements UIPopupComponent {
    public static final String LIFECYCLE_NAME = "LifecycleName";
    public static final String LIFECYCLE_DESC = "LifecycleDesc";
    public static String[] LIFECYCLE_FIELDS = new String[]{"LifecycleName", "LifecycleDesc"};
    public static String[] LIFECYCLE_ACTION = new String[]{"Enrol"};
    public static final String LIFECYCLE_SELECTED = "LifecycleSelected";

    public UIActivePublication() throws Exception {
        this.configure(LIFECYCLE_NAME, LIFECYCLE_FIELDS, LIFECYCLE_ACTION);
        this.getUIPageIterator().setId("LifecyclesIterator");
    }

    public String[] getActions() {
        return new String[]{"Cancel"};
    }

    public void updateLifecyclesGrid() throws Exception {
        ArrayList<PublicationLifecycleBean> publicationLifecycleBeans = new ArrayList<PublicationLifecycleBean>();
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        Collection publicationPlugins = publicationService.getPublicationPlugins().values();
        if (publicationPlugins.size() != 0) {
            for (PublicationPlugin publicationPlugin : publicationPlugins) {
                PublicationLifecycleBean lifecycleBean = new PublicationLifecycleBean(this);
                lifecycleBean.setLifecycleName(publicationPlugin.getLifecycleName());
                lifecycleBean.setLifecycleDesc(publicationPlugin.getDescription());
                publicationLifecycleBeans.add(lifecycleBean);
            }
        }
        ObjectPageList objectPageList = new ObjectPageList(publicationLifecycleBeans, 5);
        this.getUIPageIterator().setPageList((PageList)objectPageList);
    }

    public void enrolNodeInLifecycle(Node currentNode, String lifecycleName, WebuiRequestContext requestContext) throws Exception {
        Node parentNode;
        String lockToken;
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        UIPublicationManager uiPublicationManager = (UIPublicationManager)uiJCRExplorer.createUIComponent(UIPublicationManager.class, null, null);
        if (currentNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)currentNode)) != null) {
            uiJCRExplorer.getSession().addLockToken(lockToken);
        }
        if ((parentNode = currentNode.getParent()).isLocked()) {
            String lockToken1 = LockUtil.getLockToken((Node)parentNode);
            uiJCRExplorer.getSession().addLockToken(lockToken1);
        }
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        PublicationPresentationService publicationPresentationService = (PublicationPresentationService)this.getApplicationComponent(PublicationPresentationService.class);
        try {
            if (!currentNode.isCheckedOut()) {
                uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
                requestContext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            publicationService.enrollNodeInLifecycle(currentNode, lifecycleName);
        }
        catch (AlreadyInPublicationLifecycleException e) {
            uiApp.addMessage(new ApplicationMessage("UIActivePublication.msg.already-enroled", null, 0));
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            uiApp.addMessage(new ApplicationMessage("UIActivePublication.msg.unknow-error", (Object[])new String[]{e.getMessage()}, 0));
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        UIContainer container = (UIContainer)this.createUIComponent(UIContainer.class, null, null);
        UIForm uiFormPublicationManager = publicationPresentationService.getStateUI(currentNode, (UIComponent)container);
        uiPublicationManager.addChild((UIComponent)uiFormPublicationManager);
        ((UIPublicationLogList)uiPublicationManager.addChild(UIPublicationLogList.class, null, null)).setRendered(false);
        UIPublicationLogList uiPublicationLogList = (UIPublicationLogList)uiPublicationManager.getChild(UIPublicationLogList.class);
        UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiJCRExplorer.getChild(UIPopupContainer.class);
        UIPopupContainer2.activate((UIComponent)uiPublicationManager, 700, 500);
        uiPublicationLogList.setNode(uiJCRExplorer.getCurrentNode());
        uiPublicationLogList.updateGrid();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

