/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIJCRAdvancedSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeOptionActionListener.class})})
public class UIJCRAdvancedSearch
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_QUERY = "query";
    public static final String FIELD_SELECT_BOX = "selectBox";
    private static final String ROOT_SQL_QUERY = "select * from nt:base order by exo:dateCreated DESC";
    private static final String SQL_QUERY = "select * from nt:base where jcr:path like '$0/%' order by exo:dateCreated DESC";
    private static final String ROOT_XPATH_QUERY = "//* order by @exo:dateCreated descending";
    private static final String XPATH_QUERY = "/jcr:root$0//* order by @exo:dateCreated descending";
    private static final String CHANGE_OPTION = "ChangeOption";
    private boolean isEdit_ = false;
    private String queryPath_;
    private Query query_ = null;

    public UIJCRAdvancedSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption("SQL", (Object)"sql"));
        ls.add(new SelectItemOption("xPath", (Object)"xpath"));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_SELECT_BOX, FIELD_SELECT_BOX, ls);
        uiSelectBox.setOnChange("Change");
        this.addUIFormInput((UIFormInput)uiSelectBox);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_QUERY, FIELD_QUERY, null));
        this.setActions(new String[]{"Search", "Save", "Cancel"});
    }

    public void update(Query query) throws Exception {
        if (query == null) {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            Node selectedNode = uiExplorer.getCurrentNode();
            String path = selectedNode.getPath();
            String queryText = StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)path);
            if ("/".equals(path)) {
                queryText = ROOT_SQL_QUERY;
            }
            this.getUIStringInput(FIELD_NAME).setValue(null);
            this.getUIStringInput(FIELD_NAME).setEditable(true);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setOnChange(CHANGE_OPTION);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setValue("sql");
            this.getUIFormTextAreaInput(FIELD_QUERY).setValue((Object)queryText);
        } else {
            String storedPath;
            this.queryPath_ = storedPath = query.getStoredQueryPath();
            storedPath = storedPath.substring(storedPath.lastIndexOf("/") + 1, storedPath.length());
            this.getUIStringInput(FIELD_NAME).setValue((Object)storedPath);
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setOnChange(CHANGE_OPTION);
            this.getUIFormSelectBox(FIELD_SELECT_BOX).setValue(query.getLanguage());
            this.getUIFormTextAreaInput(FIELD_QUERY).setValue((Object)query.getStatement());
        }
    }

    public void setQuery(Query query) {
        this.query_ = query;
    }

    public void setIsEdit(boolean isEdit) {
        this.isEdit_ = isEdit;
    }

    public boolean isEdit() {
        return this.isEdit_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ boolean access$000(UIJCRAdvancedSearch x0) {
        return x0.isEdit_;
    }

    static /* synthetic */ Query access$100(UIJCRAdvancedSearch x0) {
        return x0.query_;
    }

    static /* synthetic */ String access$200(UIJCRAdvancedSearch x0) {
        return x0.queryPath_;
    }
}

