/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.SearchResultPageList;
import org.exoplatform.ecm.webui.component.explorer.search.UIQueryResultPageIterator;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/search/UISearchResult.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={OpenFolderActionListener.class}), @EventConfig(listeners={SortASCActionListener.class}), @EventConfig(listeners={SortDESCActionListener.class})})
public class UISearchResult
extends UIContainer {
    private QueryResult queryResult_;
    private long searchTime_ = 0L;
    private boolean flag_ = false;
    private boolean isQuickSearch_ = false;
    private UIQueryResultPageIterator uiPageIterator_;
    private List<Node> currentListNodes_ = new ArrayList();
    private List<Row> currentListRows_ = new ArrayList();
    private int currentAvailablePage_ = 0;
    private boolean isEndOfIterator_ = false;
    private static String iconType = "";
    private static String iconScore = "";
    private static int PAGE_SIZE = 10;

    public UISearchResult() throws Exception {
        this.uiPageIterator_ = (UIQueryResultPageIterator)this.addChild(UIQueryResultPageIterator.class, null, null);
    }

    public void setIsQuickSearch(boolean isQuickSearch) {
        this.isQuickSearch_ = isQuickSearch;
    }

    public void setQueryResults(QueryResult queryResult) throws Exception {
        this.queryResult_ = queryResult;
    }

    public long getSearchTime() {
        return this.searchTime_;
    }

    public void setSearchTime(long time) {
        this.searchTime_ = time;
    }

    public List getCurrentList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public DateFormat getSimpleDateFormat() {
        Locale locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale();
        return SimpleDateFormat.getDateTimeInstance(3, 3, locale);
    }

    private void addNode(List<Node> listNodes, Node node, List<Row> listRows, Row r) throws Exception {
        List<Object> checkList = new ArrayList();
        checkList = this.flag_ ? this.currentListNodes_ : listNodes;
        if (node.getName().equals("jcr:content")) {
            if (!checkList.contains(node.getParent())) {
                listNodes.add(node.getParent());
                listRows.add(r);
            }
        } else if (!checkList.contains(node)) {
            listNodes.add(node);
            listRows.add(r);
        }
    }

    public Session getSession() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getSession();
    }

    public Date getDateCreated(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            return node.getProperty("exo:dateCreated").getDate().getTime();
        }
        return new GregorianCalendar().getTime();
    }

    public List<Row> getResultList() throws Exception {
        ArrayList listNodes = new ArrayList();
        ArrayList listRows = new ArrayList();
        long resultListSize = this.queryResult_.getNodes().getSize();
        if (!this.queryResult_.getRows().hasNext()) {
            return this.currentListRows_;
        }
        if (resultListSize > 100L) {
            RowIterator iter = this.queryResult_.getRows();
            while (iter.hasNext()) {
                Row r = iter.nextRow();
                String path = r.getValue("jcr:path").getString();
                JCRPath nodePath = ((SessionImpl)this.getSession()).getLocationFactory().parseJCRPath(path);
                Node resultNode = (Node)this.getSession().getItem(nodePath.getAsString(false));
                this.addNode(listNodes, resultNode, listRows, r);
                if (!iter.hasNext()) {
                    this.isEndOfIterator_ = true;
                }
                if (listNodes.size() == 100) {
                    this.currentListNodes_.addAll(listNodes);
                    this.currentListRows_.addAll(listRows);
                    break;
                }
                if (listNodes.size() >= 100 || !iter.hasNext()) continue;
                this.currentListNodes_.addAll(listNodes);
                this.currentListRows_.addAll(listRows);
                this.flag_ = true;
            }
        } else {
            RowIterator iter = this.queryResult_.getRows();
            while (iter.hasNext()) {
                Row r = iter.nextRow();
                if (!iter.hasNext()) {
                    this.isEndOfIterator_ = true;
                }
                String path = r.getValue("jcr:path").getString();
                JCRPath nodePath = ((SessionImpl)this.getSession()).getLocationFactory().parseJCRPath(path);
                Node resultNode = (Node)this.getSession().getItem(nodePath.getAsString(false));
                this.addNode(listNodes, resultNode, listRows, r);
            }
            this.currentListNodes_ = listNodes;
            this.currentListRows_ = listRows;
        }
        return this.currentListRows_;
    }

    public void clearAll() {
        this.flag_ = false;
        this.isEndOfIterator_ = false;
        this.currentListNodes_.clear();
    }

    public UIQueryResultPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public void updateGrid(boolean flagCheck) throws Exception {
        SearchResultPageList pageList = flagCheck ? new SearchResultPageList(this.queryResult_, this.getResultList(), PAGE_SIZE, this.isEndOfIterator_) : new SearchResultPageList(this.queryResult_, this.currentListRows_, PAGE_SIZE, this.isEndOfIterator_);
        this.currentAvailablePage_ = this.currentListNodes_.size() / PAGE_SIZE;
        this.uiPageIterator_.setSearchResultPageList(pageList);
        this.uiPageIterator_.setPageList((PageList)pageList);
    }

    public int getCurrentAvaiablePage() {
        return this.currentAvailablePage_;
    }

    public String StriptHTML(String s) {
        String[] targets;
        for (String target : targets = new String[]{"<div>", "</div>", "<span>", "</span>"}) {
            s = s.replace(target, "");
        }
        return s;
    }

    static /* synthetic */ String access$000() {
        return iconType;
    }

    static /* synthetic */ String access$100() {
        return iconScore;
    }

    static /* synthetic */ boolean access$200(UISearchResult x0) {
        return x0.isQuickSearch_;
    }

    static /* synthetic */ String access$002(String x0) {
        iconType = x0;
        return iconType;
    }

    static /* synthetic */ String access$102(String x0) {
        iconScore = x0;
        return iconScore;
    }

    static /* synthetic */ List access$300(UISearchResult x0) {
        return x0.currentListRows_;
    }

    static /* synthetic */ QueryResult access$500(UISearchResult x0) {
        return x0.queryResult_;
    }

    static /* synthetic */ int access$600() {
        return PAGE_SIZE;
    }

    static /* synthetic */ boolean access$700(UISearchResult x0) {
        return x0.isEndOfIterator_;
    }

    static /* synthetic */ int access$802(UISearchResult x0, int x1) {
        x0.currentAvailablePage_ = x1;
        return x0.currentAvailablePage_;
    }

    static /* synthetic */ List access$900(UISearchResult x0) {
        return x0.currentListNodes_;
    }

    static /* synthetic */ UIQueryResultPageIterator access$1000(UISearchResult x0) {
        return x0.uiPageIterator_;
    }
}

