/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadForm;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIFormMultiValueInputSet.class, id="UploadMultipleInputset", events={@EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIUploadForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_UPLOAD = "upload";
    public static final String JCRCONTENT = "jcr:content";
    public static final String FIELD_TAXONOMY = "fieldTaxonomy";
    public static final String FIELD_LISTTAXONOMY = "fieldListTaxonomy";
    public static final String POPUP_TAXONOMY = "UIPopupTaxonomy";
    private static final String TAXONOMIES_ALIAS = "exoTaxonomiesPath";
    private boolean isMultiLanguage_ = false;
    private String language_ = null;
    private boolean isDefault_ = false;
    private List<String> listTaxonomy = new ArrayList();
    private List<String> listTaxonomyName = new ArrayList();

    public UIUploadForm() throws Exception {
        this.setMultiPart(true);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null));
        UIFormUploadInput uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public List<String> getlistTaxonomyName() {
        return this.listTaxonomyName;
    }

    public void setListTaxonomy(List<String> listTaxonomyNew) {
        this.listTaxonomy = listTaxonomyNew;
    }

    public void setListTaxonomyName(List<String> listTaxonomyNameNew) {
        this.listTaxonomyName = listTaxonomyNameNew;
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        Session session = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getSession();
        return ((Node)session.getItem(nodeHierarchyCreator.getJcrPath(TAXONOMIES_ALIAS))).getPath();
    }

    public void initFieldInput() throws Exception {
        UIJCRExplorer uiExplorer;
        Node currentNode;
        CategoriesService categoriesService = (CategoriesService)this.getApplicationComponent(CategoriesService.class);
        if (categoriesService.hasCategories(currentNode = (uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode())) {
            Value[] values = currentNode.getProperty("exo:category").getValues();
            for (int i = 0; i < values.length; ++i) {
                String path = uiExplorer.getSession().getNodeByUUID(values[i].getString()).getPath();
                if (this.listTaxonomy.contains(path)) continue;
                this.listTaxonomy.add(path);
                this.listTaxonomyName.add(this.cutPath(path));
            }
        }
        UIFormMultiValueInputSet uiFormMultiValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, "UploadMultipleInputset", null);
        uiFormMultiValue.setId(FIELD_LISTTAXONOMY);
        uiFormMultiValue.setName(FIELD_LISTTAXONOMY);
        uiFormMultiValue.setType(UIFormStringInput.class);
        uiFormMultiValue.setValue(this.listTaxonomyName);
        this.addUIFormInput((UIFormInput)uiFormMultiValue);
    }

    private String cutPath(String path) {
        String[] array = path.split("/");
        String value = "";
        if (array.length > 4) {
            for (int i = 4; i < array.length; ++i) {
                value = value + array[i].trim();
                if (i >= array.length - 1) continue;
                value = value + "/";
            }
        } else {
            value = path;
        }
        return value;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void setIsMultiLanguage(boolean isMultiLanguage, String language) {
        this.isMultiLanguage_ = isMultiLanguage;
        this.language_ = language;
    }

    public void resetComponent() {
        this.removeChildById(FIELD_UPLOAD);
        this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD));
    }

    public boolean isMultiLanguage() {
        return this.isMultiLanguage_;
    }

    public void setIsDefaultLanguage(boolean isDefault) {
        this.isDefault_ = isDefault;
    }

    private String getLanguageSelected() {
        return this.language_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String valueTaxonomy = String.valueOf(value).trim();
        if (!this.listTaxonomy.contains(valueTaxonomy)) {
            this.listTaxonomy.add(valueTaxonomy);
            this.listTaxonomyName.add(this.cutPath(valueTaxonomy));
        }
        this.updateAdvanceTaxonomy();
        UIUploadManager uiUploadManager = (UIUploadManager)this.getParent();
        uiUploadManager.removeChildById(POPUP_TAXONOMY);
    }

    private void updateAdvanceTaxonomy() throws Exception {
        UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)this.getChild(UIFormMultiValueInputSet.class);
        uiFormMultiValueInputSet.setValue(this.listTaxonomyName);
    }

    static /* synthetic */ String access$000(UIUploadForm x0) {
        return x0.getLanguageSelected();
    }

    static /* synthetic */ boolean access$100(UIUploadForm x0) {
        return x0.isDefault_;
    }

    static /* synthetic */ boolean access$200(UIUploadForm x0) {
        return x0.isMultiLanguage_;
    }
}

