/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contentvalidation.webui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.presentation.AbstractActionComponent;
import org.exoplatform.ecm.webui.presentation.NodePresentation;
import org.exoplatform.ecm.webui.presentation.removeattach.RemoveAttachmentComponent;
import org.exoplatform.ecm.webui.presentation.removecomment.RemoveCommentComponent;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.workflow.webui.component.controller.UITaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:resources/templates/controller/UIDocumentContent.gtmpl", events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIDocumentContent
extends UIContainer
implements NodePresentation {
    private Node node_;
    public static final String DEFAULT_LANGUAGE = "default".intern();
    private String language_ = DEFAULT_LANGUAGE;

    public void setNode(Node node) {
        this.node_ = node;
    }

    public Node getNode() throws Exception {
        if (this.node_.hasProperty("exo:language")) {
            String defaultLang = this.node_.getProperty("exo:language").getString();
            if (!this.language_.equals(DEFAULT_LANGUAGE) && !this.language_.equals(defaultLang)) {
                Node curNode = this.node_.getNode("languages/" + this.language_);
                this.language_ = defaultLang;
                return curNode;
            }
        }
        return this.node_;
    }

    public UIComponent getCommentComponent() {
        return this;
    }

    public UIComponent getRemoveAttach() throws Exception {
        this.removeChild(RemoveAttachmentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveAttachmentComponent.class, null, "DocumentContentRemoveAttach");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public UIComponent getRemoveComment() throws Exception {
        this.removeChild(RemoveCommentComponent.class);
        UIComponent uicomponent = this.addChild(RemoveCommentComponent.class, null, "DocumentContentRemoveComment");
        ((AbstractActionComponent)uicomponent).setLstComponentupdate(Arrays.asList(UIPopupWindow.class));
        return uicomponent;
    }

    public Node getOriginalNode() throws Exception {
        return this.node_;
    }

    public String getNodeType() throws Exception {
        return this.node_.getPrimaryNodeType().getName();
    }

    public String getTemplate() {
        try {
            if (this.isNodeTypeSupported()) {
                return this.getTemplatePath();
            }
            return super.getTemplate();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            return new JCRResourceResolver(this.getRepository(), this.getWorkspaceName(), "exo:templateFile");
        }
        catch (Exception e) {
            e.printStackTrace();
            return super.getTemplateResourceResolver(context, template);
        }
    }

    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String nodeTypeName = this.node_.getPrimaryNodeType().getName();
            return templateService.isManagedNodeType(nodeTypeName, this.getRepository());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public Node getNodeByPath(String nodePath, String workspace) throws Exception {
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.getRepository());
        Session session = SessionProviderFactory.createSystemProvider().getSession(workspace, manageRepo);
        return (Node)session.getItem(nodePath);
    }

    public String getCapacityOfFile(Node file) throws Exception {
        Node contentNode = file.getNode("jcr:content");
        InputStream in = contentNode.getProperty("jcr:data").getStream();
        float capacity = in.available() / 1024;
        String strCapacity = Float.toString(capacity);
        if (strCapacity.indexOf(".") > -1) {
            return strCapacity.substring(0, strCapacity.lastIndexOf("."));
        }
        return strCapacity;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        try {
            Value[] vals;
            for (Value val : vals = this.node_.getProperty("exo:relation").getValues()) {
                String uuid = val.getString();
                Node relationNode = this.getNodeByUUID(uuid);
                relations.add(relationNode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relations;
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        ManageableRepository manageRepo = (ManageableRepository)this.node_.getSession().getRepository();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        for (String ws : manageRepo.getWorkspaceNames()) {
            try {
                return sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private List<String> getListAllowedFileType(Node currentNode, String repository) throws Exception {
        ArrayList<String> nodeTypes = new ArrayList<String>();
        NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
        NodeType currentNodeType = currentNode.getPrimaryNodeType();
        NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List templates = templateService.getDocumentTemplates(repository);
        try {
            block2: for (int i = 0; i < templates.size(); ++i) {
                String nodeTypeName = templates.get(i).toString();
                NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                NodeType[] superTypes = nodeType.getSupertypes();
                boolean isCanCreateDocument = false;
                for (NodeDefinition nodeDefinition : childDefs) {
                    NodeType[] requiredChilds;
                    for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                        if (!nodeTypeName.equals(requiredChild.getName())) continue;
                        isCanCreateDocument = true;
                        break;
                    }
                    if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                    if (!nodeTypes.contains(nodeTypeName)) {
                        nodeTypes.add(nodeTypeName);
                    }
                    isCanCreateDocument = true;
                }
                if (isCanCreateDocument) continue;
                for (NodeDefinition nodeDefinition : superTypes) {
                    for (NodeDefinition childDef : childDefs) {
                        for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                            if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                            if (!nodeTypes.contains(nodeTypeName)) {
                                nodeTypes.add(nodeTypeName);
                            }
                            isCanCreateDocument = true;
                            break;
                        }
                        if (isCanCreateDocument) break;
                    }
                    if (isCanCreateDocument) continue block2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodeTypes;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        String nodeType = "";
        NodeIterator childrenIterator = this.node_.getNodes();
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            try {
                nodeType = childNode.getPrimaryNodeType().getName();
                List<String> listCanCreateNodeType = this.getListAllowedFileType(this.node_, this.getRepository());
                if (!listCanCreateNodeType.contains(nodeType)) continue;
                attachments.add(childNode);
            }
            catch (Exception e) {}
        }
        return attachments;
    }

    public String getRssLink() {
        return null;
    }

    public boolean isRssLink() {
        return false;
    }

    public List getSupportedLocalise() throws Exception {
        ArrayList<String> local = new ArrayList<String>();
        if (this.node_.hasNode("languages")) {
            Node languages = this.node_.getNode("languages");
            NodeIterator iter = languages.getNodes();
            while (iter.hasNext()) {
                local.add(iter.nextNode().getName());
            }
            local.add(this.node_.getProperty("exo:language").getString());
        }
        return local;
    }

    public String getTemplatePath() throws Exception {
        String nodeTypeName = this.node_.getPrimaryNodeType().getName();
        String userName = Util.getPortalRequestContext().getRemoteUser();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return templateService.getTemplatePathByUser(false, nodeTypeName, userName, this.getRepository());
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, this.getRepository());
    }

    public String getTemplateSkin(String nodeTypeName, String skinName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getSkinPath(nodeTypeName, skinName, this.getLanguage(), this.getRepository());
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.node_, "default");
    }

    public String getIcons(Node node, String appended) throws Exception {
        String nodeType = node.getPrimaryNodeType().getName().replaceAll(":", "_") + appended;
        StringBuilder str = new StringBuilder(nodeType);
        if (node.isNodeType("nt:file")) {
            Node jcrContentNode = node.getNode("jcr:content");
            str.append(" ").append(jcrContentNode.getProperty("jcr:mimeType").getString().replaceFirst("/", "_")).append(appended);
        }
        return str.toString();
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getLanguage() {
        return this.language_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return service;
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            return null;
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public String getWorkspaceName() throws Exception {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        return dmsConfiguration.getConfig(this.getRepository()).getSystemWorkspace();
    }

    public String getRepository() throws Exception {
        ManageableRepository manaRepo = (ManageableRepository)this.node_.getSession().getRepository();
        return manaRepo.getConfiguration().getName();
    }

    public String encodeHTML(String text) throws Exception {
        return text.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals("nt:file")) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIDocumentContent> {
        public void execute(Event<UIDocumentContent> event) throws Exception {
            UIDocumentContent uiComp = (UIDocumentContent)((Object)event.getSource());
            RepositoryService repositoryService = (RepositoryService)uiComp.getApplicationComponent(RepositoryService.class);
            ManageableRepository repository = repositoryService.getRepository(uiComp.getRepository());
            String uri = event.getRequestContext().getRequestParameter("objectId");
            String workspaceName = event.getRequestContext().getRequestParameter("workspaceName");
            Session session = SessionProviderFactory.createSessionProvider().getSession(workspaceName, repository);
            Node selectedNode = (Node)session.getItem(uri);
            uiComp.setNode(selectedNode);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiComp.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DownloadActionListener
    extends EventListener<UIDocumentContent> {
        public void execute(Event<UIDocumentContent> event) throws Exception {
            UIDocumentContent uiComp = (UIDocumentContent)((Object)event.getSource());
            String downloadLink = uiComp.getDownloadLink(uiComp.getFileLangNode(uiComp.getNode()));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLanguageActionListener
    extends EventListener<UIDocumentContent> {
        public void execute(Event<UIDocumentContent> event) throws Exception {
            UIDocumentContent uiDocContent = (UIDocumentContent)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiDocContent.getAncestorOfType(UITaskManager.class));
            String selectedLanguage = event.getRequestContext().getRequestParameter("objectId");
            uiDocContent.setRenderSibbling(UIDocumentContent.class);
            uiDocContent.setLanguage(selectedLanguage);
        }
    }
}

