/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.relations.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationsServiceImpl
implements RelationsService,
Startable {
    private static final String RELATION_MIXIN = "exo:relationable";
    private static final String RELATION_PROP = "exo:relation";
    private RepositoryService repositoryService_;
    String repositories_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public RelationsServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params) {
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositories_ = params.getValueParam("repositories").getValue();
    }

    @Override
    public boolean hasRelations(Node node) throws Exception {
        return node.isNodeType(RELATION_MIXIN);
    }

    private Node getNodeByUUID(String uuid, String repository, SessionProvider provider) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = this.repositoryService_.getRepository(repository);
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    @Override
    public List<Node> getRelations(Node node, String repository, SessionProvider provider) {
        ArrayList<Node> rels = new ArrayList<Node>();
        try {
            if (node.hasProperty(RELATION_PROP)) {
                Value[] values = node.getProperty(RELATION_PROP).getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (this.getNodeByUUID(values[i].getString(), repository, provider) == null) continue;
                    rels.add(this.getNodeByUUID(values[i].getString(), repository, provider));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return rels;
    }

    @Override
    public void removeRelation(Node node, String relationPath, String repository) throws Exception {
        ArrayList<Value> vals = new ArrayList<Value>();
        if (!"*".equals(relationPath)) {
            SessionProvider provider = SessionProvider.createSystemProvider();
            Property relations = node.getProperty(RELATION_PROP);
            if (relations != null) {
                Value[] values = relations.getValues();
                String uuid2Remove = null;
                for (int i = 0; i < values.length; ++i) {
                    String uuid = values[i].getString();
                    Node refNode = this.getNodeByUUID(uuid, repository, provider);
                    if (refNode == null) continue;
                    if (refNode.getPath().equals(relationPath)) {
                        uuid2Remove = uuid;
                        continue;
                    }
                    vals.add(values[i]);
                }
                if (uuid2Remove == null) {
                    return;
                }
            }
        }
        node.setProperty(RELATION_PROP, vals.toArray(new Value[vals.size()]));
        node.save();
    }

    @Override
    public void addRelation(Node node, String relationPath, String workpace, String repository) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        Session session = this.getSession(repository, workpace, provider);
        Node catNode = (Node)session.getItem(relationPath);
        if (!catNode.isNodeType("mix:referenceable")) {
            catNode.addMixin("mix:referenceable");
            catNode.save();
            session.save();
        }
        Value value2add = session.getValueFactory().createValue(catNode);
        if (!node.isNodeType(RELATION_MIXIN)) {
            node.addMixin(RELATION_MIXIN);
            node.setProperty(RELATION_PROP, new Value[]{value2add});
            node.save();
            session.save();
        } else {
            ArrayList<Value> vals = new ArrayList<Value>();
            Value[] values = node.getProperty(RELATION_PROP).getValues();
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = null;
                try {
                    refNode = this.getNodeByUUID(uuid, repository, provider);
                }
                catch (ItemNotFoundException ie) {
                    this.removeRelation(node, relationPath, repository);
                    continue;
                }
                if (refNode.getPath().equals(relationPath)) {
                    return;
                }
                vals.add(value);
            }
            vals.add(value2add);
            node.setProperty(RELATION_PROP, vals.toArray(new Value[vals.size()]));
            node.save();
            session.save();
        }
    }

    public void start() {
        block4: {
            Session session = null;
            Node relationsHome = null;
            try {
                String[] repositories;
                String relationPath = this.nodeHierarchyCreator_.getJcrPath("cmsPublicationsPath");
                for (String repo : repositories = this.repositories_.split(",")) {
                    session = this.getSession(repo.trim());
                    relationsHome = (Node)session.getItem(relationPath);
                    NodeIterator iterator = relationsHome.getNodes();
                    while (iterator.hasNext()) {
                        Node rel = iterator.nextNode();
                        rel.addMixin("mix:referenceable");
                    }
                    relationsHome.save();
                    session.save();
                    session.logout();
                }
            }
            catch (Exception e) {
                if (session == null || !session.isLive()) break block4;
                session.logout();
            }
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        Session session = this.getSession(repository);
        String relationPath = this.nodeHierarchyCreator_.getJcrPath("cmsPublicationsPath");
        try {
            Node relationsHome = (Node)session.getItem(relationPath);
            NodeIterator iterator = relationsHome.getNodes();
            while (iterator.hasNext()) {
                Node rel = iterator.nextNode();
                rel.addMixin("mix:referenceable");
            }
            relationsHome.save();
        }
        catch (Exception e) {
            // empty catch block
        }
        session.logout();
    }

    protected Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String workspaceName = manageableRepository.getConfiguration().getSystemWorkspaceName();
        return manageableRepository.getSystemSession(workspaceName);
    }

    private Session getSession(String repository, String workspace, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        return provider.getSession(workspace, manageableRepository);
    }
}

