/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class TemplatePlugin
extends BaseComponentPlugin {
    public static final String DIALOGS = "dialogs".intern();
    public static final String VIEWS = "views".intern();
    public static final String DEFAULT_DIALOG = "dialog1".intern();
    public static final String DEFAULT_VIEW = "view1".intern();
    static final String[] UNDELETABLE_TEMPLATES = new String[]{DEFAULT_DIALOG, DEFAULT_VIEW};
    public static final String DEFAULT_DIALOGS_PATH = "/" + DIALOGS + "/" + DEFAULT_DIALOG;
    public static final String DEFAULT_VIEWS_PATH = "/" + VIEWS + "/" + DEFAULT_VIEW;
    public static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    public static final String EXO_TEMPLATE = "exo:template".intern();
    public static final String EXO_ROLES_PROP = "exo:roles".intern();
    public static final String EXO_TEMPLATE_FILE_PROP = "exo:templateFile".intern();
    public static final String DOCUMENT_TEMPLATE_PROP = "isDocumentTemplate".intern();
    public static final String TEMPLATE_LABEL = "label".intern();
    private RepositoryService repositoryService_;
    private ConfigurationManager configManager_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String cmsTemplatesBasePath_;
    private InitParams params_;
    private String storedLocation_;
    private boolean autoCreateInNewRepository_ = false;

    public TemplatePlugin(InitParams params, RepositoryService jcrService, ConfigurationManager configManager, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = jcrService;
        this.configManager_ = configManager;
        this.cmsTemplatesBasePath_ = this.nodeHierarchyCreator_.getJcrPath("templatesPath");
        this.params_ = params;
        ValueParam locationParam = this.params_.getValueParam("storedLocation");
        this.storedLocation_ = locationParam.getValue();
        ValueParam param = this.params_.getValueParam("autoCreateInNewRepository");
        if (param != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(param.getValue());
        }
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            List repositories = this.repositoryService_.getConfig().getRepositoryConfigurations();
            for (RepositoryEntry repo : repositories) {
                this.importPredefineTemplates(repo.getName());
            }
        } else {
            ValueParam valueParam = this.params_.getValueParam("repository");
            String repository = null;
            repository = valueParam != null ? valueParam.getValue() : this.repositoryService_.getDefaultRepository().getConfiguration().getName();
            this.importPredefineTemplates(repository);
        }
    }

    public void init(String repository) throws Exception {
        if (this.autoCreateInNewRepository_) {
            this.importPredefineTemplates(repository);
        }
    }

    private void addTemplate(TemplateConfig templateConfig, Node templatesHome, String storedLocation) throws Exception {
        List<TemplateConfig.NodeType> nodetypes = templateConfig.getNodeTypes();
        TemplateConfig.NodeType nodeType2 = null;
        for (TemplateConfig.NodeType nodeType2 : nodetypes) {
            Node nodeTypeHome = null;
            nodeTypeHome = Utils.makePath(templatesHome, nodeType2.getNodetypeName(), NT_UNSTRUCTURED);
            if (nodeType2.getDocumentTemplate()) {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
            } else {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
            }
            nodeTypeHome.setProperty(TEMPLATE_LABEL, nodeType2.getLabel());
            List dialogs = nodeType2.getReferencedDialog();
            Node dialogsHome = Utils.makePath(nodeTypeHome, DIALOGS, NT_UNSTRUCTURED);
            this.addNode(storedLocation, dialogsHome, dialogs);
            List views = nodeType2.getReferencedView();
            Node viewsHome = Utils.makePath(nodeTypeHome, VIEWS, NT_UNSTRUCTURED);
            this.addNode(storedLocation, viewsHome, views);
        }
    }

    public void setBasePath(String basePath) {
        this.cmsTemplatesBasePath_ = basePath;
    }

    private void importPredefineTemplates(String repositoryName) throws Exception {
        Object object;
        ManageableRepository repository = this.repositoryService_.getRepository(repositoryName);
        String workspace = repository.getConfiguration().getDefaultWorkspaceName();
        Session session = repository.getSystemSession(workspace);
        Node templatesHome = Utils.makePath(session.getRootNode(), this.cmsTemplatesBasePath_, NT_UNSTRUCTURED);
        TemplateConfig templateConfig = null;
        Iterator iter = this.params_.getObjectParamIterator();
        while (iter.hasNext() && (object = ((ObjectParameter)iter.next()).getObject()) instanceof TemplateConfig) {
            templateConfig = (TemplateConfig)object;
            this.addTemplate(templateConfig, templatesHome, this.storedLocation_);
        }
        session.save();
        session.logout();
    }

    private void addNode(String basePath, Node nodeTypeHome, List templates) throws Exception {
        for (TemplateConfig.Template template : templates) {
            String templateFileName = template.getTemplateFile();
            String path = basePath + templateFileName;
            InputStream in = this.configManager_.getInputStream(path);
            String nodeName = templateFileName.substring(templateFileName.lastIndexOf("/") + 1, templateFileName.indexOf("."));
            if (nodeTypeHome.hasNode(nodeName)) {
                return;
            }
            Node contentNode = nodeTypeHome.addNode(nodeName, EXO_TEMPLATE);
            contentNode.setProperty(EXO_ROLES_PROP, template.getParsedRoles());
            contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, in);
        }
    }
}

