/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.voting.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.voting.VotingService;

public class VotingServiceImpl
implements VotingService {
    static final String VOTABLE = "mix:votable".intern();
    static final String VOTER_PROP = "exo:voter".intern();
    static final String VOTING_RATE_PROP = "exo:votingRate".intern();
    static final String VOTE_TOTAL_PROP = "exo:voteTotal".intern();
    static final String VOTE_TOTAL_LANG_PROP = "exo:voteTotalOfLang".intern();
    private static final String LANGUAGES = "languages".intern();
    private MultiLanguageService multiLangService_;

    public VotingServiceImpl(MultiLanguageService multiLangService) {
        this.multiLangService_ = multiLangService;
    }

    public long getVoteTotal(Node node) throws Exception {
        long voteTotal = 0L;
        if (!node.hasNode(LANGUAGES) && node.hasProperty(VOTE_TOTAL_PROP)) {
            return node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        Node multiLanguages = node.getNode(LANGUAGES);
        voteTotal = node.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        NodeIterator nodeIter = multiLanguages.getNodes();
        while (nodeIter.hasNext()) {
            Node languageNode = nodeIter.nextNode();
            if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                languageNode = this.getFileLangNode(languageNode);
            }
            if (!languageNode.hasProperty(VOTE_TOTAL_LANG_PROP)) continue;
            voteTotal += languageNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        }
        return voteTotal;
    }

    public Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals("nt:file")) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }

    public void vote(Node node, double rate, String userName, String language) throws Exception {
        Session session = node.getSession();
        if (!node.isNodeType(VOTABLE)) {
            if (node.canAddMixin(VOTABLE)) {
                node.addMixin(VOTABLE);
            } else {
                throw new NoSuchNodeTypeException();
            }
        }
        String defaultLang = this.multiLangService_.getDefault(node);
        Node multiLanguages = null;
        Node languageNode = null;
        if (language.equals(defaultLang)) {
            languageNode = node;
        } else if (node.hasNode(LANGUAGES) && (multiLanguages = node.getNode(LANGUAGES)).hasNode(language)) {
            languageNode = multiLanguages.getNode(language);
            if (node.getPrimaryNodeType().getName().equals("nt:file")) {
                languageNode = this.getFileLangNode(languageNode);
            }
        }
        long voteTotalOfLang = languageNode.getProperty(VOTE_TOTAL_LANG_PROP).getLong();
        double votingRate = languageNode.getProperty(VOTING_RATE_PROP).getDouble();
        double newRating = ((double)voteTotalOfLang * votingRate + rate) / (double)(voteTotalOfLang + 1L);
        DecimalFormat format = new DecimalFormat("###.##");
        double fomatedRating = format.parse(format.format(newRating)).doubleValue();
        Value[] voters = new Value[]{};
        if (languageNode.hasProperty(VOTER_PROP)) {
            voters = languageNode.getProperty(VOTER_PROP).getValues();
        }
        Value newVoter = session.getValueFactory().createValue(userName);
        ArrayList<Value> newVoterList = new ArrayList<Value>();
        newVoterList.addAll(Arrays.asList(voters));
        newVoterList.add(newVoter);
        node.setProperty(VOTE_TOTAL_PROP, this.getVoteTotal(node) + 1L);
        languageNode.setProperty(VOTE_TOTAL_LANG_PROP, voteTotalOfLang + 1L);
        languageNode.setProperty(VOTING_RATE_PROP, fomatedRating);
        languageNode.setProperty(VOTER_PROP, newVoterList.toArray(new Value[newVoterList.size()]));
        node.save();
        session.save();
        session.logout();
    }
}

