/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.actions.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.actions.ActionPlugin;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.BaseActionPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionServiceContainerImpl
implements ActionServiceContainer,
Startable {
    private static final String ACTIONABLE = "exo:actionable".intern();
    private static final String ACTION = "exo:action".intern();
    private static final String JOB_NAME_PROP = "exo:jobName".intern();
    private static final String JOB_GROUP_PROP = "exo:jobGroup".intern();
    private static final String JOB_CLASS_PROP = "exo:jobClass".intern();
    private static final String LIFECYCLE_PHASE_PROP = "exo:lifecyclePhase".intern();
    private static final String ACTION_QUERY = "//element(*, exo:action)".intern();
    private static final String SCHEDULABLE_MIXIN = "exo:schedulableInfo".intern();
    private static final String EXO_ACTIONS = "exo:actions".intern();
    private static final String ACTION_STORAGE = "exo:actionStorage".intern();
    private RepositoryService repositoryService_;
    private CmsService cmsService_;
    private Collection<ComponentPlugin> actionPlugins = new ArrayList<ComponentPlugin>();

    public ActionServiceContainerImpl(InitParams params, RepositoryService repositoryService, CmsService cmsService) throws Exception {
        this.repositoryService_ = repositoryService;
        this.cmsService_ = cmsService;
    }

    public void start() {
        try {
            for (BaseActionPlugin baseActionPlugin : this.actionPlugins) {
                baseActionPlugin.importPredefinedActionsInJcr();
            }
            this.initiateActionConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) {
        try {
            for (BaseActionPlugin baseActionPlugin : this.actionPlugins) {
                baseActionPlugin.reImportPredefinedActionsInJcr(repository);
            }
            this.reInitiateActionConfiguration(repository);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Collection<String> getActionPluginNames() {
        ArrayList<String> actionPluginNames = new ArrayList<String>();
        for (ComponentPlugin plugin : this.actionPlugins) {
            actionPluginNames.add(plugin.getName());
        }
        return actionPluginNames;
    }

    @Override
    public ActionPlugin getActionPlugin(String actionsServiceName) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            if (!plugin.getName().equals(actionsServiceName)) continue;
            return (ActionPlugin)plugin;
        }
        return null;
    }

    @Override
    public void createActionType(String actionTypeName, String parentActionTypeName, String executable, List<String> variableNames, boolean isMoveType, String repository) throws Exception {
        NodeTypeValue nodeTypeValue = new NodeTypeValue();
        nodeTypeValue.setName(actionTypeName);
        ArrayList<String> superTypes = new ArrayList<String>();
        superTypes.add(parentActionTypeName);
        if (isMoveType) {
            superTypes.add("exo:move");
        }
        nodeTypeValue.setDeclaredSupertypeNames(superTypes);
        ArrayList<PropertyDefinitionValue> propDefs = new ArrayList<PropertyDefinitionValue>();
        PropertyDefinitionValue propDef = null;
        for (String variableName : variableNames) {
            propDef = this.createPropertyDef(variableName);
            propDefs.add(propDef);
        }
        propDef = this.createPropertyDef(this.getActionPluginForActionType(parentActionTypeName).getExecutableDefinitionName());
        ArrayList<String> defaultValues = new ArrayList<String>();
        defaultValues.add(executable);
        propDef.setDefaultValueStrings(defaultValues);
        propDef.setMandatory(false);
        propDefs.add(propDef);
        nodeTypeValue.setDeclaredPropertyDefinitionValues(propDefs);
        nodeTypeValue.setDeclaredChildNodeDefinitionValues(new ArrayList());
        ExtendedNodeTypeManager ntmanager = this.repositoryService_.getRepository(repository).getNodeTypeManager();
        ntmanager.registerNodeType(nodeTypeValue, 0);
    }

    private PropertyDefinitionValue createPropertyDef(String name) {
        PropertyDefinitionValue def = new PropertyDefinitionValue();
        def.setName(name);
        def.setRequiredType(1);
        def.setMandatory(false);
        def.setMultiple(false);
        def.setReadOnly(false);
        def.setAutoCreate(false);
        def.setOnVersion(1);
        def.setValueConstraints(new ArrayList());
        def.setDefaultValueStrings(new ArrayList());
        return def;
    }

    @Override
    public Collection<NodeType> getCreatedActionTypes(String repository) throws Exception {
        ArrayList<NodeType> createsActions = new ArrayList<NodeType>();
        ExtendedNodeTypeManager ntmanager = this.repositoryService_.getRepository(repository).getNodeTypeManager();
        NodeTypeIterator iter = ntmanager.getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType nt = (NodeType)iter.next();
            String name = nt.getName();
            if (!nt.isNodeType(ACTION) || this.isAbstractType(name)) continue;
            createsActions.add(nt);
        }
        return createsActions;
    }

    private boolean isAbstractType(String name) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            if (!plugin.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private Session getSystemSession(String repository, String workspace) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository jcrRepository = this.repositoryService_.getRepository(repository);
        return jcrRepository.getSystemSession(workspace);
    }

    @Override
    public ActionPlugin getActionPluginForActionType(String actionTypeName) {
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
            if (!actionService.isActionTypeSupported(actionTypeName) && !actionServiceName.equals(actionTypeName)) continue;
            return actionService;
        }
        return null;
    }

    @Override
    public Node getAction(Node node, String actionName) throws Exception {
        return node.getNode(EXO_ACTIONS + "/" + actionName);
    }

    @Override
    public boolean hasActions(Node node) throws Exception {
        return node.isNodeType(ACTIONABLE);
    }

    @Override
    public List<Node> getActions(Node node) throws Exception {
        return this.getActions(node, null);
    }

    @Override
    public List<Node> getCustomActionsNode(Node node, String lifecyclePhase) throws Exception {
        try {
            return this.getActions(node.getParent(), lifecyclePhase);
        }
        catch (Exception item) {
            return null;
        }
    }

    @Override
    public List<Node> getActions(Node node, String lifecyclePhase) throws Exception {
        ArrayList<Node> actions = new ArrayList<Node>();
        Node actionStorage = null;
        try {
            actionStorage = node.getNode(EXO_ACTIONS);
        }
        catch (Exception e) {
            return actions;
        }
        NodeIterator iter = actionStorage.getNodes();
        while (iter.hasNext()) {
            Node tmpNode = iter.nextNode();
            if (!tmpNode.isNodeType(ACTION) || lifecyclePhase != null && !lifecyclePhase.equals(tmpNode.getProperty(LIFECYCLE_PHASE_PROP).getString())) continue;
            actions.add(tmpNode);
        }
        return actions;
    }

    @Override
    public void removeAction(Node node, String actionName, String repository) throws Exception {
        if (!node.isNodeType(ACTIONABLE)) {
            return;
        }
        Node action2Remove = node.getNode(EXO_ACTIONS + "/" + actionName);
        String lifecyclePhase = action2Remove.getProperty(LIFECYCLE_PHASE_PROP).getString();
        String jobName = null;
        String jobGroup = null;
        String jobClassName = null;
        if (action2Remove.isNodeType(SCHEDULABLE_MIXIN)) {
            jobName = action2Remove.getProperty(JOB_NAME_PROP).getString();
            jobGroup = action2Remove.getProperty(JOB_GROUP_PROP).getString();
            jobClassName = action2Remove.getProperty(JOB_CLASS_PROP).getString();
        }
        String actionTypeName = action2Remove.getPrimaryNodeType().getName();
        String actionPath = action2Remove.getPath();
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionService = this.getActionPlugin(actionServiceName);
            if (!actionService.isActionTypeSupported(actionTypeName)) continue;
            if (lifecyclePhase.equals("schedule")) {
                actionService.removeActivationJob(jobName, jobGroup, jobClassName);
                continue;
            }
            actionService.removeObservation(repository, actionPath);
        }
        action2Remove.remove();
        node.save();
    }

    @Override
    public void addAction(Node storeActionNode, String repository, String actionType, Map mappings) throws Exception {
        if (!storeActionNode.isNodeType(ACTIONABLE)) {
            storeActionNode.addMixin(ACTIONABLE);
            storeActionNode.save();
        }
        Node actionsNode = null;
        if (storeActionNode.hasNode(EXO_ACTIONS)) {
            actionsNode = storeActionNode.getNode(EXO_ACTIONS);
        } else {
            actionsNode = storeActionNode.addNode(EXO_ACTIONS, ACTION_STORAGE);
            storeActionNode.save();
        }
        String newActionPath = this.cmsService_.storeNode(actionType, actionsNode, mappings, true, repository);
        storeActionNode.save();
        String srcWorkspace = storeActionNode.getSession().getWorkspace().getName();
        String srcPath = storeActionNode.getPath();
        ActionPlugin actionService = this.getActionPluginForActionType(actionType);
        if (actionService == null) {
            throw new ClassNotFoundException("Not found any action's service compatible with action type " + actionType);
        }
        try {
            actionService.addAction(actionType, repository, srcWorkspace, srcPath, mappings);
        }
        catch (Exception e) {
            Session session = this.getSystemSession(repository, storeActionNode.getSession().getWorkspace().getName());
            Node actionNode = (Node)session.getItem(newActionPath);
            actionNode.remove();
            session.save();
            session.logout();
        }
    }

    @Override
    public void executeAction(String userId, Node node, String actionName, String repository) throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("initiator", userId);
        variables.put("actionName", actionName);
        variables.put("nodePath", node.getPath());
        variables.put("srcWorkspace", node.getSession().getWorkspace().getName());
        variables.put("srcPath", node.getParent().getPath());
        NodeType nodeType = node.getPrimaryNodeType();
        String nodeTypeName = nodeType.getName();
        variables.put("document-type", nodeTypeName);
        Node parentNode = node.getParent();
        Node actionNode = parentNode.getNode(EXO_ACTIONS + "/" + actionName);
        NodeType actionNodeType = actionNode.getPrimaryNodeType();
        this.fillVariables(actionNode, actionNodeType, variables);
        NodeType[] actionMixinTypes = actionNode.getMixinNodeTypes();
        for (int i = 0; i < actionMixinTypes.length; ++i) {
            NodeType mixinType = actionMixinTypes[i];
            this.fillVariables(actionNode, mixinType, variables);
        }
        this.executeAction(userId, node, actionName, variables, repository);
    }

    private void fillVariables(Node actionNode, NodeType nodeType, Map variables) throws Exception {
        for (PropertyDefinition def : nodeType.getDeclaredPropertyDefinitions()) {
            String propName = def.getName();
            if (!actionNode.hasProperty(propName)) continue;
            String propValue = actionNode.getProperty(propName).getString();
            variables.put(propName, propValue);
        }
    }

    @Override
    public void executeAction(String userId, Node node, String actionName, Map variables, String repository) throws Exception {
        Node parentNode = node.getParent();
        if (!parentNode.isNodeType(ACTIONABLE)) {
            return;
        }
        Node actionNode = parentNode.getNode(EXO_ACTIONS + "/" + actionName);
        String actionTypeName = actionNode.getPrimaryNodeType().getName();
        for (ComponentPlugin plugin : this.actionPlugins) {
            String actionServiceName = plugin.getName();
            ActionPlugin actionPlugin = this.getActionPlugin(actionServiceName);
            if (!actionPlugin.isActionTypeSupported(actionTypeName)) continue;
            actionPlugin.executeAction(userId, actionNode, variables, repository);
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        this.actionPlugins.add(plugin);
    }

    public ComponentPlugin removePlugin(String pluginName) {
        return null;
    }

    public Collection getPlugins() {
        return this.actionPlugins;
    }

    private void initiateActionConfiguration() throws Exception {
        List repositories = this.repositoryService_.getConfig().getRepositoryConfigurations();
        ManageableRepository jcrRepository = null;
        for (RepositoryEntry repository : repositories) {
            String[] workspaces;
            jcrRepository = this.repositoryService_.getRepository(repository.getName());
            for (String workspace : workspaces = jcrRepository.getWorkspaceNames()) {
                Session session = jcrRepository.getSystemSession(workspace);
                QueryManager queryManager = null;
                try {
                    queryManager = session.getWorkspace().getQueryManager();
                }
                catch (RepositoryException e) {
                    System.out.println("[WARN] ActionServiceContainer - Query Manager Factory of workspace " + workspace + " not found. Check configuration.");
                }
                if (queryManager == null) {
                    session.logout();
                    continue;
                }
                this.initAction(queryManager, repository.getName(), workspace);
                session.logout();
            }
        }
    }

    private void reInitiateActionConfiguration(String repository) throws Exception {
        ManageableRepository jcrRepository = this.repositoryService_.getRepository(repository);
        for (String workspace : jcrRepository.getWorkspaceNames()) {
            Session session = jcrRepository.getSystemSession(workspace);
            QueryManager queryManager = null;
            try {
                queryManager = session.getWorkspace().getQueryManager();
            }
            catch (RepositoryException e) {
                System.out.println("[WARN] ActionServiceContainer - Query Manager Factory of workspace " + workspace + " not found. Check configuration.");
            }
            if (queryManager == null) {
                session.logout();
                continue;
            }
            this.initAction(queryManager, repository, workspace);
            session.logout();
        }
    }

    private void initAction(QueryManager queryManager, String repository, String workspace) throws Exception {
        try {
            Query query = queryManager.createQuery(ACTION_QUERY, "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node actionNode = iter.nextNode();
                String lifecyclePhase = actionNode.getProperty(LIFECYCLE_PHASE_PROP).getString();
                String actionType = actionNode.getPrimaryNodeType().getName();
                for (ComponentPlugin plugin : this.actionPlugins) {
                    String actionServiceName = plugin.getName();
                    ActionPlugin actionService = this.getActionPlugin(actionServiceName);
                    if (!actionService.isActionTypeSupported(actionType)) continue;
                    if (lifecyclePhase.equals("schedule")) {
                        actionService.reScheduleActivations(actionNode, repository);
                        continue;
                    }
                    actionService.initiateActionObservation(actionNode, repository);
                }
            }
        }
        catch (Exception e) {
            System.out.println(">>>> Can not launch action listeners for wokrpsace: " + workspace + " in '" + repository + "' repository");
        }
    }

    @Override
    public void initiateObservation(Node node, String repository) throws Exception {
        try {
            Session session = node.getSession();
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String queryStr = node.getPath() != "/" ? "/jcr:root" + node.getPath() + ACTION_QUERY : ACTION_QUERY;
            Query query = queryManager.createQuery(queryStr, "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node actionNode = iter.nextNode();
                try {
                    String actionType = actionNode.getPrimaryNodeType().getName();
                    for (ComponentPlugin plugin : this.actionPlugins) {
                        String actionServiceName = plugin.getName();
                        ActionPlugin actionService = this.getActionPlugin(actionServiceName);
                        if (!actionService.isActionTypeSupported(actionType)) continue;
                        actionService.initiateActionObservation(actionNode, repository);
                    }
                }
                catch (Exception e) {
                    System.out.println("Can not launch action listeners named is " + actionNode.getPath());
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Can not launch action listeners inside " + node.getPath() + " node.");
        }
    }
}

