/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.metadata.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataServiceImpl
implements MetadataService,
Startable {
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String EXO_TEMPLATE = "exo:template";
    public static final String EXO_ROLES_PROP = "exo:roles";
    public static final String EXO_TEMPLATE_FILE_PROP = "exo:templateFile";
    public static final String INTERNAL_USE = "exo:internalUse".intern();
    public static final String METADATA_TYPE = "exo:metadata".intern();
    public static final String DIALOGS = "dialogs";
    public static final String VIEWS = "views";
    public static final String DIALOG1 = "dialog1";
    public static final String VIEW1 = "view1";
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private String baseMetadataPath_;
    private List<TemplatePlugin> plugins_ = new ArrayList<TemplatePlugin>();

    public MetadataServiceImpl(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.baseMetadataPath_ = this.nodeHierarchyCreator_.getJcrPath("metadataPath");
    }

    public void start() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void addPlugins(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    private void init() throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            try {
                plugin.setBasePath(this.baseMetadataPath_);
                plugin.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void init(String repository) throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            try {
                plugin.setBasePath(this.baseMetadataPath_);
                plugin.init(repository);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String addMetadata(String nodetype, boolean isDialog, String role, String content, boolean isAddNew, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        String path = null;
        if (!isAddNew) {
            if (isDialog) {
                Node dialog1 = metadataHome.getNode(nodetype).getNode(DIALOGS).getNode(DIALOG1);
                dialog1.setProperty(EXO_ROLES_PROP, role.split(";"));
                dialog1.setProperty(EXO_TEMPLATE_FILE_PROP, content);
                dialog1.save();
                path = dialog1.getPath();
            } else {
                Node view1 = metadataHome.getNode(nodetype).getNode(VIEWS).getNode(VIEW1);
                view1.setProperty(EXO_ROLES_PROP, role.split(";"));
                view1.setProperty(EXO_TEMPLATE_FILE_PROP, content);
                view1.save();
                path = view1.getPath();
            }
        } else {
            Node metadata = null;
            metadata = metadataHome.hasNode(nodetype) ? metadataHome.getNode(nodetype) : metadataHome.addNode(nodetype, NT_UNSTRUCTURED);
            this.addTemplate(metadata, role, content, isDialog);
            metadataHome.save();
        }
        session.save();
        session.logout();
        return path;
    }

    private void addTemplate(Node nodetype, String role, String content, boolean isDialog) throws Exception {
        Node templateHome = this.createTemplateHome(nodetype, isDialog);
        Node template = null;
        template = isDialog ? (templateHome.hasNode(DIALOG1) ? templateHome.getNode(DIALOG1) : templateHome.addNode(DIALOG1, EXO_TEMPLATE)) : (templateHome.hasNode(VIEW1) ? templateHome.getNode(VIEW1) : templateHome.addNode(VIEW1, EXO_TEMPLATE));
        String[] arrRoles = new String[]{};
        if (role != null) {
            arrRoles = role.split(";");
        }
        template.setProperty(EXO_ROLES_PROP, arrRoles);
        template.setProperty(EXO_TEMPLATE_FILE_PROP, content);
    }

    @Override
    public void removeMetadata(String nodetype, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node metadata = metadataHome.getNode(nodetype);
        metadata.remove();
        metadataHome.save();
        session.save();
        session.logout();
    }

    @Override
    public List<String> getMetadataList(String repository) throws Exception {
        ArrayList<String> metadataTypes = new ArrayList<String>();
        for (NodeType metadata : this.getAllMetadatasNodeType(repository)) {
            metadataTypes.add(metadata.getName());
        }
        return metadataTypes;
    }

    @Override
    public List<NodeType> getAllMetadatasNodeType(String repository) throws Exception {
        ArrayList<NodeType> metadataTypes = new ArrayList<NodeType>();
        ExtendedNodeTypeManager ntManager = this.repositoryService_.getRepository(repository).getNodeTypeManager();
        NodeTypeIterator ntIter = ntManager.getMixinNodeTypes();
        while (ntIter.hasNext()) {
            NodeType nt = ntIter.nextNodeType();
            if (!nt.isNodeType(METADATA_TYPE)) continue;
            metadataTypes.add(nt);
        }
        return metadataTypes;
    }

    private Node createTemplateHome(Node nodetype, boolean isDialog) throws Exception {
        if (isDialog) {
            Node dialogs = null;
            dialogs = nodetype.hasNode(DIALOGS) ? nodetype.getNode(DIALOGS) : nodetype.addNode(DIALOGS, NT_UNSTRUCTURED);
            return dialogs;
        }
        Node views = null;
        views = nodetype.hasNode(VIEWS) ? nodetype.getNode(VIEWS) : nodetype.addNode(VIEWS, NT_UNSTRUCTURED);
        return views;
    }

    @Override
    public String getMetadataTemplate(String name, boolean isDialog, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node template = null;
        if (!this.hasMetadata(name, repository)) {
            return null;
        }
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        session.logout();
        return template.getProperty(EXO_TEMPLATE_FILE_PROP).getString();
    }

    @Override
    public String getMetadataPath(String name, boolean isDialog, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        if (!this.hasMetadata(name, repository)) {
            return null;
        }
        Node template = null;
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        session.logout();
        return template.getPath();
    }

    @Override
    public String getMetadataRoles(String name, boolean isDialog, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        Node template = null;
        if (!this.hasMetadata(name, repository)) {
            return null;
        }
        template = isDialog ? metadataHome.getNode(name).getNode(DIALOGS).getNode(DIALOG1) : metadataHome.getNode(name).getNode(VIEWS).getNode(VIEW1);
        Value[] values = template.getProperty(EXO_ROLES_PROP).getValues();
        StringBuffer roles = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (roles.length() > 0) {
                roles.append(";");
            }
            roles.append(values[i].getString());
        }
        session.logout();
        return roles.toString();
    }

    @Override
    public boolean hasMetadata(String name, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node metadataHome = (Node)session.getItem(this.baseMetadataPath_);
        if (metadataHome.hasNode(name)) {
            session.logout();
            return true;
        }
        session.logout();
        return false;
    }

    @Override
    public List<String> getExternalMetadataType(String repository) throws Exception {
        ArrayList<String> extenalMetaTypes = new ArrayList<String>();
        for (NodeType metadata : this.getAllMetadatasNodeType(repository)) {
            ExtendedNodeType extNT = (ExtendedNodeType)metadata;
            PropertyDefinition internalUseDef = extNT.getPropertyDefinitions(INTERNAL_USE).getAnyDefinition();
            if (internalUseDef.getDefaultValues()[0].getBoolean()) continue;
            extenalMetaTypes.add(metadata.getName());
        }
        return extenalMetaTypes;
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        return manageableRepository.getSystemSession(manageableRepository.getConfiguration().getSystemWorkspaceName());
    }
}

