/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.views.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.cms.views.impl.ManageViewPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageViewServiceImpl
implements ManageViewService,
Startable {
    protected static final String EXO_TEMPLATE = "exo:template".intern();
    protected static final String TEMPLATE_PROP = "exo:templateFile".intern();
    protected static final String ADMIN_VIEW = "admin".intern();
    protected static final String DEFAULT_VIEW = "default".intern();
    protected static final String EXO_PERMISSIONS = "exo:permissions".intern();
    protected static final String BUTTON_PROP = "exo:buttons".intern();
    private List<ManageViewPlugin> plugins_ = new ArrayList<ManageViewPlugin>();
    private String buttons_;
    private RepositoryService repositoryService_;
    private String baseViewPath_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public ManageViewServiceImpl(InitParams params, RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.repositoryService_ = jcrService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.baseViewPath_ = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        ValueParam buttonParam = params.getValueParam("buttons");
        this.buttons_ = buttonParam.getValue();
    }

    public void start() {
        try {
            for (ManageViewPlugin plugin : this.plugins_) {
                plugin.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    @Override
    public void init(String repository) throws Exception {
        for (ManageViewPlugin plugin : this.plugins_) {
            plugin.init(repository);
        }
    }

    public void setManageViewPlugin(ManageViewPlugin viewPlugin) {
        this.plugins_.add(viewPlugin);
    }

    @Override
    public List getButtons() {
        ArrayList<String> buttonList = new ArrayList<String>();
        if (this.buttons_ == null || this.buttons_.length() < 1) {
            return buttonList;
        }
        if (this.buttons_.indexOf(";") > -1) {
            String[] buttons = StringUtils.split((String)this.buttons_, (String)";");
            if (buttons == null || buttons.length < 1) {
                return null;
            }
            for (int i = 0; i < buttons.length; ++i) {
                buttonList.add(buttons[i].trim());
            }
        } else {
            buttonList.add(this.buttons_);
        }
        return buttonList;
    }

    public Node getViewHome(String repository) throws Exception {
        String viewsPath = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        return (Node)this.getSession(repository).getItem(viewsPath);
    }

    @Override
    public List<ViewConfig> getAllViews(String repository) throws Exception {
        ArrayList<ViewConfig> viewList = new ArrayList<ViewConfig>();
        ViewConfig view = null;
        Node viewNode = null;
        String viewsPath = this.nodeHierarchyCreator_.getJcrPath("userViewsPath");
        Session session = this.getSession(repository);
        try {
            Node viewHome = (Node)session.getItem(viewsPath);
            NodeIterator iter = viewHome.getNodes();
            while (iter.hasNext()) {
                view = new ViewConfig();
                viewNode = iter.nextNode();
                view.setName(viewNode.getName());
                view.setPermissions(viewNode.getProperty(EXO_PERMISSIONS).getString());
                view.setTemplate(viewNode.getProperty(EXO_TEMPLATE).getString());
                ArrayList<ViewConfig.Tab> tabList = new ArrayList<ViewConfig.Tab>();
                NodeIterator tabsIterator = viewNode.getNodes();
                while (tabsIterator.hasNext()) {
                    ViewConfig.Tab tab = new ViewConfig.Tab();
                    tab.setTabName(tabsIterator.nextNode().getName());
                    tabList.add(tab);
                }
                view.setTabList(tabList);
                viewList.add(view);
            }
            session.logout();
            return viewList;
        }
        catch (AccessDeniedException ace) {
            return new ArrayList<ViewConfig>();
        }
    }

    @Override
    public boolean hasView(String name, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node viewHome = (Node)session.getItem(this.baseViewPath_);
        boolean b = viewHome.hasNode(name);
        session.logout();
        return b;
    }

    @Override
    public Node getViewByName(String name, String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        try {
            return (Node)session.getItem(this.baseViewPath_ + "/" + name);
        }
        catch (AccessDeniedException ace) {
            return null;
        }
    }

    @Override
    public void addView(String name, String permissions, String template, List tabs, String repository) throws Exception {
        Node view;
        Session session = this.getSession(repository);
        Node viewHome = (Node)session.getItem(this.baseViewPath_);
        if (viewHome.hasNode(name)) {
            view = viewHome.getNode(name);
            if (!view.isCheckedOut()) {
                view.checkout();
            }
            view.setProperty(EXO_PERMISSIONS, permissions);
            view.setProperty(EXO_TEMPLATE, template);
        } else {
            view = this.addView(viewHome, name, permissions, template);
        }
        for (int i = 0; i < tabs.size(); ++i) {
            String buttons;
            String tabName;
            try {
                Node tab = (Node)tabs.get(i);
                tabName = tab.getName();
                buttons = tab.getProperty(BUTTON_PROP).getString();
            }
            catch (Exception e) {
                ViewConfig.Tab tab = (ViewConfig.Tab)tabs.get(i);
                tabName = tab.getTabName();
                buttons = tab.getButtons();
            }
            this.addTab(view, tabName, buttons);
        }
        viewHome.save();
        session.save();
        session.logout();
    }

    @Override
    public void removeView(String viewName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node viewHome = (Node)session.getItem(this.baseViewPath_);
        if (viewHome.hasNode(viewName)) {
            Node view = viewHome.getNode(viewName);
            view.remove();
            viewHome.save();
            session.save();
        }
        session.logout();
    }

    @Override
    public void addTab(Node view, String name, String buttons) throws Exception {
        Node tab = view.hasNode(name) ? view.getNode(name) : view.addNode(name, "exo:tab");
        tab.setProperty("exo:buttons", buttons);
        view.save();
    }

    @Override
    public Node getTemplateHome(String homeAlias, String repository, SessionProvider provider) throws Exception {
        String homePath = this.getJCRPath(homeAlias);
        try {
            Session session = this.getSession(repository, provider);
            return (Node)session.getItem(homePath);
        }
        catch (AccessDeniedException ace) {
            return null;
        }
    }

    private String getJCRPath(String jcrAlias) throws Exception {
        return this.nodeHierarchyCreator_.getJcrPath(jcrAlias);
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String worksapce = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        return manageableRepository.getSystemSession(worksapce);
    }

    private Session getSession(String repository, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String worksapce = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        return sessionProvider.getSession(worksapce, manageableRepository);
    }

    @Override
    public List<Node> getAllTemplates(String homeAlias, String repository, SessionProvider provider) throws Exception {
        Node templateHomNode = this.getTemplateHome(homeAlias, repository, provider);
        ArrayList<Node> list = new ArrayList<Node>();
        if (templateHomNode == null) {
            return list;
        }
        NodeIterator iter = templateHomNode.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        return list;
    }

    @Override
    public Node getTemplate(String path, String repository, SessionProvider provider) throws Exception {
        return (Node)this.getSession(repository, provider).getItem(path);
    }

    @Override
    public String addTemplate(String name, String content, String homeTemplate, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateHome = (Node)session.getItem(homeTemplate);
        Node newTemp = null;
        newTemp = templateHome.hasNode(name) ? templateHome.getNode(name) : templateHome.addNode(name, EXO_TEMPLATE);
        newTemp.setProperty(TEMPLATE_PROP, content);
        templateHome.save();
        session.save();
        session.logout();
        return newTemp.getPath();
    }

    @Override
    public void removeTemplate(String templatePath, String repository) throws Exception {
        Node selectedTemplate = (Node)this.getSession(repository).getItem(templatePath);
        Node parent = selectedTemplate.getParent();
        selectedTemplate.remove();
        parent.save();
        parent.getSession().save();
    }

    private Node addView(Node viewManager, String name, String permissions, String template) throws Exception {
        Node contentNode = viewManager.addNode(name, "exo:view");
        contentNode.setProperty("exo:permissions", permissions);
        contentNode.setProperty("exo:template", template);
        viewManager.save();
        return contentNode;
    }
}

