/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.staticdirect;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.PublicationPlugin;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.UINonPublishedForm;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.UIPublishedForm;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAndDirectPublicationPlugin
extends PublicationPlugin {
    public static final String ENROLLED = "enrolled".intern();
    public static final String NON_PUBLISHED = "non published".intern();
    public static final String PUBLISHED = "published".intern();
    public static final String DEFAULT_STATE = NON_PUBLISHED;
    public static final String PUBLICATION = "publication:publication".intern();
    public static final String LIFECYCLE_NAME = "publication:lifecycleName".intern();
    public static final String CURRENT_STATE = "publication:currentState".intern();
    public static final String HISTORY = "publication:history".intern();
    public static final String VISIBILITY = "publication:visibility".intern();
    public static final String VERSIONS_PUBLICATION_STATES = "publication:versionsPublicationStates".intern();
    public static final String PUBLIC = "public".intern();
    public static final String PRIVATE = "private".intern();
    public static final String MIXIN_TYPE = "publication:staticAndDirectPublication".intern();
    public static final String IMG_PATH = "resources/images/".intern();
    protected static Log log;
    private final String localeFile = "locale.portlet.publication.PublicationService";
    private static final int BUFFER_SIZE = 512;

    public StaticAndDirectPublicationPlugin() {
        log = ExoLogger.getLogger((String)"portal:StaticAndDirectPublicationPlugin");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        log.info((Object)("Change node state to " + newState));
        Session session = node.getSession();
        ManageableRepository repository = (ManageableRepository)session.getRepository();
        Session systemSession = repository.getSystemSession(session.getWorkspace().getName());
        if (newState.equals(ENROLLED)) {
            log.info((Object)("Set node to " + NON_PUBLISHED));
            if (node.canAddMixin("mix:versionable")) {
                node.addMixin("mix:versionable");
            }
            node.save();
            Version version = node.checkin();
            node.checkout();
            String newStringValue = version.getUUID() + "," + NON_PUBLISHED;
            Value value2add = systemSession.getValueFactory().createValue(newStringValue);
            Value[] values = new Value[]{value2add};
            node.setProperty(VERSIONS_PUBLICATION_STATES, values);
            node.setProperty(CURRENT_STATE, NON_PUBLISHED);
            String visibility = PRIVATE;
            Value newValueVisibility = systemSession.getValueFactory().createValue(visibility);
            node.setProperty(VISIBILITY, newValueVisibility);
            this.setVisibility(node, visibility);
            log.info((Object)"Add log");
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
            String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
            String versionName = session.getNodeByUUID(version.getUUID()).getName();
            String[] log = new String[]{date, NON_PUBLISHED, session.getUserID(), "PublicationService.StaticAndDirectPublicationPlugin.nodeCreated", versionName, visibility};
            publicationService.addLog(node, log);
            node.setProperty(CURRENT_STATE, NON_PUBLISHED);
        } else if (newState.equals(PUBLISHED)) {
            String currentState = node.getProperty(CURRENT_STATE).getString();
            if (currentState.equals(NON_PUBLISHED)) {
                int i;
                log.info((Object)"Node is non published");
                String nodeVersionUUID = context.get("nodeVersionUUID");
                String visibility = context.get("visibility");
                if (nodeVersionUUID == null || visibility == null) {
                    log.error((Object)"nodeVersionUUID or visibility is null");
                    throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : nodeVersionUUID or visibility is not present in context.");
                }
                log.info((Object)"nodeVersionUUID and visibility is not null");
                Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
                for (i = 0; i < values.length && !values[i].getString().split(",")[0].equals(nodeVersionUUID); ++i) {
                }
                if (i != values.length && !values[i].getString().split(",")[1].equals(NON_PUBLISHED)) throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : Node Version " + nodeVersionUUID + " is already published");
                log.info((Object)"Specified version not already published");
                log.info((Object)"Set this version published");
                String newStringValue = nodeVersionUUID + "," + PUBLISHED;
                Value value2add = systemSession.getValueFactory().createValue(newStringValue);
                if (i == values.length) {
                    values = this.addValueToArray(values, value2add);
                } else {
                    values[i] = value2add;
                }
                node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                log.info((Object)"Set the visibility");
                Value newValueVisibility = systemSession.getValueFactory().createValue(visibility);
                node.setProperty(VISIBILITY, newValueVisibility);
                log.info((Object)"Set permissions in function of visibility");
                this.setVisibility(node, visibility);
                node.setProperty(CURRENT_STATE, PUBLISHED);
                log.info((Object)"Add log");
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                String version = session.getNodeByUUID(nodeVersionUUID).getName();
                String[] log = new String[]{date, newState, session.getUserID(), "PublicationService.StaticAndDirectPublicationPlugin.nodePublished", version, visibility};
                publicationService.addLog(node, log);
            } else {
                Value value2add;
                int i;
                log.info((Object)"Node is already published, user want to published another version.");
                String nodeVersionUUID = context.get("nodeVersionUUID");
                String visibility = context.get("visibility");
                if (nodeVersionUUID == null || visibility == null) {
                    log.error((Object)"nodeVersionUUID or visibility is null");
                    throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : nodeVersionUUID or visibility is not present in context.");
                }
                log.info((Object)"nodeVersionUUID and visibility is not null");
                Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
                for (i = 0; i < values.length && !values[i].getString().split(",")[1].equals(PUBLISHED); ++i) {
                }
                if (i == values.length) {
                    throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : currentState is published but no version is published");
                }
                String publishedVersionUUID = values[i].getString().split(",")[0];
                log.info((Object)"Unpublished current published version");
                String newStringValue = publishedVersionUUID + "," + NON_PUBLISHED;
                values[i] = value2add = systemSession.getValueFactory().createValue(newStringValue);
                node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                for (i = 0; i < values.length && !values[i].getString().split(",")[0].equals(nodeVersionUUID); ++i) {
                }
                if (i != values.length && !values[i].getString().split(",")[1].equals(NON_PUBLISHED)) throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : Node Version " + nodeVersionUUID + " is already published");
                log.info((Object)"Specified version not already published");
                log.info((Object)"Set this version published");
                String newStringValue2 = nodeVersionUUID + "," + PUBLISHED;
                Value value2add2 = systemSession.getValueFactory().createValue(newStringValue2);
                if (i == values.length) {
                    values = this.addValueToArray(values, value2add2);
                } else {
                    values[i] = value2add2;
                }
                node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                log.info((Object)"Set the visibility");
                Value newValueVisibility = systemSession.getValueFactory().createValue(visibility);
                node.setProperty(VISIBILITY, newValueVisibility);
                log.info((Object)"Set permissions in function of visibility");
                this.setVisibility(node, visibility);
                node.setProperty(CURRENT_STATE, PUBLISHED);
                log.info((Object)"Add log");
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                String version = session.getNodeByUUID(nodeVersionUUID).getName();
                String[] log = new String[]{date, newState, session.getUserID(), "PublicationService.StaticAndDirectPublicationPlugin.nodePublished", version, visibility};
                publicationService.addLog(node, log);
            }
        } else {
            if (!newState.equals(NON_PUBLISHED)) throw new IncorrectStateUpdateLifecycleException("Incorrect current State");
            String currentState = node.getProperty(CURRENT_STATE).getString();
            if (currentState.equals(NON_PUBLISHED)) {
                log.info((Object)"node already unpublished");
                String oldVisibility = node.getProperty(VISIBILITY).getString();
                String newVisibility = context.get("visibility");
                String nodeVersionUUID = context.get("nodeVersionUUID");
                if (!oldVisibility.equals(newVisibility)) {
                    Value newValueVisibility = systemSession.getValueFactory().createValue(newVisibility);
                    node.setProperty(VISIBILITY, newValueVisibility);
                    this.setVisibility(node, newVisibility);
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                    String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                    String version = session.getNodeByUUID(nodeVersionUUID).getName();
                    String[] log = new String[]{date, newState, session.getUserID(), "PublicationService.StaticAndDirectPublicationPlugin.changeVisibility", newVisibility};
                    publicationService.addLog(node, log);
                }
            } else if (currentState.equals(PUBLISHED)) {
                Value value2add;
                int i;
                log.info((Object)"Node published, unpublish it");
                Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
                for (i = 0; i < values.length && !values[i].getString().split(",")[1].equals(PUBLISHED); ++i) {
                }
                if (i == values.length) throw new IncorrectStateUpdateLifecycleException("StaticAndDirectPublicationPlugin.changeState : currentState is published but no version is published");
                String publishedVersionUUID = values[i].getString().split(",")[0];
                log.info((Object)"Unpublished current published version");
                String newStringValue = publishedVersionUUID + "," + NON_PUBLISHED;
                values[i] = value2add = systemSession.getValueFactory().createValue(newStringValue);
                node.setProperty(VERSIONS_PUBLICATION_STATES, values);
                node.setProperty(CURRENT_STATE, NON_PUBLISHED);
                String newVisibility = context.get("visibility");
                Value newValueVisibility = systemSession.getValueFactory().createValue(newVisibility);
                node.setProperty(VISIBILITY, newValueVisibility);
                this.setVisibility(node, newVisibility);
                log.info((Object)"Add log");
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                String date = new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
                String[] log = new String[]{date, newState, session.getUserID(), "PublicationService.StaticAndDirectPublicationPlugin.nodeUnpublished", newVisibility};
                publicationService.addLog(node, log);
            }
        }
        node.save();
    }

    @Override
    public String[] getPossibleStates() {
        String[] result = new String[]{ENROLLED, NON_PUBLISHED, PUBLISHED};
        return result;
    }

    @Override
    public byte[] getStateImage(Node node, Locale locale) throws IOException, FileNotFoundException, Exception {
        byte[] bytes = null;
        String fileName = "staticAndDirect";
        String currentState = node.getProperty(CURRENT_STATE).getString();
        fileName = currentState.equals(PUBLISHED) ? fileName + "Published" : fileName + "Unpublished";
        String fileNameLocalized = fileName + "_" + locale.getLanguage();
        String completeFileName = IMG_PATH + fileNameLocalized + ".gif";
        log.trace((Object)("loading file '" + this.name + "' from file system '" + completeFileName + "'"));
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        if (in == null) {
            completeFileName = IMG_PATH + fileName + ".gif";
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StaticAndDirectPublicationPlugin.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    @Override
    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        if (node.getProperty(CURRENT_STATE).getString().equals(ENROLLED) || node.getProperty(CURRENT_STATE).getString().equals(NON_PUBLISHED)) {
            UINonPublishedForm form = (UINonPublishedForm)component.createUIComponent(UINonPublishedForm.class, null, null);
            form.setNode(node);
            return form;
        }
        if (node.getProperty(CURRENT_STATE).getString().equals(PUBLISHED)) {
            UIPublishedForm form = (UIPublishedForm)component.createUIComponent(UIPublishedForm.class, null, null);
            form.setNode(node);
            return form;
        }
        throw new Exception("StaticAndDirectPublicationPlugin.getStateUI : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
    }

    @Override
    public String getUserInfo(Node node, Locale locale) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
        ResourceBundleService resourceBundleService = (ResourceBundleService)container.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle resourceBundle = resourceBundleService.getResourceBundle("locale.portlet.publication.PublicationService", locale, ((Object)((Object)this)).getClass().getClassLoader());
        Session session = node.getSession();
        if (node.getProperty(CURRENT_STATE).getString().equals(ENROLLED) || node.getProperty(CURRENT_STATE).getString().equals(NON_PUBLISHED)) {
            return resourceBundle.getString("PublicationService.StaticAndDirectPublicationPlugin.nodeNotPublished");
        }
        if (node.getProperty(CURRENT_STATE).getString().equals(PUBLISHED)) {
            int i;
            Value[] values = node.getProperty(VERSIONS_PUBLICATION_STATES).getValues();
            for (i = 0; i < values.length && !values[i].getString().split(",")[1].equals(PUBLISHED); ++i) {
            }
            if (i == values.length) {
                throw new Exception("StaticAndDirectPublicationPlugin.getUserInfo : currentState=published, but state published not present in history");
            }
            String[] currentHistory = values[i].getString().split(",");
            String uuid = currentHistory[0];
            Node versionNode = session.getNodeByUUID(uuid);
            String name = versionNode.getName();
            Node labelNode = versionNode.getParent().getNode("jcr:versionLabels");
            PropertyIterator propertyIterator = labelNode.getProperties();
            String label = "";
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (!property.getValue().getString().equals(uuid)) continue;
                label = property.getName();
            }
            String visibility = node.getProperty(VISIBILITY).getValue().getString();
            String result = "";
            if (label.equals("")) {
                String[] valuesLocale = new String[]{name};
                result = result + publicationService.getLocalizedAndSubstituteLog(locale, "PublicationService.StaticAndDirectPublicationPlugin.versionPublishedWithoutLabel", valuesLocale);
            } else {
                String[] valuesLocale = new String[]{name, label};
                result = result + publicationService.getLocalizedAndSubstituteLog(locale, "PublicationService.StaticAndDirectPublicationPlugin.versionPublishedWithLabel", valuesLocale);
            }
            result = visibility.equals(PUBLIC) ? result + resourceBundle.getString("PublicationService.StaticAndDirectPublicationPlugin.visibilityPublic") : result + resourceBundle.getString("PublicationService.StaticAndDirectPublicationPlugin.visibilityPrivate");
            return result;
        }
        throw new Exception("StaticAndDirectPublicationPlugin.getUserInfo : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
    }

    public void setVisibility(Node node, String visibility) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        if (visibility.equals(PUBLIC)) {
            String[] arrayPermission = new String[]{"read"};
            extNode.setPermission(SystemIdentity.ANY, arrayPermission);
        } else {
            extNode.removePermission(SystemIdentity.ANY);
        }
    }

    @Override
    public boolean canAddMixin(Node node) throws Exception {
        return node.canAddMixin(MIXIN_TYPE);
    }

    @Override
    public void addMixin(Node node) throws Exception {
        node.addMixin(MIXIN_TYPE);
        node.setProperty(VISIBILITY, PRIVATE);
        ArrayList publicationStates = new ArrayList();
        node.setProperty(VERSIONS_PUBLICATION_STATES, publicationStates.toArray(new Value[publicationStates.size()]));
    }

    public Value[] addValueToArray(Value[] array, Value value2add) {
        Value[] newarray = new Value[array.length + 1];
        for (int i = 0; i < array.length; ++i) {
            newarray[i] = array[i];
        }
        newarray[array.length] = value2add;
        return newarray;
    }
}

