/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.staticdirect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.ecm.publication.plugins.staticdirect.StaticAndDirectPublicationPlugin;
import org.exoplatform.services.ecm.publication.plugins.webui.VersionNode;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:resources/templates/staticdirect/UIPublicationForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIPublicationForm
extends UIForm {
    public static final String VISIBILITY = "visibility".intern();
    public static final String STATE = "state".intern();
    private VersionNode curentVersion_;
    private VersionNode rootVersion_;
    private Node currentNode_;
    private String visibility_;
    private String state_;

    public void updateForm(VersionNode versionNode) throws Exception {
        String state = this.getStateByVersion(versionNode);
        this.resetCurrentState(state, this.visibility_);
    }

    public void resetCurrentState(String state, String visibility) throws Exception {
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String published = res.getString("UIPublicationForm.label.published");
        String non_published = res.getString("UIPublicationForm.label.non-published");
        String lblPublic = res.getString("UIPublicationForm.label.public");
        String lblPrivate = res.getString("UIPublicationForm.label.private");
        this.removeChildById(VISIBILITY);
        this.removeChildById(STATE);
        ArrayList<SelectItemOption> visibilityOptions = new ArrayList<SelectItemOption>();
        visibilityOptions.add(new SelectItemOption(lblPublic, (Object)StaticAndDirectPublicationPlugin.PUBLIC));
        visibilityOptions.add(new SelectItemOption(lblPrivate, (Object)StaticAndDirectPublicationPlugin.PRIVATE));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(VISIBILITY, visibility, visibilityOptions).setAlign(UIFormRadioBoxInput.HORIZONTAL_ALIGN));
        ArrayList<SelectItemOption> stateOptions = new ArrayList<SelectItemOption>();
        stateOptions.add(new SelectItemOption(published, (Object)StaticAndDirectPublicationPlugin.PUBLISHED));
        stateOptions.add(new SelectItemOption(non_published, (Object)StaticAndDirectPublicationPlugin.NON_PUBLISHED));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(STATE, state, stateOptions).setAlign(UIFormRadioBoxInput.HORIZONTAL_ALIGN));
    }

    public String getStateByVersion(VersionNode versionNode) throws Exception {
        Value[] publicationStates;
        for (Value value : publicationStates = this.currentNode_.getProperty(StaticAndDirectPublicationPlugin.VERSIONS_PUBLICATION_STATES).getValues()) {
            String[] arrPublicationState = value.getString().split(",");
            for (int i = 0; i < arrPublicationState.length; ++i) {
                if (!arrPublicationState[0].equals(versionNode.getVersion().getUUID())) continue;
                return arrPublicationState[1];
            }
        }
        return StaticAndDirectPublicationPlugin.DEFAULT_STATE;
    }

    public void initForm(Node currentNode) throws Exception {
        this.currentNode_ = currentNode;
        this.rootVersion_ = new VersionNode(this.currentNode_.getVersionHistory().getRootVersion());
        this.curentVersion_ = new VersionNode(this.currentNode_.getBaseVersion());
        this.visibility_ = this.currentNode_.getProperty(StaticAndDirectPublicationPlugin.VISIBILITY).getString();
        this.state_ = this.getStateByVersion(this.curentVersion_);
        this.resetCurrentState(this.state_, this.visibility_);
    }

    public void setVersionNode(VersionNode versionNode) {
        this.curentVersion_ = versionNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIPublicationForm> {
        public void execute(Event<UIPublicationForm> event) throws Exception {
            UIPublicationForm uiForm = (UIPublicationForm)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIPublicationForm> {
        public void execute(Event<UIPublicationForm> event) throws Exception {
            UIPublicationForm uiForm = (UIPublicationForm)((Object)event.getSource());
            String visibility = (String)((UIFormRadioBoxInput)uiForm.getUIInput(VISIBILITY)).getValue();
            String state = (String)((UIFormRadioBoxInput)uiForm.getUIInput(STATE)).getValue();
            PublicationService publicationService = (PublicationService)uiForm.getApplicationComponent(PublicationService.class);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("nodeVersionUUID", uiForm.curentVersion_.getVersion().getUUID());
            context.put("visibility", visibility);
            publicationService.changeState(uiForm.currentNode_, state, context);
            UIPopupWindow uiPopup = (UIPopupWindow)uiForm.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }
}

