/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/UIFormInputSetWithAction.gtmpl")
public class UIWizardStep2
extends UIFormInputSetWithAction {
    public static final String FIELD_CONTAINER = "container";
    public static final String FIELD_SOURCENAME = "sourceName";
    public static final String FIELD_DBTYPE = "dbType";
    public static final String FIELD_ISMULTI = "isMulti";
    public static final String FIELD_STORETYPE = "storeType";
    public static final String FIELD_MAXBUFFER = "maxBuffer";
    public static final String FIELD_SWAPPATH = "swapPath";
    public static final String FIELD_STOREPATH = "storePath";
    public static final String FIELD_FILTER = "filterType";
    public static final String FIELD_EXTERNAL_STORE = "externalStore";

    public UIWizardStep2(String name) throws Exception {
        super(name);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_CONTAINER, FIELD_CONTAINER, null));
        this.setActionInfo(FIELD_CONTAINER, new String[]{"SelectContainer"});
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SOURCENAME, FIELD_SOURCENAME, null));
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_DBTYPE, FIELD_DBTYPE, this.getDbType()));
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_ISMULTI, FIELD_ISMULTI, null));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_MAXBUFFER, FIELD_MAXBUFFER, null).addValidator(NumberFormatValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SWAPPATH, FIELD_SWAPPATH, null));
        UIFormCheckBoxInput externalStore = new UIFormCheckBoxInput(FIELD_EXTERNAL_STORE, FIELD_EXTERNAL_STORE, null);
        externalStore.setOnChange("ChangeTypeStore");
        this.addChild((UIComponent)externalStore);
        this.addChild(new UIFormStringInput(FIELD_STORETYPE, FIELD_STORETYPE, null).setRendered(false));
        this.setActionInfo(FIELD_STORETYPE, new String[]{"SelectStore"});
        this.addChild(new UIFormSelectBox(FIELD_FILTER, FIELD_FILTER, this.getFilterType()).setRendered(false));
        this.addChild(new UIFormStringInput(FIELD_STOREPATH, FIELD_STOREPATH, null).setRendered(false));
    }

    public List<SelectItemOption<String>> getFilterType() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("Binary", (Object)"Binary"));
        return options;
    }

    private List<SelectItemOption<String>> getDbType() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (String dataType : DBConstants.DB_DIALECTS) {
            options.add((SelectItemOption<String>)new SelectItemOption(dataType, (Object)dataType));
        }
        return options;
    }

    protected void resetFields() {
        this.reset();
        this.setFieldIsMulti(false);
        this.setFieldDBType(this.getDbType());
    }

    protected void fillFields(String containerType, String sourceName, String selectedDBType, boolean isMutil, String storeType, String storePath, String filter, String maxBuffer, String swapPath) {
        this.setFieldContainer(containerType);
        this.setFieldSourceName(sourceName);
        this.setFieldDBType(selectedDBType);
        this.setFieldIsMulti(isMutil);
        this.setFieldStoreType(storeType);
        this.setFieldStorePath(storePath);
        this.setFieldFilter(filter);
        this.setFieldMaxBuffer(maxBuffer);
        this.setFieldSwapPath(swapPath);
    }

    protected void setFieldContainer(String container) {
        this.getUIStringInput(FIELD_CONTAINER).setValue((Object)container);
    }

    protected void setFieldSourceName(String source) {
        this.getUIStringInput(FIELD_SOURCENAME).setValue((Object)source);
    }

    protected void setFieldDBType(String dbType) {
        this.getUIFormSelectBox(FIELD_DBTYPE).setValue(dbType);
    }

    protected void setFieldDBType(List<SelectItemOption<String>> options) {
        this.getUIFormSelectBox(FIELD_DBTYPE).setOptions(options);
    }

    protected void setFieldIsMulti(boolean isMulti) {
        this.getUIFormCheckBoxInput(FIELD_ISMULTI).setChecked(isMulti);
    }

    protected void setFieldStoreType(String storeType) {
        this.getUIStringInput(FIELD_STORETYPE).setValue((Object)storeType);
    }

    protected void setFieldStorePath(String storePath) {
        this.getUIStringInput(FIELD_STOREPATH).setValue((Object)storePath);
    }

    protected void setFieldFilter(String filter) {
        this.getUIStringInput(FIELD_FILTER).setValue((Object)filter);
    }

    protected void setFieldMaxBuffer(String maxBuffer) {
        this.getUIStringInput(FIELD_MAXBUFFER).setValue((Object)maxBuffer);
    }

    protected void setFieldSwapPath(String swappath) {
        this.getUIStringInput(FIELD_SWAPPATH).setValue((Object)swappath);
    }

    protected void lockFields(boolean isLock) {
        boolean isEdiable;
        boolean bl = isEdiable = !isLock;
        if (isLock) {
            this.setActionInfo(FIELD_CONTAINER, null);
            this.setActionInfo(FIELD_STORETYPE, null);
        } else {
            this.setActionInfo(FIELD_CONTAINER, new String[]{"SelectContainer"});
            this.setActionInfo(FIELD_STORETYPE, new String[]{"SelectStore"});
        }
        this.getUIStringInput(FIELD_CONTAINER).setEditable(isEdiable);
        this.getUIStringInput(FIELD_SOURCENAME).setEditable(isEdiable);
        this.getUIFormSelectBox(FIELD_DBTYPE).setEnable(isEdiable);
        this.getUIFormCheckBoxInput(FIELD_ISMULTI).setEnable(isEdiable);
        this.getUIStringInput(FIELD_STORETYPE).setEditable(isEdiable);
        this.getUIStringInput(FIELD_STOREPATH).setEditable(isEdiable);
        this.getUIStringInput(FIELD_FILTER).setEnable(isEdiable);
        this.getUIStringInput(FIELD_MAXBUFFER).setEditable(isEdiable);
        this.getUIStringInput(FIELD_SWAPPATH).setEditable(isEdiable);
    }
}

