/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateList;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="app:/groovy/webui/component/UIGridWithButton.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UITemplateList.msg.confirm-delete"), @EventConfig(listeners={AddNewActionListener.class})})
public class UITemplateList
extends UIGrid {
    private static String[] NODETYPE_BEAN_FIELD = new String[]{"name"};
    private static String[] NODETYPE_ACTION = new String[]{"Edit", "Delete"};

    public UITemplateList() throws Exception {
        this.getUIPageIterator().setId("NodeTypeListIterator");
        this.configure("name", NODETYPE_BEAN_FIELD, NODETYPE_ACTION);
    }

    public String[] getActions() {
        return new String[]{"AddNew"};
    }

    public void updateGrid() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        Node templatesHome = templateService.getTemplatesHome(repository, SessionsUtils.getSessionProvider());
        ArrayList<TemplateData> templateData = new ArrayList<TemplateData>();
        if (templatesHome != null) {
            NodeIterator nodes = templatesHome.getNodes();
            while (nodes.hasNext()) {
                templateData.add(new TemplateData(nodes.nextNode().getName()));
            }
            Collections.sort(templateData, new TemplateComparator());
        }
        ObjectPageList objPageList = new ObjectPageList(templateData, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }
}

