/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.UIViewList;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIViewList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={AddViewActionListener.class})})
public class UIViewList
extends UIGrid {
    public static final String[] ACTIONS = new String[]{"AddView"};
    public static final String ST_VIEW = "ViewPopup";
    public static final String ST_EDIT = "EditPopup";
    public static final String ST_ADD = "AddPopup";
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "permissions", "tabList", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"View", "EditInfo", "Delete"};

    public UIViewList() throws Exception {
        this.getUIPageIterator().setId("UIViewsGrid");
        this.configure("name", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    private String getBaseVersion(String name) throws Exception {
        Node node = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(name, this.getRepository(), SessionsUtils.getSystemProvider());
        if (node == null) {
            return null;
        }
        if (!node.isNodeType("mix:versionable") || node.isNodeType(Utils.NT_FROZEN)) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void updateViewListGrid() throws Exception {
        Collections.sort(this.getViewsBean(), new ViewComparator());
        this.getUIPageIterator().setPageList((PageList)new ObjectPageList(this.getViewsBean(), 10));
    }

    private List<ViewBean> getViewsBean() throws Exception {
        List views = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllViews(this.getRepository());
        ArrayList<ViewBean> viewBeans = new ArrayList<ViewBean>();
        for (ViewConfig view : views) {
            ArrayList<String> tabsName = new ArrayList<String>();
            for (ViewConfig.Tab tab : view.getTabList()) {
                tabsName.add(tab.getTabName());
            }
            ViewBean bean = new ViewBean(this, view.getName(), view.getPermissions(), tabsName);
            if (this.getBaseVersion(view.getName()) == null) continue;
            bean.setBaseVersion(this.getBaseVersion(view.getName()));
            viewBeans.add(bean);
        }
        return viewBeans;
    }

    public boolean canDelete(List drivers, String viewName) {
        for (Object driver : drivers) {
            String views = ((DriveData)driver).getViews();
            for (String view : views.split(",")) {
                if (!viewName.equals(view.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    static /* synthetic */ List access$000(UIViewList x0) throws Exception {
        return x0.getViewsBean();
    }
}

