/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.DialogFormFields;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIAddLanguageContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UILanguageDialogForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UILanguageTypeForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={DialogFormFields.SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UILanguageDialogForm
extends DialogFormFields {
    private boolean isAddNew_ = false;
    private String selectedLanguage_ = null;
    private boolean isDefault_ = false;
    private String documentType_;

    public UILanguageDialogForm() throws Exception {
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public String getTemplate() {
        this.repositoryName_ = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            this.resetScriptInterceptor();
            return templateService.getTemplatePathByUser(true, this.documentType_, userName, this.repositoryName_);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.documentType_};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public boolean isAddNew() {
        return this.isAddNew_;
    }

    public void addNew(boolean b) {
        this.isAddNew_ = b;
    }

    public void setIsAddNew(boolean isAddNew) {
        this.isAddNew_ = isAddNew;
    }

    public boolean isEditing() {
        return !this.isAddNew_;
    }

    public Node getCurrentNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public void setSelectedLanguage(String selectedLanguage) {
        this.selectedLanguage_ = selectedLanguage;
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage_;
    }

    public void setIsDefaultLanguage(boolean isDefault) {
        this.isDefault_ = isDefault;
    }

    public boolean isDefaultLanguage() {
        return this.isDefault_;
    }

    private boolean hasNodeTypeNTResource(Node node) throws Exception {
        if (node.hasNodes()) {
            NodeIterator nodeIter = node.getNodes();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (!childNode.getPrimaryNodeType().getName().equals("nt:resource")) continue;
                return true;
            }
        }
        return false;
    }

    public Node storeValue(Event event) throws Exception {
        Map inputProperties;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node node = uiExplorer.getCurrentNode();
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        if (this.selectedLanguage_ == null) {
            uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.select-lang", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        if (!uiExplorer.hasAddPermission()) {
            uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        if (node.hasNode("exo:image")) {
            inputProperties = Utils.prepareMap((List)this.getChildren(), (Map)this.getInputProperties());
            try {
                multiLanguageService.addLanguage(node, inputProperties, this.getSelectedLanguage(), this.isDefaultLanguage(), "exo:image");
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return null;
            }
        }
        if (this.hasNodeTypeNTResource(node)) {
            inputProperties = Utils.prepareMap((List)this.getChildren(), (Map)this.getInputProperties());
            try {
                multiLanguageService.addFileLanguage(node, this.getSelectedLanguage(), inputProperties, this.isDefaultLanguage());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return null;
            }
        }
        Map map = Utils.prepareMap((List)this.getChildren(), (Map)this.properties);
        try {
            multiLanguageService.addLanguage(node, map, this.getSelectedLanguage(), this.isDefaultLanguage());
        }
        catch (AccessDeniedException ace) {
            uiApp.addMessage(new ApplicationMessage("UILanguageDialogForm.msg.access-denied", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        node.save();
        UIMultiLanguageManager uiManager = (UIMultiLanguageManager)this.getAncestorOfType(UIMultiLanguageManager.class);
        UIMultiLanguageForm uiMultiForm = (UIMultiLanguageForm)uiManager.getChild(UIMultiLanguageForm.class);
        uiMultiForm.updateSelect(node);
        if (this.isDefaultLanguage()) {
            uiExplorer.setLanguage(this.getSelectedLanguage());
        }
        uiManager.setRenderedChild(UIMultiLanguageForm.class);
        UIAddLanguageContainer uiAddContainer = (UIAddLanguageContainer)uiManager.getChild(UIAddLanguageContainer.class);
        UILanguageTypeForm uiLanguageTypeForm = (UILanguageTypeForm)uiAddContainer.getChild(UILanguageTypeForm.class);
        uiLanguageTypeForm.resetLanguage();
        uiAddContainer.removeChild(UILanguageDialogForm.class);
        uiAddContainer.setComponentDisplay(this.documentType_);
        if (!uiExplorer.getPreference().isJcrEnable()) {
            node.getSession().save();
        }
        uiExplorer.setIsHidePopup(true);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        uiExplorer.updateAjax(event);
        return null;
    }
}

