/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.ecm.jcr.ECMNameValidator;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertyForm;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveActionListener.class})})
public class UIPropertyForm
extends UIForm {
    public static final String FIELD_PROPERTY = "name";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_NAMESPACE = "namespace";
    private String repositoryName_;

    public UIPropertyForm() throws Exception {
        this.setMultiPart(true);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption("String", (Object)Integer.toString(1)));
        options.add(new SelectItemOption("Binary", (Object)Integer.toString(2)));
        options.add(new SelectItemOption("Boolean", (Object)Integer.toString(6)));
        options.add(new SelectItemOption("Date", (Object)Integer.toString(5)));
        options.add(new SelectItemOption("Double", (Object)Integer.toString(4)));
        options.add(new SelectItemOption("Long", (Object)Integer.toString(3)));
        options.add(new SelectItemOption("Name", (Object)Integer.toString(7)));
        options.add(new SelectItemOption("Path", (Object)Integer.toString(8)));
        options.add(new SelectItemOption("Reference", (Object)Integer.toString(9)));
        options.add(new SelectItemOption("undefined", (Object)Integer.toString(0)));
        ArrayList nsOptions = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_NAMESPACE, FIELD_NAMESPACE, nsOptions));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PROPERTY, FIELD_PROPERTY, null).addValidator(ECMNameValidator.class, new Object[0]));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_TYPE, FIELD_TYPE, options);
        uiSelectBox.setOnChange("ChangeType");
        this.addUIFormInput((UIFormInput)uiSelectBox);
        this.initMultiValuesField();
        this.setActions(new String[]{"Save"});
    }

    public List<SelectItemOption<String>> getNamespaces() throws Exception {
        String[] namespaces;
        ArrayList<SelectItemOption<String>> namespaceOptions = new ArrayList<SelectItemOption<String>>();
        for (String namespace : namespaces = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.repositoryName_).getNamespaceRegistry().getPrefixes()) {
            namespaceOptions.add((SelectItemOption<String>)new SelectItemOption(namespace, (Object)namespace));
        }
        return namespaceOptions;
    }

    public void refresh() throws Exception {
        this.reset();
        this.getUIFormSelectBox(FIELD_TYPE).setValue(Integer.toString(1));
        this.removeChildById(FIELD_VALUE);
        this.initMultiValuesField();
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    private void initMultiValuesField() throws Exception {
        UIFormMultiValueInputSet uiFormMValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiFormMValue.setId(FIELD_VALUE);
        uiFormMValue.setName(FIELD_VALUE);
        uiFormMValue.setType(UIFormStringInput.class);
        this.addUIFormInput((UIFormInput)uiFormMValue);
    }

    private Value createValue(Object value, int type, ValueFactory valueFactory) throws Exception {
        switch (type) {
            case 2: {
                return valueFactory.createValue((InputStream)new ByteArrayInputStream((byte[])value));
            }
            case 3: {
                return valueFactory.createValue(Long.valueOf((String)value).longValue());
            }
            case 4: {
                return valueFactory.createValue(Double.valueOf((String)value).doubleValue());
            }
            case 5: {
                return valueFactory.createValue((Calendar)((GregorianCalendar)value));
            }
            case 6: {
                return valueFactory.createValue(Boolean.parseBoolean(value.toString()));
            }
        }
        return valueFactory.createValue((String)value);
    }

    private Value[] createValues(List valueList, int type, ValueFactory valueFactory) throws Exception {
        Value[] values = new Value[valueList.size()];
        for (int i = 0; i < valueList.size(); ++i) {
            values[i] = this.createValue(valueList.get(i), type, valueFactory);
        }
        return values;
    }

    protected void lockForm(boolean isLock) {
        if (isLock) {
            this.setActions(new String[0]);
        } else {
            this.setActions(new String[]{"Save"});
        }
        this.getUIStringInput(FIELD_PROPERTY).setEditable(!isLock);
        this.getUIFormSelectBox(FIELD_TYPE).setEnable(!isLock);
        this.getUIFormSelectBox(FIELD_NAMESPACE).setEnable(!isLock);
    }

    static /* synthetic */ Value[] access$000(UIPropertyForm x0, List x1, int x2, ValueFactory x3) throws Exception {
        return x0.createValues(x1, x2, x3);
    }
}

