/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.portlet.PortletRequest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.jcr.ECMViewComponent;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIViewSearchResult;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={DownloadActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIViewSearchResult
extends UIContainer
implements ECMViewComponent {
    private Node node_;
    private String language_;

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        try {
            String nodeType = this.node_.getPrimaryNodeType().getName();
            return templateService.getTemplatePathByUser(false, nodeType, userName, repository);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.node_.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = Utils.getListAllowedFileType((Node)this.node_, (String)this.getRepository(), (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    public Node getNode() throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (this.node_.hasProperty("exo:language")) {
            String defaultLang = this.node_.getProperty("exo:language").getString();
            if (this.language_ == null) {
                this.language_ = defaultLang;
            }
            if (this.node_.hasNode("languages") && !this.language_.equals(defaultLang)) {
                Node curNode = this.node_.getNode("languages" + Utils.SLASH + this.language_);
                return curNode;
            }
            return this.node_;
        }
        return this.node_;
    }

    public Node getOriginalNode() throws Exception {
        return this.node_;
    }

    public String getIcons(Node node, String size) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)size);
    }

    public String getNodeType() throws Exception {
        return null;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.node_.hasProperty("exo:relation")) {
            Value[] vals = this.node_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public List getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.node_);
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public boolean isNodeTypeSupported() {
        return false;
    }

    public boolean isNodeTypeSupported(String nodeTypeName) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            return templateService.isManagedNodeType(nodeTypeName, repository);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPropertyContent(Node node, String property) {
        try {
            String value = node.getProperty(property).getString();
            if (value.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setNode(Node node) {
        this.node_ = node;
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        String[] workspaces = manageRepo.getWorkspaceNames();
        SessionProvider sessionProvider = SessionsUtils.getSessionProvider();
        for (String ws : workspaces) {
            try {
                return sessionProvider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.node_, this.language_);
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, repository);
    }

    public String getLanguage() {
        return this.language_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = loader.loadClass(className);
            service = this.getApplicationComponent(clazz);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return service;
    }

    public String getImage(Node node) throws Exception {
        DownloadService downloadService = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource inputResource = new InputStreamDownloadResource(input, "image");
        inputResource.setDownloadName(node.getName());
        return downloadService.getDownloadLink(downloadService.addDownloadResource((DownloadResource)inputResource));
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getPortalName() {
        PortalContainer pContainer = PortalContainer.getInstance();
        return pContainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        return ((ManageableRepository)this.node_.getSession().getRepository()).getConfiguration().getName();
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext pRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        PortletRequest pRequest = pRequestContext.getRequest();
        String prefixWebDAV = pRequest.getScheme() + "://" + pRequest.getServerName() + ":" + String.format("%s", pRequest.getServerPort());
        return prefixWebDAV;
    }

    public String getWorkspaceName() throws Exception {
        return this.node_.getSession().getWorkspace().getName();
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            return null;
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String encodeHTML(String text) throws Exception {
        return Utils.encodeHTML((String)text);
    }
}

