/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.fastcontentcreator;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.jcr.JCRResourceResolver;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.DialogFormFields;
import org.exoplatform.ecm.webui.component.fastcontentcreator.UIFastContentCreatorPortlet;
import org.exoplatform.ecm.webui.component.fastcontentcreator.UIFastContentCreatortForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={DialogFormFields.SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UIFastContentCreatortForm
extends DialogFormFields
implements UISelector {
    private String documentType_;
    private JCRResourceResolver jcrTemplateResourceResolver_;

    public UIFastContentCreatortForm() throws Exception {
        this.setActions(new String[]{"Save"});
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String repository = this.getPortletPreferences().getValue(Utils.REPOSITORY, "");
        try {
            this.resetScriptInterceptor();
            if (SessionsUtils.isAnonim()) {
                return templateService.getTemplatePathByAnonymous(true, this.documentType_, repository);
            }
            return templateService.getTemplatePathByUser(true, this.documentType_, userName, repository);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.documentType_};
            uiApp.addMessage(new ApplicationMessage("UIFastContentCreatortForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public void updateSelect(String selectField, String value) {
        this.isUpdateSelect_ = true;
        this.getUIStringInput(selectField).setValue((Object)value);
        UIFastContentCreatorPortlet uiContainer = (UIFastContentCreatorPortlet)this.getParent();
        uiContainer.removeChildById("PopupComponent");
    }

    public Node getCurrentNode() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        PortletPreferences preferences = this.getPortletPreferences();
        Session session = SessionsUtils.getSystemProvider().getSession(preferences.getValue("workspace", ""), repositoryService.getRepository(preferences.getValue(Utils.REPOSITORY, "")));
        return (Node)session.getItem(preferences.getValue("path", ""));
    }

    public void setTemplateNode(String type) {
        this.documentType_ = type;
    }

    public boolean isEditing() {
        return false;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        if (this.jcrTemplateResourceResolver_ == null) {
            this.newJCRTemplateResourceResolver();
        }
        return this.jcrTemplateResourceResolver_;
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext portletContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletContext.getRequest().getPreferences();
    }

    public void newJCRTemplateResourceResolver() {
        PortletPreferences preferences = this.getPortletPreferences();
        try {
            String repositoryName = preferences.getValue(Utils.REPOSITORY, "");
            String workspaceName = preferences.getValue("workspace", "");
            ManageableRepository manageableRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repositoryName);
            Session session = SessionsUtils.getSystemProvider().getSession(workspaceName, manageableRepository);
            this.jcrTemplateResourceResolver_ = new JCRResourceResolver(session, "exo:templateFile");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node storeValue(Event event) throws Exception {
        CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        PortletPreferences preferences = this.getPortletPreferences();
        String repository = preferences.getValue(Utils.REPOSITORY, "");
        String prefLocate = preferences.getValue("path", "");
        String prefType = preferences.getValue("type", "");
        String workspace = preferences.getValue("workspace", "");
        Session session = null;
        try {
            session = repositoryService.getRepository(repository).login(workspace);
        }
        catch (Exception e) {
            session = repositoryService.getRepository(repository).getSystemSession(workspace);
        }
        Map inputProperties = Utils.prepareMap((List)this.getChildren(), (Map)this.getInputProperties());
        Node homeNode = null;
        Node newNode = null;
        try {
            homeNode = (Node)session.getItem(prefLocate);
        }
        catch (AccessDeniedException ade) {
            Object[] args = new Object[]{prefLocate};
            uiApp.addMessage(new ApplicationMessage("UIFastContentCreatortForm.msg.access-denied", args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (PathNotFoundException pnfe) {
            Object[] args = new Object[]{prefLocate};
            uiApp.addMessage(new ApplicationMessage("UIFastContentCreatortForm.msg.path-not-found", args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        try {
            String addedPath = cmsService.storeNode(prefType, homeNode, inputProperties, true, repository);
            homeNode.getSession().save();
            if (homeNode.hasNode(addedPath.substring(addedPath.lastIndexOf("/") + 1))) {
                newNode = homeNode.getNode(addedPath.substring(addedPath.lastIndexOf("/") + 1));
            }
            this.reset();
            this.setIsResetForm(true);
            for (UIComponent uiChild : this.getChildren()) {
                if (uiChild instanceof UIFormMultiValueInputSet) {
                    ((UIFormMultiValueInputSet)uiChild).setValue(new ArrayList());
                    continue;
                }
                if (!(uiChild instanceof UIFormUploadInput)) continue;
                UploadService uploadService = (UploadService)this.getApplicationComponent(UploadService.class);
                uploadService.removeUpload(((UIFormUploadInput)uiChild).getUploadId());
            }
            session.save();
            session.refresh(false);
            homeNode.getSession().refresh(false);
            Object[] args = new Object[]{prefLocate};
            uiApp.addMessage(new ApplicationMessage("UIFastContentCreatortForm.msg.saved-successfully", args));
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getParent());
        }
        catch (AccessControlException ace) {
            throw new AccessDeniedException(ace.getMessage());
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIFastContentCreatortForm.msg.in-versioning", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            Node args = null;
            return args;
        }
        catch (AccessDeniedException e) {
            Object[] args = new Object[]{prefLocate};
            String key = "UIFastContentCreatortForm.msg.access-denied";
            uiApp.addMessage(new ApplicationMessage(key, args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            Node node = null;
            return node;
        }
        catch (LockException lock) {
            Object[] args = new Object[]{prefLocate};
            String key = "UIFastContentCreatortForm.msg.node-locked";
            uiApp.addMessage(new ApplicationMessage(key, args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            Node node = null;
            return node;
        }
        catch (ItemExistsException item) {
            Object[] args = new Object[]{prefLocate};
            String key = "UIFastContentCreatortForm.msg.node-isExist";
            uiApp.addMessage(new ApplicationMessage(key, args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return newNode;
    }

    static /* synthetic */ boolean access$002(UIFastContentCreatortForm x0, boolean x1) {
        x0.isShowingComponent_ = x1;
        return x0.isShowingComponent_;
    }

    static /* synthetic */ PortletPreferences access$100(UIFastContentCreatortForm x0) {
        return x0.getPortletPreferences();
    }

    static /* synthetic */ boolean access$202(UIFastContentCreatortForm x0, boolean x1) {
        x0.isRemovePreference_ = x1;
        return x0.isRemovePreference_;
    }
}

