/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl")
public class UIChildNodeDefinitionForm
extends UIFormInputSetWithAction {
    public static final String NAMESPACE = "childNamespace";
    public static final String CHILD_NAME = "childNodename";
    public static final String REQUIRED_PRIMARY_TYPE = "requiredPrimaryType";
    public static final String MULTIPLE = "childMultiple";
    public static final String MANDATORY = "childMandatory";
    public static final String AUTOCREATED = "childAutocreated";
    public static final String PROTECTED = "childProtected";
    public static final String PARENTVERSION = "childParentversion";
    public static final String DEFAULT_PRIMARY_TYPE = "defaultPrimaryType";
    public static final String SAME_NAME = "sameNameSiblings";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ACTION_UPDATE_CHILD = "UpdateChild";
    public static final String ACTION_CANCEL_CHILD = "CancelChild";

    public UIChildNodeDefinitionForm(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> sameNameListItem = new ArrayList<SelectItemOption>();
        sameNameListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        sameNameListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NAMESPACE, NAMESPACE, this.getNamespaces()));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CHILD_NAME, CHILD_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DEFAULT_PRIMARY_TYPE, DEFAULT_PRIMARY_TYPE, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(AUTOCREATED, AUTOCREATED, autoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(MANDATORY, MANDATORY, mandoListItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PARENTVERSION, PARENTVERSION, this.getParentVersions()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(PROTECTED, PROTECTED, protectedItem));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(SAME_NAME, SAME_NAME, sameNameListItem));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(REQUIRED_PRIMARY_TYPE, REQUIRED_PRIMARY_TYPE, null));
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private List<SelectItemOption<String>> getParentVersions() {
        ArrayList<SelectItemOption<String>> versionItem = new ArrayList<SelectItemOption<String>>();
        versionItem.add(new SelectItemOption("COPY", (Object)"1"));
        versionItem.add(new SelectItemOption("VERSION", (Object)"2"));
        versionItem.add(new SelectItemOption("INITIALIZE", (Object)"3"));
        versionItem.add(new SelectItemOption("COMPUTE", (Object)"4"));
        versionItem.add(new SelectItemOption("IGNORE", (Object)"5"));
        versionItem.add(new SelectItemOption("ABORT", (Object)"6"));
        return versionItem;
    }

    private List<SelectItemOption<String>> getNamespaces() throws Exception {
        ArrayList<SelectItemOption<String>> namespacesOptions = new ArrayList<SelectItemOption<String>>();
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(Utils.REPOSITORY, "");
        String[] namespaces = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNamespaceRegistry().getPrefixes();
        for (int i = 0; i < namespaces.length; ++i) {
            namespacesOptions.add((SelectItemOption<String>)new SelectItemOption(namespaces[i], (Object)namespaces[i]));
        }
        return namespacesOptions;
    }

    public void refresh() throws Exception {
        ArrayList<SelectItemOption> autoListItem = new ArrayList<SelectItemOption>();
        autoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        autoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> mandoListItem = new ArrayList<SelectItemOption>();
        mandoListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        mandoListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> sameNameListItem = new ArrayList<SelectItemOption>();
        sameNameListItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        sameNameListItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        ArrayList<SelectItemOption> protectedItem = new ArrayList<SelectItemOption>();
        protectedItem.add(new SelectItemOption(FALSE, (Object)FALSE));
        protectedItem.add(new SelectItemOption(TRUE, (Object)TRUE));
        this.getUIFormSelectBox(NAMESPACE).setOptions(this.getNamespaces()).setDisabled(false);
        this.getUIStringInput(CHILD_NAME).setEditable(true).setValue(null);
        this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setEditable(true).setValue(null);
        this.getUIFormSelectBox(AUTOCREATED).setOptions(autoListItem).setDisabled(false);
        this.getUIFormSelectBox(MANDATORY).setOptions(mandoListItem).setDisabled(false);
        this.getUIFormSelectBox(PARENTVERSION).setOptions(this.getParentVersions()).setDisabled(false);
        this.getUIFormSelectBox(PROTECTED).setOptions(protectedItem).setDisabled(false);
        this.getUIFormSelectBox(SAME_NAME).setOptions(sameNameListItem).setDisabled(false);
        this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setEditable(true).setValue(null);
        UINodeTypeForm uiForm = (UINodeTypeForm)this.getParent();
        UIFormInputSetWithAction uiChildTab = (UIFormInputSetWithAction)uiForm.getChildById("childNodeDefinition");
        uiForm.setActionInTab(uiChildTab);
    }

    public void update(NodeType nodeType, String childNodeName) throws Exception {
        if (childNodeName != null) {
            NodeDefinition[] nodeDefinitions = nodeType.getChildNodeDefinitions();
            for (int i = 0; i < nodeDefinitions.length; ++i) {
                String name = nodeDefinitions[i].getName();
                if (!name.equals(childNodeName)) continue;
                if (childNodeName.indexOf(":") > -1) {
                    String[] arr = childNodeName.split(":");
                    this.getUIFormSelectBox(NAMESPACE).setValue(arr[0].trim());
                    this.getUIStringInput(CHILD_NAME).setValue((Object)arr[1].trim());
                } else {
                    this.getUIFormSelectBox(NAMESPACE).setValue("");
                    this.getUIStringInput(CHILD_NAME).setValue((Object)childNodeName);
                }
                NodeType defaultNodeType = nodeDefinitions[i].getDefaultPrimaryType();
                if (defaultNodeType != null) {
                    this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setValue((Object)defaultNodeType.getName());
                }
                String sameName = String.valueOf(nodeDefinitions[i].allowsSameNameSiblings());
                this.getUIFormSelectBox(SAME_NAME).setValue(sameName);
                this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(nodeDefinitions[i].isMandatory()));
                this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(nodeDefinitions[i].isAutoCreated()));
                this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(nodeDefinitions[i].isProtected()));
                String parentVersion = Integer.toString(nodeDefinitions[i].getOnParentVersion());
                this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
                StringBuilder requiredType = new StringBuilder();
                NodeType[] requiredPrimaryType = nodeDefinitions[i].getRequiredPrimaryTypes();
                for (int j = 0; j < requiredPrimaryType.length; ++j) {
                    if (requiredType.length() > 0) {
                        requiredType.append(" , ");
                    }
                    requiredType.append(requiredPrimaryType[j].getName());
                }
                this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setValue((Object)requiredType.toString());
                break;
            }
        }
        this.getUIFormSelectBox(NAMESPACE).setDisabled(true);
        this.getUIStringInput(CHILD_NAME).setEditable(false);
        this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setEditable(false);
        this.getUIFormSelectBox(AUTOCREATED).setDisabled(true);
        this.getUIFormSelectBox(MANDATORY).setDisabled(true);
        this.getUIFormSelectBox(PARENTVERSION).setDisabled(true);
        this.getUIFormSelectBox(PROTECTED).setDisabled(true);
        this.getUIFormSelectBox(SAME_NAME).setDisabled(true);
        this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setEditable(false);
    }

    private void setValues(NodeDefinitionValue node) {
        String childNodeName = node.getName();
        if (childNodeName.indexOf(":") > -1) {
            String[] arr = childNodeName.split(":");
            this.getUIFormSelectBox(NAMESPACE).setValue(arr[0].trim());
            this.getUIStringInput(CHILD_NAME).setValue((Object)arr[1].trim());
        } else {
            this.getUIFormSelectBox(NAMESPACE).setValue("");
            this.getUIStringInput(CHILD_NAME).setValue((Object)childNodeName);
        }
        this.getUIStringInput(DEFAULT_PRIMARY_TYPE).setValue((Object)node.getDefaultNodeTypeName());
        this.getUIFormSelectBox(SAME_NAME).setValue(String.valueOf(node.isSameNameSiblings()));
        this.getUIFormSelectBox(MANDATORY).setValue(String.valueOf(node.isMandatory()));
        this.getUIFormSelectBox(AUTOCREATED).setValue(String.valueOf(node.isAutoCreate()));
        this.getUIFormSelectBox(PROTECTED).setValue(String.valueOf(node.isReadOnly()));
        String parentVersion = Integer.toString(node.getOnVersion());
        this.getUIFormSelectBox(PARENTVERSION).setValue(parentVersion);
        List requiredPrimaryType = node.getRequiredNodeTypeNames();
        StringBuilder listRequired = new StringBuilder();
        for (int j = 0; j < requiredPrimaryType.size(); ++j) {
            if (listRequired.length() < 1) {
                listRequired.append((String)requiredPrimaryType.get(j));
                continue;
            }
            listRequired.append(",").append((String)requiredPrimaryType.get(j));
        }
        this.getUIStringInput(REQUIRED_PRIMARY_TYPE).setValue((Object)listRequired.toString());
    }

    private NodeDefinitionValue getChildNodeByName(String nodeName, List<NodeDefinitionValue> listNode) {
        for (NodeDefinitionValue node : listNode) {
            if (!node.getName().equals(nodeName)) continue;
            return node;
        }
        return null;
    }

    static /* synthetic */ NodeDefinitionValue access$000(UIChildNodeDefinitionForm x0, String x1, List x2) {
        return x0.getChildNodeByName(x1, x2);
    }

    static /* synthetic */ void access$100(UIChildNodeDefinitionForm x0, NodeDefinitionValue x1) {
        x0.setValues(x1);
    }
}

