/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.component.browsecontent.BCTreeNode;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UICategoryTree;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/browse/UICategoryTree.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UICategoryTree
extends UIComponent {
    private BCTreeNode treeRoot_;

    public BCTreeNode getTreeRoot() {
        return this.treeRoot_;
    }

    public void setTreeRoot(Node node) throws Exception {
        this.treeRoot_ = new BCTreeNode(node);
    }

    public Node getRootNode() throws Exception {
        return ((UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class)).getRootNode();
    }

    public String getIcons(Node node, String type) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)type);
    }

    protected boolean isCategories(NodeType nodeType) {
        for (String type : Utils.CATEGORY_NODE_TYPES) {
            if (!nodeType.getName().equals(type)) continue;
            return true;
        }
        return false;
    }

    public List<Node> getCategoryList(Node node) throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator item = node.getNodes();
        while (item.hasNext()) {
            Node child = item.nextNode();
            if (!this.isCategories(child.getPrimaryNodeType())) continue;
            nodes.add(child);
        }
        return nodes;
    }

    public void buildTree(String path) throws Exception {
        this.getTreeRoot().getChildren().clear();
        String[] arr = path.replaceFirst(this.getTreeRoot().getPath(), "").split("/");
        BCTreeNode temp = this.getTreeRoot();
        for (String nodeName : arr) {
            if (nodeName.length() == 0) continue;
            temp.setChildren(this.getCategoryList(temp.getNode()));
            temp = temp.getChild(nodeName);
            if (temp != null) continue;
            return;
        }
        temp.setChildren(this.getCategoryList(temp.getNode()));
    }
}

