/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertiesManager;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertyForm;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class})})
public class UIPropertyForm
extends UIForm {
    public static final String FIELD_PROPERTY = "name";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_NAMESPACE = "namespace";
    public static final String FIELD_MULTIPLE = "multiple";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private String repositoryName_;
    private String propertyName_;
    private boolean isAddNew_ = true;
    private boolean isMultiple_ = false;

    public UIPropertyForm() throws Exception {
        this.setMultiPart(true);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption("String", (Object)Integer.toString(1)));
        options.add(new SelectItemOption("Binary", (Object)Integer.toString(2)));
        options.add(new SelectItemOption("Boolean", (Object)Integer.toString(6)));
        options.add(new SelectItemOption("Date", (Object)Integer.toString(5)));
        options.add(new SelectItemOption("Double", (Object)Integer.toString(4)));
        options.add(new SelectItemOption("Long", (Object)Integer.toString(3)));
        options.add(new SelectItemOption("Name", (Object)Integer.toString(7)));
        options.add(new SelectItemOption("Path", (Object)Integer.toString(8)));
        options.add(new SelectItemOption("Reference", (Object)Integer.toString(9)));
        ArrayList nsOptions = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_NAMESPACE, FIELD_NAMESPACE, nsOptions));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PROPERTY, FIELD_PROPERTY, null).addValidator(ECMNameValidator.class, new Object[0]));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_TYPE, FIELD_TYPE, options);
        uiSelectBox.setOnChange("ChangeType");
        this.addUIFormInput((UIFormInput)uiSelectBox);
        ArrayList<SelectItemOption> multipleOpt = new ArrayList<SelectItemOption>();
        multipleOpt.add(new SelectItemOption(TRUE, (Object)TRUE));
        multipleOpt.add(new SelectItemOption(FALSE, (Object)FALSE));
        UIFormSelectBox uiMultiSelectBox = new UIFormSelectBox(FIELD_MULTIPLE, FIELD_MULTIPLE, multipleOpt);
        uiMultiSelectBox.setOnChange("ChangeType");
        this.addUIFormInput((UIFormInput)uiMultiSelectBox);
        this.initValueField();
        this.setActions(new String[]{"Save", "Reset", "Cancel"});
    }

    public List<SelectItemOption<String>> getNamespaces() throws Exception {
        String[] namespaces;
        ArrayList<SelectItemOption<String>> namespaceOptions = new ArrayList<SelectItemOption<String>>();
        for (String namespace : namespaces = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(this.repositoryName_).getNamespaceRegistry().getPrefixes()) {
            namespaceOptions.add((SelectItemOption<String>)new SelectItemOption(namespace, (Object)namespace));
        }
        return namespaceOptions;
    }

    public void refresh() throws Exception {
        this.reset();
        this.isAddNew_ = true;
        this.getUIFormSelectBox(FIELD_TYPE).setValue(Integer.toString(1));
        this.removeChildById(FIELD_VALUE);
        this.getUIStringInput(FIELD_PROPERTY).setEditable(this.isAddNew_);
        this.getUIFormSelectBox(FIELD_TYPE).setEnable(this.isAddNew_);
        this.getUIFormSelectBox(FIELD_MULTIPLE).setEnable(this.isAddNew_);
        this.getUIFormSelectBox(FIELD_NAMESPACE).setEnable(this.isAddNew_);
        this.initValueField();
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    private void initValueField() throws Exception {
        UIFormMultiValueInputSet uiFormMValue = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiFormMValue.setId(FIELD_VALUE);
        uiFormMValue.setName(FIELD_VALUE);
        uiFormMValue.setType(UIFormStringInput.class);
        this.addUIFormInput((UIFormInput)uiFormMValue);
    }

    private Value createValue(Object value, int type, ValueFactory valueFactory) throws Exception {
        switch (type) {
            case 2: {
                return valueFactory.createValue((InputStream)value);
            }
            case 3: {
                return valueFactory.createValue(Long.parseLong(value.toString()));
            }
            case 4: {
                return valueFactory.createValue(Double.parseDouble(value.toString()));
            }
            case 5: {
                return valueFactory.createValue((Calendar)((GregorianCalendar)value));
            }
            case 6: {
                return valueFactory.createValue(Boolean.parseBoolean(value.toString()));
            }
        }
        return valueFactory.createValue(value.toString(), type);
    }

    private Value[] createValues(List valueList, int type, ValueFactory valueFactory) throws Exception {
        Value[] values = new Value[valueList.size()];
        for (int i = 0; i < valueList.size(); ++i) {
            values[i] = this.createValue(valueList.get(i), type, valueFactory);
        }
        return values;
    }

    protected void lockForm(boolean isLock) {
        if (isLock) {
            this.setActions(new String[0]);
        } else {
            this.setActions(new String[]{"Save", "Reset", "Cancel"});
        }
        this.getUIStringInput(FIELD_PROPERTY).setEditable(!isLock);
        this.getUIFormSelectBox(FIELD_TYPE).setEnable(!isLock);
        this.getUIFormSelectBox(FIELD_NAMESPACE).setEnable(!isLock);
    }

    private Node getCurrentNode() throws Exception {
        UIPropertiesManager uiManager = (UIPropertiesManager)this.getParent();
        return uiManager.getCurrentNode();
    }

    public void loadForm(String propertyName) throws Exception {
        Node currentNode = this.getCurrentNode();
        this.propertyName_ = propertyName;
        this.isAddNew_ = false;
        String[] propertyInfo = propertyName.split(":");
        this.getUIFormSelectBox(FIELD_NAMESPACE).setDisabled(true).setValue(propertyInfo[0]);
        this.getUIStringInput(FIELD_PROPERTY).setEditable(false).setValue((Object)propertyInfo[1]);
        Property property = currentNode.getProperty(propertyName);
        this.isMultiple_ = property.getDefinition().isMultiple();
        if (property.getType() == 0) {
            this.getUIFormSelectBox(FIELD_TYPE).setDisabled(true).setValue("1");
        } else {
            this.getUIFormSelectBox(FIELD_TYPE).setDisabled(true).setValue(Integer.toString(property.getType()));
        }
        this.getUIFormSelectBox(FIELD_MULTIPLE).setDisabled(true).setValue(Boolean.toString(this.isMultiple_));
        if (this.isMultiple_) {
            UIFormMultiValueInputSet multiValueInputSet = (UIFormMultiValueInputSet)this.getUIInput(FIELD_VALUE);
            ArrayList<String> listValue = new ArrayList<String>();
            block14: for (Value value : property.getValues()) {
                switch (property.getType()) {
                    case 2: {
                        continue block14;
                    }
                    case 3: {
                        listValue.add(Long.toString(value.getLong()));
                        continue block14;
                    }
                    case 4: {
                        listValue.add(Double.toString(value.getDouble()));
                        continue block14;
                    }
                    case 5: {
                        listValue.add(value.getDate().getTime().toString());
                        continue block14;
                    }
                    case 6: {
                        listValue.add(Boolean.toString(value.getBoolean()));
                        continue block14;
                    }
                    default: {
                        listValue.add(value.getString());
                    }
                }
            }
            this.changeMultipleType(multiValueInputSet, property.getType());
            multiValueInputSet.setValue(listValue);
        } else {
            Value value = property.getValue();
            this.changeSingleType(property.getType());
            switch (property.getType()) {
                case 2: {
                    break;
                }
                case 3: {
                    UIFormStringInput uiForm = this.getUIStringInput(FIELD_VALUE);
                    uiForm.setValue((Object)Long.toString(value.getLong()));
                    break;
                }
                case 4: {
                    UIFormStringInput uiForm = this.getUIStringInput(FIELD_VALUE);
                    uiForm.setValue((Object)Double.toString(value.getDouble()));
                    break;
                }
                case 5: {
                    UIFormDateTimeInput uiFormDateTimeInput = this.getUIFormDateTimeInput(FIELD_VALUE);
                    uiFormDateTimeInput.setValue((Object)value.getDate().getTime().toString());
                    break;
                }
                case 6: {
                    UIFormCheckBoxInput uiFormCheckBoxInput = this.getUIFormCheckBoxInput(FIELD_VALUE);
                    uiFormCheckBoxInput.setValue((Object)Boolean.toString(value.getBoolean()));
                    break;
                }
                default: {
                    UIFormStringInput uiForm = this.getUIStringInput(FIELD_VALUE);
                    uiForm.setValue((Object)value.getString());
                    break;
                }
            }
        }
    }

    private Object processValue(int type) throws Exception {
        Object value = null;
        UIComponent uiChild = this.getChildById(FIELD_VALUE);
        if (type == 6) {
            UIFormCheckBoxInput checkbox = (UIFormCheckBoxInput)uiChild;
            value = checkbox.isChecked();
        } else if (type == 5) {
            UIFormDateTimeInput dateInput = (UIFormDateTimeInput)uiChild;
            value = dateInput.getCalendar();
        } else if (type == 2) {
            UIFormUploadInput binaryInput = (UIFormUploadInput)uiChild;
            if (binaryInput.getUploadDataAsStream() != null) {
                value = binaryInput.getUploadDataAsStream();
            }
        } else {
            UIFormStringInput uiStringInput = (UIFormStringInput)uiChild;
            value = uiStringInput.getValue();
        }
        return value;
    }

    private List processValues(int type) throws Exception {
        UIFormMultiValueInputSet multiValueInputSet = (UIFormMultiValueInputSet)this.getUIInput(FIELD_VALUE);
        List<InputStream> valueList = new ArrayList();
        if (type == 6) {
            for (UIComponent child : multiValueInputSet.getChildren()) {
                UIFormCheckBoxInput checkbox = (UIFormCheckBoxInput)child;
                valueList.add((InputStream)((Object)Boolean.valueOf(checkbox.isChecked())));
            }
        } else if (type == 5) {
            for (UIComponent child : multiValueInputSet.getChildren()) {
                UIFormDateTimeInput dateInput = (UIFormDateTimeInput)child;
                valueList.add((InputStream)((Object)dateInput.getCalendar()));
            }
        } else if (type == 2) {
            for (UIComponent child : multiValueInputSet.getChildren()) {
                UIFormUploadInput binaryInput = (UIFormUploadInput)child;
                if (binaryInput.getUploadDataAsStream() == null) continue;
                InputStream content = binaryInput.getUploadDataAsStream();
                valueList.add(content);
            }
        } else {
            valueList = multiValueInputSet.getValue();
        }
        return valueList;
    }

    private void changeMultipleType(UIFormMultiValueInputSet uiFormMultiValue, int type) {
        if (2 == type) {
            uiFormMultiValue.setType(UIFormUploadInput.class);
        } else if (6 == type) {
            uiFormMultiValue.setType(UIFormCheckBoxInput.class);
        } else if (5 == type) {
            uiFormMultiValue.setType(UIFormDateTimeInput.class);
        } else {
            uiFormMultiValue.setType(UIFormStringInput.class);
        }
    }

    private void changeSingleType(int type) {
        this.removeChildById(FIELD_VALUE);
        if (2 == type) {
            this.addUIFormInput((UIFormInput)new UIFormUploadInput(FIELD_VALUE, FIELD_VALUE));
        } else if (6 == type) {
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VALUE, FIELD_VALUE, null));
        } else if (5 == type) {
            this.addUIFormInput((UIFormInput)new UIFormDateTimeInput(FIELD_VALUE, FIELD_VALUE, null));
        } else {
            this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_VALUE, FIELD_VALUE, null));
        }
    }

    static /* synthetic */ void access$000(UIPropertyForm x0, UIFormMultiValueInputSet x1, int x2) {
        x0.changeMultipleType(x1, x2);
    }

    static /* synthetic */ void access$100(UIPropertyForm x0, int x1) {
        x0.changeSingleType(x1);
    }

    static /* synthetic */ Node access$200(UIPropertyForm x0) throws Exception {
        return x0.getCurrentNode();
    }

    static /* synthetic */ boolean access$300(UIPropertyForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ String access$400(UIPropertyForm x0) {
        return x0.propertyName_;
    }

    static /* synthetic */ List access$500(UIPropertyForm x0, int x1) throws Exception {
        return x0.processValues(x1);
    }

    static /* synthetic */ Value[] access$600(UIPropertyForm x0, List x1, int x2, ValueFactory x3) throws Exception {
        return x0.createValues(x1, x2, x3);
    }

    static /* synthetic */ Object access$700(UIPropertyForm x0, int x1) throws Exception {
        return x0.processValue(x1);
    }

    static /* synthetic */ Value access$800(UIPropertyForm x0, Object x1, int x2, ValueFactory x3) throws Exception {
        return x0.createValue(x1, x2, x3);
    }

    static /* synthetic */ boolean access$302(UIPropertyForm x0, boolean x1) {
        x0.isAddNew_ = x1;
        return x0.isAddNew_;
    }
}

