/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.metadata.UIMetadataList;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/metadata/UIMetadataList.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIMetadataList.msg.confirm-delete")})
public class UIMetadataList
extends UIContainer {
    public static final String INTERNAL_USE = "exo:internalUse".intern();

    public UIMetadataList() throws Exception {
        this.addChild(UIPageIterator.class, null, "MetaDataListIterator");
    }

    public void updateGrid() throws Exception {
        UIPageIterator uiPageIterator = (UIPageIterator)this.getChild(UIPageIterator.class);
        ObjectPageList pageList = new ObjectPageList(this.getAllMetadatas(), 10);
        uiPageIterator.setPageList((PageList)pageList);
    }

    public List<Metadata> getAllMetadatas() throws Exception {
        ArrayList<Metadata> metadatas = new ArrayList<Metadata>();
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List nodetypes = metadataService.getAllMetadatasNodeType(repository);
        Collections.sort(nodetypes, new Utils.NodeTypeNameComparator());
        for (NodeType nt : nodetypes) {
            Metadata mt = new Metadata(this);
            mt.setName(nt.getName());
            mt.isTemplate(metadataService.hasMetadata(nt.getName(), repository));
            PropertyDefinition def = ((ExtendedNodeType)nt).getPropertyDefinitions(INTERNAL_USE).getAnyDefinition();
            if (def.getDefaultValues() != null && def.getDefaultValues()[0].getBoolean()) {
                mt.setInternalUse("True");
            } else {
                mt.setInternalUse("False");
            }
            metadatas.add(mt);
        }
        return metadatas;
    }

    public List getListMetadata() throws Exception {
        return ((UIPageIterator)this.getChild(UIPageIterator.class)).getCurrentPageData();
    }
}

