/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManager;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITaxonomyForm
extends UIForm {
    private static final String FIELD_PARENT = "parentPath";
    private static final String FIELD_NAME = "taxonomyName";
    private static final String ROOT_PATH = "/jcr:system/exo:ecm/";

    public UITaxonomyForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_PARENT, FIELD_PARENT, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
    }

    public void setParent(String path) {
        path = path.replaceFirst(ROOT_PATH, "");
        this.getUIFormInputInfo(FIELD_PARENT).setValue((Object)path);
        this.getUIStringInput(FIELD_NAME).setValue(null);
    }

    public void addTaxonomy(String parentPath, String name) throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getAncestorOfType(UITaxonomyManager.class);
        ((CategoriesService)this.getApplicationComponent(CategoriesService.class)).addTaxonomy(parentPath, name, uiManager.getRepository());
    }
}

