/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplateForm;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={RefreshActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE)})
public class UITemplateForm
extends UIFormTabPane
implements UISelectable {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_LABEL = "label";
    public static final String FIELD_ISTEMPLATE = "isDocumentTemplate";
    public static final String FIELD_DIALOG = "dialog";
    public static final String FIELD_VIEW = "view";
    public static final String FIELD_TAB_TEMPLATE = "template";
    public static final String FIELD_TAB_DIALOG = "defaultDialog";
    public static final String FIELD_TAB_VIEW = "defaultView";
    public static final String FIELD_PERMISSION = "permission";

    public UITemplateForm() throws Exception {
        super("UITemplateForm");
        UIFormInputSetWithAction templateTab = new UIFormInputSetWithAction(FIELD_TAB_TEMPLATE);
        templateTab.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_NAME, FIELD_NAME, this.getOption()));
        templateTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_LABEL, FIELD_LABEL, null).addValidator(MandatoryValidator.class, new Object[0]));
        templateTab.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ISTEMPLATE, FIELD_ISTEMPLATE, null).setChecked(true));
        templateTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null).setEditable(false));
        templateTab.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)templateTab);
        this.setSelectedTab(templateTab.getId());
        UIFormInputSet defaultDialogTab = new UIFormInputSet(FIELD_TAB_DIALOG);
        defaultDialogTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DIALOG, FIELD_DIALOG, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput(defaultDialogTab);
        UIFormInputSet defaultViewTab = new UIFormInputSet(FIELD_TAB_VIEW);
        defaultViewTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_VIEW, FIELD_VIEW, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput(defaultViewTab);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    public void refresh() throws Exception {
        this.getUIStringInput(FIELD_LABEL).setValue((Object)"");
        this.getUIFormCheckBoxInput(FIELD_ISTEMPLATE).setChecked(false);
        this.getUIFormTextAreaInput(FIELD_DIALOG).setValue((Object)"");
        this.getUIFormTextAreaInput(FIELD_VIEW).setValue((Object)"");
        this.getUIStringInput(FIELD_PERMISSION).setValue((Object)"");
        this.getUIFormSelectBox(FIELD_NAME).setOptions(this.getOption());
    }

    private String getRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }

    public List<SelectItemOption<String>> getOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        String repository = this.getRepository();
        ExtendedNodeTypeManager nodeTypeManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNodeTypeManager();
        Node templatesHome = ((TemplateService)this.getApplicationComponent(TemplateService.class)).getTemplatesHome(repository, SessionProviderFactory.createSessionProvider());
        if (templatesHome != null) {
            NodeIterator templateIter = templatesHome.getNodes();
            ArrayList<String> templates = new ArrayList<String>();
            while (templateIter.hasNext()) {
                templates.add(templateIter.nextNode().getName());
            }
            NodeTypeIterator iter = nodeTypeManager.getAllNodeTypes();
            while (iter.hasNext()) {
                NodeType nodeType = iter.nextNodeType();
                String nodeTypeName = nodeType.getName();
                if (templates.contains(nodeTypeName)) continue;
                options.add((SelectItemOption<String>)new SelectItemOption(nodeTypeName, (Object)nodeTypeName));
            }
            Collections.sort(options, new TemplateNameComparator());
        }
        return options;
    }

    public void doSelect(String selectField, Object value) {
        UIFormInputSetWithAction uiFormAction = (UIFormInputSetWithAction)this.getChildById(FIELD_TAB_TEMPLATE);
        uiFormAction.getUIStringInput(FIELD_PERMISSION).setValue((Object)value.toString());
        UITemplatesManager uiManager = (UITemplatesManager)this.getAncestorOfType(UITemplatesManager.class);
        uiManager.removeChildById("AddNewTemplatePermission");
    }

    static /* synthetic */ String access$000(UITemplateForm x0) {
        return x0.getRepository();
    }
}

