/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BCTreeNode {
    private boolean isExpanded_;
    private Node node_;
    private List<BCTreeNode> children_ = new ArrayList();

    public BCTreeNode(Node node, List<Node> children) {
        this.node_ = node;
        this.isExpanded_ = true;
        this.setChildren(children);
    }

    public BCTreeNode(Node node) {
        this.node_ = node;
        this.isExpanded_ = false;
    }

    public int getLevel() throws RepositoryException {
        return this.node_.getDepth();
    }

    public boolean isExpanded() {
        return this.isExpanded_;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded_ = isExpanded;
    }

    public String getName() throws RepositoryException {
        return this.node_.getName();
    }

    public String getPath() throws RepositoryException {
        return this.node_.getPath();
    }

    public Node getNode() {
        return this.node_;
    }

    public void setNode(Node node) {
        this.node_ = node;
    }

    public List<BCTreeNode> getChildren() {
        return this.children_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public BCTreeNode getChild(String relPath) throws RepositoryException {
        for (BCTreeNode child : this.children_) {
            String path = child.getPath();
            String nodeName = path.substring(path.lastIndexOf("/") + 1);
            if (!nodeName.equals(relPath)) continue;
            return child;
        }
        return null;
    }

    public void setChildren(List<Node> children) {
        this.setExpanded(true);
        for (Node child : children) {
            this.children_.add(new BCTreeNode(child));
        }
    }
}

