/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/webui/component/explorer/UIWorkingArea.gtmpl"), @ComponentConfig(type=UIRightClickPopupMenu.class, id="ECMContextMenu", template="system:/groovy/webui/core/UIRightClickPopupMenu.gtmpl", events={@EventConfig(listeners={EditDocumentActionListener.class}), @EventConfig(listeners={CopyActionListener.class}), @EventConfig(listeners={CutActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}), @EventConfig(listeners={LockActionListener.class}), @EventConfig(listeners={UnlockActionListener.class}), @EventConfig(listeners={CheckInActionListener.class}), @EventConfig(listeners={CheckOutActionListener.class}), @EventConfig(listeners={RenameActionListener.class}), @EventConfig(listeners={CustomActionListener.class}), @EventConfig(listeners={PasteActionListener.class}), @EventConfig(listeners={AddFolderActionListener.class}), @EventConfig(listeners={AddDocumentActionListener.class}), @EventConfig(listeners={UploadActionListener.class}), @EventConfig(listeners={MoveNodeActionListener.class}, confirm="UIWorkingArea.msg.confirm-move")})})
public class UIWorkingArea
extends UIContainer {
    private static final String RELATION_PROP = "exo:relation";
    public static final String WS_NAME = "workspaceName";
    private boolean isMultiSelect_ = false;
    private LinkedList<ClipboardCommand> virtualClipboards_ = new LinkedList();
    private int pasteNum_;
    private boolean isLastPaste_ = false;

    public UIWorkingArea() throws Exception {
        this.addChild(UIRightClickPopupMenu.class, "ECMContextMenu", null);
        this.addChild(UISideBar.class, null, null);
        this.addChild(UIDocumentWorkspace.class, null, null);
    }

    public boolean isShowSideBar() throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getParent();
        return jcrExplorer.getPreference().isShowSideBar();
    }

    public void setShowSideBar(boolean b) throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getParent();
        jcrExplorer.getPreference().setShowSideBar(b);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ManageableRepository repo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        String workspace = repo.getConfiguration().getDefaultWorkspaceName();
        Session session = SessionProviderFactory.createSystemProvider().getSession(workspace, repo);
        return session.getNodeByUUID(uuid);
    }

    public boolean isReferenceableNode(Node node) throws Exception {
        NodeType[] nodeTypes;
        for (NodeType type : nodeTypes = node.getMixinNodeTypes()) {
            if (!type.getName().equals("mix:referenceable")) continue;
            return true;
        }
        return false;
    }

    public boolean isPreferenceNode(Node node) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isPreferenceNode(node);
    }

    public boolean isSameNameSibling(Node node) throws Exception {
        return node.getPath().endsWith("]");
    }

    public boolean isEditable(String nodePath, Session session) throws Exception {
        Node node = (Node)session.getItem(nodePath);
        return this.isEditable(node);
    }

    public boolean isEditable(Node node) throws Exception {
        String nodeType = node.getPrimaryNodeType().getName();
        for (String type : Utils.NON_EDITABLE_NODETYPES) {
            if (!type.equalsIgnoreCase(nodeType)) continue;
            return false;
        }
        return true;
    }

    public boolean isVersionableOrAncestor(Node node) throws RepositoryException {
        return Utils.isVersionable((Node)node) || this.isAncestorVersionable(node);
    }

    public String getVersionNumber(Node node) throws RepositoryException {
        if (!Utils.isVersionable((Node)node)) {
            return "-";
        }
        return node.getBaseVersion().getName();
    }

    public boolean isAncestorVersionable(Node node) throws RepositoryException {
        int depth = node.getDepth() - 1;
        Node parent = (Node)node.getAncestor(depth);
        while (parent != null && depth != 0) {
            if (parent.isNodeType("mix:versionable")) {
                return true;
            }
            parent = (Node)node.getAncestor(--depth);
        }
        return false;
    }

    private void removeMixins(Node node) throws Exception {
        NodeType[] mixins;
        for (NodeType nodeType : mixins = node.getMixinNodeTypes()) {
            node.removeMixin(nodeType.getName());
        }
    }

    public boolean isJcrViewEnable() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getPreference().isJcrEnable();
    }

    public String getActionsList(Node node) throws Exception {
        if (node == null) {
            return "";
        }
        node.refresh(true);
        StringBuilder actionsList = new StringBuilder();
        boolean isEditable = this.isEditable(node);
        boolean isLocked = node.isLocked();
        boolean holdsLock = node.holdsLock();
        boolean isSameNameSibling = this.isSameNameSibling(node);
        boolean isJcrEnable = this.isJcrViewEnable();
        boolean isVersionable = Utils.isVersionable((Node)node);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (this.isVersionableOrAncestor(node)) {
            if (node.isCheckedOut()) {
                if (isVersionable) {
                    actionsList.append("CheckIn");
                }
                if (isEditable) {
                    actionsList.append(",EditDocument");
                }
                if (!isSameNameSibling) {
                    if (holdsLock) {
                        actionsList.append(",Unlock");
                    } else if (!isLocked) {
                        actionsList.append(",Lock");
                    }
                }
                if (!isSameNameSibling) {
                    actionsList.append(",Copy");
                    actionsList.append(",Cut");
                }
                actionsList.append(",Rename");
                if (isJcrEnable) {
                    actionsList.append(",Save");
                }
                actionsList.append(",Delete");
            } else {
                if (isVersionable) {
                    actionsList.append(",CheckOut");
                }
                if (!isSameNameSibling) {
                    if (holdsLock) {
                        actionsList.append(",Unlock");
                    } else if (!isLocked) {
                        actionsList.append(",Lock");
                    }
                }
                if (!isSameNameSibling) {
                    actionsList.append(",Copy");
                }
                actionsList.append(",Rename");
            }
        } else {
            if (isEditable) {
                actionsList.append(",EditDocument");
            }
            if (!isSameNameSibling) {
                if (holdsLock) {
                    actionsList.append(",Unlock");
                } else if (!isLocked) {
                    actionsList.append(",Lock");
                }
            }
            if (!isSameNameSibling) {
                actionsList.append(",Copy");
                actionsList.append(",Cut");
            }
            actionsList.append(",Rename");
            if (this.isJcrViewEnable()) {
                actionsList.append(",Save");
            }
            actionsList.append(",Delete");
        }
        if (uiExplorer.getAllClipBoard().size() > 0) {
            actionsList.append(",Paste");
        }
        return actionsList.toString();
    }

    private boolean hasPermission(String userName, Value[] roles) throws Exception {
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getApplicationComponent(IdentityRegistry.class);
        if (SystemIdentity.SYSTEM.equalsIgnoreCase(userName)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userName);
        if (identity == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (membershipEntry == null) {
                return false;
            }
            if (!identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        ArrayList<Node> safeActions = new ArrayList<Node>();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String userName = context.getRemoteUser();
        ActionServiceContainer actionContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        List unsafeActions = actionContainer.getCustomActionsNode(node, "read");
        if (unsafeActions == null) {
            return new ArrayList<Node>();
        }
        for (Node actionNode : unsafeActions) {
            Value[] roles = actionNode.getProperty("exo:roles").getValues();
            if (!this.hasPermission(userName, roles)) continue;
            safeActions.add(actionNode);
        }
        return safeActions;
    }

    private void multipleCopy(String[] srcPaths, String[] wsNames, Event event) throws Exception {
        for (int i = 0; i < srcPaths.length; ++i) {
            this.processCopy(srcPaths[i], wsNames[i], event);
        }
    }

    private void processCopy(String srcPath, String wsName, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        try {
            session.getItem(srcPath);
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        try {
            LinkedList clipboards = uiExplorer.getAllClipBoard();
            for (ClipboardCommand command : clipboards) {
                if (!command.getSrcPath().equals(srcPath)) continue;
                clipboards.remove(command);
                break;
            }
            ClipboardCommand clipboard = new ClipboardCommand();
            clipboard.setType("copy");
            clipboard.setSrcPath(srcPath);
            clipboard.setWorkspace(wsName);
            uiExplorer.getAllClipBoard().add(clipboard);
            if (this.isMultiSelect_) {
                this.virtualClipboards_.add(clipboard);
            }
            if (!uiExplorer.getPreference().isJcrEnable()) {
                uiExplorer.getSession().save();
            }
            uiExplorer.updateAjax(event);
        }
        catch (ConstraintViolationException cons) {
            uiExplorer.getSession().refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
    }

    private void processPasteMultiple(String destPath, Event event) throws Exception {
        this.pasteNum_ = 0;
        this.isLastPaste_ = false;
        for (ClipboardCommand clipboard : this.virtualClipboards_) {
            ++this.pasteNum_;
            if (this.pasteNum_ == this.virtualClipboards_.size()) {
                this.isLastPaste_ = true;
                this.processPaste(clipboard, destPath, event);
                break;
            }
            this.processPaste(clipboard, destPath, event);
        }
    }

    private void processPaste(ClipboardCommand currentClipboard, String destPath, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        String srcPath = currentClipboard.getSrcPath();
        String type = currentClipboard.getType();
        String srcWorkspace = currentClipboard.getWorkspace();
        if (srcWorkspace == null) {
            srcWorkspace = uiExplorer.getCurrentWorkspace();
        }
        Session session = uiExplorer.getSession();
        if ("cut".equals(type) && srcPath.equals(destPath)) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-cutting", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        destPath = destPath.endsWith("/") ? destPath + srcPath.substring(srcPath.lastIndexOf("/") + 1) : destPath + srcPath.substring(srcPath.lastIndexOf("/"));
        ActionServiceContainer actionContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        try {
            if ("copy".equals(type)) {
                this.pasteByCopy(session, srcPath, destPath);
                Node selectedNode = (Node)session.getItem(destPath);
                actionContainer.initiateObservation(selectedNode, uiExplorer.getRepositoryName());
            } else if (!srcPath.equals(destPath)) {
                this.pasteByCut(uiExplorer, session, srcPath, destPath, actionContainer, uiExplorer.getRepositoryName());
            }
        }
        catch (ConstraintViolationException ce) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.current-node-not-allow-paste", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.copied-node-in-versioning", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ItemExistsException iee) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-node-same-name", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LoginException e) {
            if ("cut".equals(type)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-login-node", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                uiExplorer.updateAjax(event);
                return;
            }
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cannot-paste-nodetype", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (AccessDeniedException ace) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.access-denied", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (LockException locke) {
            Object[] arg = new Object[]{srcPath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.paste-lock-exception", arg, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
    }

    private void pasteByCopy(Session session, String srcPath, String destPath) throws Exception {
        Workspace workspace = session.getWorkspace();
        workspace.copy(srcPath, destPath);
        Node destNode = (Node)session.getItem(destPath);
        this.removeReferences(destNode);
    }

    private void pasteByCut(UIJCRExplorer uiExplorer, Session session, String srcPath, String destPath, ActionServiceContainer actionContainer, String repository) throws Exception {
        RelationsService relationsService = (RelationsService)uiExplorer.getApplicationComponent(RelationsService.class);
        ArrayList<Node> refList = new ArrayList<Node>();
        boolean isReference = false;
        PropertyIterator references = null;
        Node srcNode = (Node)uiExplorer.getSession().getItem(srcPath);
        try {
            references = srcNode.getReferences();
            isReference = true;
        }
        catch (Exception e) {
            isReference = false;
        }
        if (isReference && references != null && references.getSize() > 0L) {
            while (references.hasNext()) {
                Property pro = references.nextProperty();
                Node refNode = pro.getParent();
                if (!refNode.hasProperty(RELATION_PROP)) continue;
                relationsService.removeRelation(refNode, srcPath, uiExplorer.getRepositoryName());
                refNode.save();
                refList.add(refNode);
            }
        }
        Workspace workspace = session.getWorkspace();
        try {
            workspace.move(srcPath, destPath);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MessageException(new ApplicationMessage("UIPopupMenu.msg.bound-exception", null, 1));
        }
        session.save();
        if (!this.isMultiSelect_ || this.isMultiSelect_ && this.isLastPaste_) {
            Node desNode = (Node)session.getItem(destPath);
            actionContainer.initiateObservation(desNode, repository);
            for (int i = 0; i < refList.size(); ++i) {
                Node addRef = (Node)refList.get(i);
                relationsService.addRelation(addRef, destPath, session.getWorkspace().getName(), uiExplorer.getRepositoryName());
                addRef.save();
            }
            uiExplorer.getAllClipBoard().clear();
            this.virtualClipboards_.clear();
            String currentPath = uiExplorer.getCurrentPath();
            if (srcPath.equals(currentPath) || currentPath.startsWith(srcPath)) {
                uiExplorer.setCurrentPath(srcNode.getParent().getPath());
            }
        }
    }

    private void removeReferences(Node destNode) throws Exception {
        NodeType[] mixinTypes = destNode.getMixinNodeTypes();
        Session session = destNode.getSession();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!mixinTypes[i].getName().equals("exo:categorized") || !destNode.hasProperty("exo:categorized")) continue;
            Node valueNode = null;
            Value valueAdd = session.getValueFactory().createValue(valueNode);
            destNode.setProperty("exo:categorized", new Value[]{valueAdd});
        }
        destNode.save();
    }

    private void processRemoveMultiple(String[] nodePaths, String[] wsNames, Event event) throws Exception {
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processRemove(nodePaths[i], wsNames[i], event);
        }
    }

    private void processRemove(String nodePath, String wsName, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        Node node = null;
        try {
            node = (Node)session.getItem(nodePath);
            String lockToken = LockUtil.getLockToken((Node)node);
            if (lockToken != null) {
                session.addLockToken(lockToken);
            }
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            ((ExtendedNode)node).checkPermission("remove");
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-remove-node", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (uiExplorer.nodeIsLocked(node)) {
            Object[] arg = new Object[]{nodePath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        Node parentNode = node.getParent();
        if (parentNode.isLocked()) {
            String lockToken1 = LockUtil.getLockToken((Node)parentNode);
            session.addLockToken(lockToken1);
        }
        try {
            if (node.isNodeType("rma:record")) {
                this.removeMixins(node);
            }
            ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
            thumbnailService.processRemoveThumbnail(node);
            node.remove();
            parentNode.save();
        }
        catch (VersionException ve) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-verion-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ReferentialIntegrityException ref) {
            uiExplorer.getSession().refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.remove-referentialIntegrityException", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (ConstraintViolationException cons) {
            uiExplorer.getSession().refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (!this.isMultiSelect_) {
            uiExplorer.setSelectNode(parentNode);
        }
    }

    private void processCut(String nodePath, String wsName, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node selectedNode = null;
        try {
            selectedNode = (Node)session.getItem(nodePath);
        }
        catch (ConstraintViolationException cons) {
            uiExplorer.getSession().refresh(false);
            uiExplorer.refreshExplorer();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.constraintviolation-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            ((ExtendedNode)selectedNode).checkPermission("remove");
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-cut-node", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        if (uiExplorer.nodeIsLocked(selectedNode)) {
            Object[] arg = new Object[]{nodePath};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", arg, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        try {
            LinkedList clipboards = uiExplorer.getAllClipBoard();
            for (ClipboardCommand command : clipboards) {
                if (!command.getSrcPath().equals(nodePath)) continue;
                clipboards.remove(command);
                break;
            }
            ClipboardCommand clipboard = new ClipboardCommand();
            clipboard.setType("cut");
            clipboard.setSrcPath(nodePath);
            clipboard.setWorkspace(wsName);
            uiExplorer.getAllClipBoard().add(clipboard);
            if (this.isMultiSelect_) {
                this.virtualClipboards_.add(clipboard);
            } else {
                if (!uiExplorer.getPreference().isJcrEnable()) {
                    session.save();
                }
                uiExplorer.updateAjax(event);
            }
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
    }

    private void processMultipleCut(String[] nodePaths, String[] wsNames, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processCut(nodePaths[i], wsNames[i], event);
        }
        if (!uiExplorer.getPreference().isJcrEnable()) {
            uiExplorer.getSession().save();
        }
        uiExplorer.updateAjax(event);
    }

    public void doDelete(String nodePath, String wsName, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        if (nodePath.indexOf(";") > -1) {
            this.isMultiSelect_ = true;
            this.processRemoveMultiple(nodePath.split(";"), wsName.split(";"), event);
        } else {
            this.isMultiSelect_ = false;
            this.processRemove(nodePath, wsName, event);
        }
        uiExplorer.updateAjax(event);
        if (!uiExplorer.getPreference().isJcrEnable()) {
            uiExplorer.getSession().save();
        }
    }

    private void processMultiLock(String[] nodePaths, String[] wsNames, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processLock(nodePaths[i], wsNames[i], event);
        }
        if (!uiExplorer.getPreference().isJcrEnable()) {
            uiExplorer.getSession().save();
        }
        uiExplorer.updateAjax(event);
    }

    private void processLock(String nodePath, String wsName, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node node = null;
        try {
            node = (Node)session.getItem(nodePath);
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            ((ExtendedNode)node).checkPermission("set_property");
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-lock-node", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        if (!node.isCheckedOut()) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.is-checked-in-lock", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        if (node.canAddMixin("mix:lockable")) {
            node.addMixin("mix:lockable");
            node.save();
        }
        try {
            Lock lock = node.lock(false, false);
            LockUtil.keepLock((Lock)lock);
        }
        catch (LockException le) {
            le.printStackTrace();
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.cant-lock", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
    }

    private void processMultiUnlock(String[] nodePaths, String[] wsNames, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        for (int i = 0; i < nodePaths.length; ++i) {
            this.processUnlock(nodePaths[i], wsNames[i], event);
        }
        if (!uiExplorer.getPreference().isJcrEnable()) {
            uiExplorer.getSession().save();
        }
        uiExplorer.updateAjax(event);
    }

    private void processUnlock(String nodePath, String wsName, Event event) throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        UIApplication uiApp = (UIApplication)uiExplorer.getAncestorOfType(UIApplication.class);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node node = null;
        try {
            node = (Node)session.getItem(nodePath);
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            ((ExtendedNode)node).checkPermission("set_property");
        }
        catch (Exception e) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        try {
            if (node.holdsLock()) {
                String lockToken = LockUtil.getLockToken((Node)node);
                if (lockToken != null) {
                    session.addLockToken(lockToken);
                }
                node.unlock();
            }
        }
        catch (LockException le) {
            Object[] args = new Object[]{node.getName()};
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.can-not-unlock-node", args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
    }

    private void moveNode(String srcPath, String wsName, String destPath, Event event) throws Exception {
        String lockToken;
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getParent();
        Workspace workspace = uiExplorer.getSession().getWorkspace();
        Node selectedNode = uiExplorer.getNodeByPath(srcPath, uiExplorer.getSessionByWorkspace(wsName));
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        if (!selectedNode.isCheckedOut()) {
            uiApp.addMessage(new ApplicationMessage("UIActionBar.msg.node-checkedin", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        if (selectedNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)selectedNode)) != null) {
            uiExplorer.getSession().addLockToken(lockToken);
        }
        destPath = destPath.endsWith("/") ? destPath + srcPath.substring(srcPath.lastIndexOf("/") + 1) : destPath + srcPath.substring(srcPath.lastIndexOf("/"));
        try {
            workspace.move(srcPath, destPath);
        }
        catch (Exception e) {
            Object[] args = new Object[]{srcPath, destPath};
            uiApp.addMessage(new ApplicationMessage("UIWorkingArea.msg.move-problem", args, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
    }

    private void moveMultiNode(String[] srcPaths, String[] wsNames, String destPath, Event event) throws Exception {
        for (int i = 0; i < srcPaths.length; ++i) {
            this.moveNode(srcPaths[i], wsNames[i], destPath, event);
        }
    }

    static /* synthetic */ boolean access$002(UIWorkingArea x0, boolean x1) {
        x0.isMultiSelect_ = x1;
        return x0.isMultiSelect_;
    }

    static /* synthetic */ LinkedList access$100(UIWorkingArea x0) {
        return x0.virtualClipboards_;
    }

    static /* synthetic */ void access$200(UIWorkingArea x0, String[] x1, String[] x2, Event x3) throws Exception {
        x0.multipleCopy(x1, x2, x3);
    }

    static /* synthetic */ void access$300(UIWorkingArea x0, String x1, String x2, Event x3) throws Exception {
        x0.processCopy(x1, x2, x3);
    }

    static /* synthetic */ void access$400(UIWorkingArea x0, String[] x1, String[] x2, Event x3) throws Exception {
        x0.processMultipleCut(x1, x2, x3);
    }

    static /* synthetic */ void access$500(UIWorkingArea x0, String x1, String x2, Event x3) throws Exception {
        x0.processCut(x1, x2, x3);
    }

    static /* synthetic */ void access$600(UIWorkingArea x0, String[] x1, String[] x2, Event x3) throws Exception {
        x0.processMultiLock(x1, x2, x3);
    }

    static /* synthetic */ void access$700(UIWorkingArea x0, String x1, String x2, Event x3) throws Exception {
        x0.processLock(x1, x2, x3);
    }

    static /* synthetic */ void access$800(UIWorkingArea x0, String[] x1, String[] x2, Event x3) throws Exception {
        x0.processMultiUnlock(x1, x2, x3);
    }

    static /* synthetic */ void access$900(UIWorkingArea x0, String x1, String x2, Event x3) throws Exception {
        x0.processUnlock(x1, x2, x3);
    }

    static /* synthetic */ boolean access$000(UIWorkingArea x0) {
        return x0.isMultiSelect_;
    }

    static /* synthetic */ void access$1000(UIWorkingArea x0, String x1, Event x2) throws Exception {
        x0.processPasteMultiple(x1, x2);
    }

    static /* synthetic */ void access$1100(UIWorkingArea x0, ClipboardCommand x1, String x2, Event x3) throws Exception {
        x0.processPaste(x1, x2, x3);
    }

    static /* synthetic */ void access$1200(UIWorkingArea x0, String[] x1, String[] x2, String x3, Event x4) throws Exception {
        x0.moveMultiNode(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$1300(UIWorkingArea x0, String x1, String x2, String x3, Event x4) throws Exception {
        x0.moveNode(x1, x2, x3, x4);
    }
}

