/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertiesManager;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIPropertyTab;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/info/UIPropertyTab.gtmpl", events={@EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIPropertyTab.confirm.remove-property")})
public class UIPropertyTab
extends UIContainer {
    private static String[] PRO_BEAN_FIELD = new String[]{"icon", "name", "multiValue", "value", "action"};
    private static final String PRO_KEY_BINARYTYPE = "binary";
    private static final String PRO_KEY_CANNOTGET = "cannotget";
    private List<String> propertiesName_ = new ArrayList();

    public String[] getBeanFields() {
        return PRO_BEAN_FIELD;
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    private Node getCurrentNode() throws Exception {
        UIPropertiesManager uiManager = (UIPropertiesManager)this.getParent();
        return uiManager.getCurrentNode();
    }

    public PropertyIterator getProperties() throws Exception {
        return this.getCurrentNode().getProperties();
    }

    private List<String> propertiesName() throws Exception {
        if (this.propertiesName_.size() == 0) {
            Node currentNode = this.getCurrentNode();
            NodeType nodetype = currentNode.getPrimaryNodeType();
            ArrayList<NodeType> types = new ArrayList<NodeType>();
            types.add(nodetype);
            NodeType[] mixins = currentNode.getMixinNodeTypes();
            if (mixins != null) {
                types.addAll(Arrays.asList(mixins));
            }
            for (NodeType nodeType : types) {
                for (PropertyDefinition property : nodeType.getPropertyDefinitions()) {
                    this.propertiesName_.add(property.getName());
                }
            }
        }
        return this.propertiesName_;
    }

    public boolean addedByUser(String propertyName) throws Exception {
        return !this.propertiesName().contains(propertyName);
    }

    public boolean isCanbeEdit(Property property) throws Exception {
        return !property.getDefinition().isAutoCreated() && !property.getDefinition().isProtected();
    }

    public String getPropertyValue(Property prop) throws Exception {
        if (prop.getType() == 2) {
            return PRO_KEY_BINARYTYPE;
        }
        boolean flag = true;
        try {
            if (prop.getDefinition() != null && prop.getDefinition().isMultiple()) {
                Value[] values = prop.getValues();
                StringBuilder sB = new StringBuilder();
                for (int i = 0; i < values.length; ++i) {
                    String uuid;
                    Node node;
                    if (prop.getType() == 9 && (node = this.getNodeByUUID(uuid = values[i].getString())) == null) {
                        if (i != 0) continue;
                        flag = false;
                        continue;
                    }
                    if (i > 0 && flag) {
                        sB.append("; ");
                    }
                    sB.append(values[i].getString());
                    flag = true;
                }
                return sB.toString();
            }
            return prop.getString();
        }
        catch (ValueFormatException ve) {
            return PRO_KEY_CANNOTGET;
        }
        catch (Exception e) {
            return PRO_KEY_CANNOTGET;
        }
    }

    public Node getNodeByUUID(String uuid) {
        Node node = null;
        try {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            Session session = uiExplorer.getSession();
            node = session.getNodeByUUID(uuid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return node;
    }

    static /* synthetic */ Node access$000(UIPropertyTab x0) throws Exception {
        return x0.getCurrentNode();
    }
}

