/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.thumbnail;

import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.thumbnail.UIThumbnailForm;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/thumbnail/UIThumbnailForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveThumbnailActionListener.class}, confirm="UIThumbnailForm.msg.confirm-delete", phase=Event.Phase.DECODE)})
public class UIThumbnailForm
extends UIForm
implements UIPopupComponent {
    public static final String THUMBNAIL_FIELD = "mediumSize";
    private boolean thumbnailRemoved_ = false;

    public UIThumbnailForm() throws Exception {
        this.setMultiPart(true);
        UIFormUploadInput uiInput = new UIFormUploadInput(THUMBNAIL_FIELD, THUMBNAIL_FIELD);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    public String getThumbnailImage(Node node) throws Exception {
        return Utils.getThumbnailImage((Node)node, (String)ThumbnailService.MEDIUM_SIZE);
    }

    public Node getSelectedNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public Node getThumbnailNode(Node node) throws Exception {
        ThumbnailService thumbnailService = (ThumbnailService)this.getApplicationComponent(ThumbnailService.class);
        return thumbnailService.getThumbnailNode(node);
    }

    public boolean isRemovedThumbnail() {
        return this.thumbnailRemoved_;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ boolean access$002(UIThumbnailForm x0, boolean x1) {
        x0.thumbnailRemoved_ = x1;
        return x0.thumbnailRemoved_;
    }
}

