/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component;

import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.ecm.jcr.ECMNameValidator;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogFormFields
extends UIForm {
    public Map<String, Map> components = new HashMap();
    public Map<String, String> propertiesName_ = new HashMap();
    public Map<String, String> fieldNames_ = new HashMap();
    private boolean isNotEditNode_ = false;
    private boolean isNTFile_ = false;
    private boolean isResetMultiField_ = false;
    private boolean isOnchange_ = false;
    protected boolean isUpdateSelect_ = false;
    private boolean isResetForm_ = false;
    private String workspaceName_ = null;
    private String storedPath_ = null;
    protected String repositoryName_ = null;
    private String nodePath_;
    private String childPath_;
    private List<String> prevScriptInterceptor_ = new ArrayList();
    private List<String> postScriptInterceptor_ = new ArrayList();
    private final String SEPARATOR = "=";
    private final String JCR_PATH = "jcrPath=";
    private final String EDITABLE = "editable=";
    private final String ONCHANGE = "onchange=";
    private final String OPTIONS = "options=";
    private final String TYPE = "type=";
    private final String VISIBLE = "visible=";
    private final String NODETYPE = "nodetype=";
    private final String MIXINTYPE = "mixintype=";
    private final String VALIDATE = "validate=";
    private final String SELECTOR_ACTION = "selectorAction=";
    private final String SELECTOR_CLASS = "selectorClass=";
    private final String SELECTOR_ICON = "selectorIcon=";
    private final String SELECTOR_PARAMS = "selectorParams=";
    private final String WORKSPACE_FIELD = "workspaceField=";
    private final String SCRIPT = "script=";
    private final String SCRIPT_PARAMS = "scriptParams=";
    private final String MULTI_VALUES = "multiValues=";
    private final String REPOSITORY = "repository";
    private final String DEFAULT_VALUES = "defaultValues=";
    public static final String[] ACTIONS = new String[]{"Save", "Cancel"};
    protected Map<String, Object> properties = new HashMap();

    public Node getNode() throws Exception {
        if (this.nodePath_ == null) {
            return null;
        }
        return (Node)this.getSesssion().getItem(this.nodePath_);
    }

    public void setNodePath(String nodePath) {
        this.nodePath_ = nodePath;
    }

    public Session getSesssion() throws Exception {
        return SessionProviderFactory.createSessionProvider().getSession(this.workspaceName_, this.getRepository());
    }

    private ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(this.repositoryName_);
    }

    public void setChildPath(String childPath) {
        this.childPath_ = childPath;
    }

    public Node getChildNode() throws Exception {
        if (this.childPath_ == null) {
            return null;
        }
        return (Node)this.getSesssion().getItem(this.childPath_);
    }

    public void setInputProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getInputProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getInputProperties() {
        return this.properties;
    }

    public void resetProperties() {
        this.properties.clear();
    }

    public void setIsResetMultiField(boolean isResetMultiField) {
        this.isResetMultiField_ = isResetMultiField;
    }

    public void setIsResetForm(boolean isResetForm) {
        this.isResetForm_ = isResetForm;
    }

    public boolean isResetForm() {
        return this.isResetForm_;
    }

    public void setIsUpdateSelect(boolean isUpdateSelect) {
        this.isUpdateSelect_ = isUpdateSelect;
    }

    public void setIsOnchange(boolean isOnchange) {
        this.isOnchange_ = isOnchange;
    }

    public void setIsNotEditNode(boolean isNotEditNode) {
        this.isNotEditNode_ = isNotEditNode;
    }

    public void setIsNTFile(boolean isNTFile) {
        this.isNTFile_ = isNTFile;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName_ = workspace;
    }

    public void setStoredPath(String storedPath) {
        this.storedPath_ = storedPath;
    }

    public String getPropertyName(String jcrPath) {
        return jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    public void resetScriptInterceptor() {
        this.prevScriptInterceptor_.clear();
        this.postScriptInterceptor_.clear();
    }

    private String getPropertyValue(String jcrPath) throws Exception {
        if (jcrPath.equals("/node") && this.getNode() != null) {
            return this.getNode().getName();
        }
        if (this.getChildNode().hasProperty(this.getPropertyName(jcrPath))) {
            int valueType = this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getType();
            switch (valueType) {
                case 1: {
                    return this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getString();
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return Long.toString(this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getLong());
                }
                case 4: {
                    return Double.toString(this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getDouble());
                }
                case 5: {
                    return this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getDate().getTime().toString();
                }
                case 6: {
                    return Boolean.toString(this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getBoolean());
                }
                case 7: {
                    return this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getName();
                }
                case 0: 
                case 8: 
                case 9: {
                    return "";
                }
            }
        }
        return "";
    }

    public void addActionField(String name, String[] arguments) throws Exception {
        this.addActionField(name, null, arguments);
    }

    public void addActionField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String editable = (String)parsedArguments.get("editable=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String selectorAction = (String)parsedArguments.get("selectorAction=");
        String selectorClass = (String)parsedArguments.get("selectorClass=");
        String workspaceField = (String)parsedArguments.get("workspaceField=");
        String selectorIcon = (String)parsedArguments.get("selectorIcon=");
        String multiValues = (String)parsedArguments.get("multiValues=");
        String validateType = (String)parsedArguments.get("validate=");
        String params = (String)parsedArguments.get("selectorParams=");
        String[] selectorParams = null;
        if (params != null) {
            selectorParams = params.split(",");
        }
        if (selectorClass != null) {
            HashMap<String, String> fieldPropertiesMap = new HashMap<String, String>();
            fieldPropertiesMap.put("selectorClass", selectorClass);
            fieldPropertiesMap.put("returnField", name);
            fieldPropertiesMap.put("selectorIcon", selectorIcon);
            fieldPropertiesMap.put("workspaceField", workspaceField);
            if (params != null) {
                fieldPropertiesMap.put("selectorParams", params);
            }
            this.components.put(name, fieldPropertiesMap);
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if ("true".equals(multiValues)) {
            this.renderMultiValuesInput(UIFormStringInput.class, name, label);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            uiInput = new UIFormStringInput(name, name, defaultValue);
            if (validateType != null) {
                this.addValidators((UIFormInputBase)uiInput, validateType);
            }
            if (label != null) {
                uiInput.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiInput);
        }
        if ("false".equals(editable)) {
            uiInput.setEditable(false);
        } else {
            uiInput.setEditable(true);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null) {
            if (jcrPath.equals("/node") && (editable.equals("false") || editable.equals("if-null"))) {
                uiInput.setValue((Object)this.getNode().getName());
                uiInput.setEditable(false);
            } else if (this.getNode().hasProperty(this.getPropertyName(jcrPath)) && !this.isUpdateSelect_) {
                uiInput.setValue((Object)this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
            }
        }
        if (this.isNotEditNode_) {
            if (this.getChildNode() != null) {
                uiInput.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiInput.setValue((Object)this.getNode().getName());
            } else {
                uiInput.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addTextField(String name, String[] arguments) throws Exception {
        this.addTextField(name, null, arguments);
    }

    public void addTextField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String type = (String)parsedArguments.get("type=");
        String editable = (String)parsedArguments.get("editable=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String mixintype = (String)parsedArguments.get("mixintype=");
        String multiValues = (String)parsedArguments.get("multiValues=");
        String validateType = (String)parsedArguments.get("validate=");
        String nodetype = (String)parsedArguments.get("nodetype=");
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        if (mixintype != null) {
            inputProperty.setMixintype(mixintype);
        }
        if (jcrPath.equals("/node") && nodetype != null) {
            inputProperty.setNodetype(nodetype);
        }
        this.properties.put(name, inputProperty);
        this.propertiesName_.put(name, propertyName);
        this.fieldNames_.put(propertyName, name);
        if ("true".equalsIgnoreCase(multiValues)) {
            UIFormMultiValueInputSet uiMulti;
            if (this.getNode() == null && this.getChildNode() == null) {
                uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
                if (uiMulti == null) {
                    uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                    uiMulti.setId(name);
                    uiMulti.setName(name);
                    uiMulti.setType(UIFormStringInput.class);
                    uiMulti.setValue(new ArrayList());
                    this.addUIFormInput((UIFormInput)uiMulti);
                }
            } else {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormStringInput.class);
                this.addUIFormInput((UIFormInput)uiMulti);
            }
            ArrayList<String> valueList = new ArrayList<String>();
            if (this.getChildNode() != null && this.getChildNode().hasProperty(this.getPropertyName(jcrPath))) {
                Value[] values;
                for (Value value : values = this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getValues()) {
                    valueList.add(value.getString());
                }
                uiMulti.setValue(valueList);
            }
            if (this.getNode() != null) {
                String propertyPath = jcrPath.substring("/node/".length());
                if (this.getNode().hasProperty(propertyPath)) {
                    Value[] values;
                    for (Value vl : values = this.getNode().getProperty(propertyPath).getValues()) {
                        if (vl == null) continue;
                        valueList.add(vl.getString());
                    }
                }
                uiMulti.setValue(valueList);
            }
            if (this.isResetMultiField_) {
                uiMulti.setValue(new ArrayList());
            }
            this.renderField(name);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            uiInput = new UIFormStringInput(name, name, defaultValue);
            if (validateType != null) {
                this.addValidators((UIFormInputBase)uiInput, validateType);
            }
            if (label != null && label.length() != 0) {
                uiInput.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiInput);
        }
        if (uiInput.getValue() == null) {
            uiInput.setValue((Object)defaultValue);
        }
        if ("password".equals(type)) {
            uiInput.setType((short)1);
        }
        if ("false".equals(editable)) {
            uiInput.setEditable(false);
        } else {
            uiInput.setEditable(true);
        }
        if (this.getNode() != null) {
            if (jcrPath.equals("/node") && (editable.equals("false") || editable.equals("if-null"))) {
                Node parentNode = this.getNode().getParent();
                if (parentNode != null && parentNode.getName().equals("languages")) {
                    uiInput.setValue((Object)this.getNode().getParent().getParent().getName());
                } else {
                    String nameValue = this.getNode().getPath().substring(this.getNode().getPath().lastIndexOf("/") + 1);
                    uiInput.setValue((Object)nameValue);
                }
                uiInput.setEditable(false);
            } else if (this.getNode().hasProperty(propertyName)) {
                uiInput.setValue((Object)this.getNode().getProperty(propertyName).getValue().getString());
            }
        }
        if (this.isNotEditNode_) {
            if (this.getChildNode() != null) {
                uiInput.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiInput.setValue((Object)this.getNode().getName());
            } else {
                uiInput.setValue((Object)defaultValue);
            }
        }
        this.renderField(name);
    }

    public void addTextAreaField(String name, String[] arguments) throws Exception {
        this.addTextAreaField(name, null, arguments);
    }

    public void addTextAreaField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String editable = (String)parsedArguments.get("editable=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String selectorAction = (String)parsedArguments.get("selectorAction=");
        String selectorClass = (String)parsedArguments.get("selectorClass=");
        String multiValues = (String)parsedArguments.get("multiValues=");
        String validateType = (String)parsedArguments.get("validate=");
        if (selectorClass != null) {
            HashMap<String, String> fieldPropertiesMap = new HashMap<String, String>();
            fieldPropertiesMap.put("selectorClass", selectorClass);
            fieldPropertiesMap.put("returnField", name);
            this.components.put(name, fieldPropertiesMap);
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if (multiValues != null && multiValues.equals("true")) {
            this.renderMultiValuesInput(UIFormDateTimeInput.class, name, label);
            return;
        }
        UIFormTextAreaInput uiTextArea = (UIFormTextAreaInput)this.findComponentById(name);
        if (uiTextArea == null) {
            uiTextArea = new UIFormTextAreaInput(name, name, defaultValue);
            if (validateType != null) {
                this.addValidators((UIFormInputBase)uiTextArea, validateType);
            }
            if (label != null) {
                uiTextArea.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiTextArea);
        }
        if (uiTextArea.getValue() == null) {
            uiTextArea.setValue((Object)defaultValue);
        }
        if ("false".equals(editable)) {
            uiTextArea.setEditable(false);
        } else {
            uiTextArea.setEditable(true);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null) {
            Node jcrContentNode;
            String value = "";
            if (this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
                value = this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString();
            } else if (this.getNode().isNodeType("nt:file") && (jcrContentNode = this.getNode().getNode("jcr:content")).hasProperty(this.getPropertyName(jcrPath))) {
                if (jcrContentNode.getProperty(this.getPropertyName(jcrPath)).getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value v : values = jcrContentNode.getProperty(this.getPropertyName(jcrPath)).getValues()) {
                        value = value + v.getString();
                    }
                } else {
                    value = jcrContentNode.getProperty(this.getPropertyName(jcrPath)).getValue().getString();
                }
            }
            uiTextArea.setValue((Object)value);
        }
        if (this.isNotEditNode_) {
            if (this.getChildNode() != null) {
                uiTextArea.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiTextArea.setValue((Object)this.getNode().getName());
            } else {
                uiTextArea.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addWYSIWYGField(String name, String[] arguments) throws Exception {
        this.addWYSIWYGField(name, null, arguments);
    }

    public void addWYSIWYGField(String name, String label, String[] arguments) throws Exception {
        Node jcrContentNode;
        HashMap parsedArguments = this.parseArguments(arguments);
        String options = (String)parsedArguments.get("options=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String multiValues = (String)parsedArguments.get("multiValues=");
        String validateType = (String)parsedArguments.get("validate=");
        boolean isBasic = false;
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if ("true".equalsIgnoreCase(multiValues)) {
            this.renderMultiValuesInput(UIFormWYSIWYGInput.class, name, label);
            return;
        }
        isBasic = "basic".equals(options);
        UIFormWYSIWYGInput wysiwyg = (UIFormWYSIWYGInput)this.findComponentById(name);
        if (wysiwyg == null) {
            wysiwyg = new UIFormWYSIWYGInput(name, name, defaultValue, isBasic);
            if (validateType != null) {
                this.addValidators((UIFormInputBase)wysiwyg, validateType);
            }
            this.addUIFormInput((UIFormInput)wysiwyg);
        }
        if (wysiwyg.getValue() == null) {
            wysiwyg.setValue((Object)defaultValue);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null && (this.getNode().isNodeType("nt:file") || this.isNTFile_)) {
            jcrContentNode = this.getNode().getNode("jcr:content");
            wysiwyg.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
        } else if (this.getNode() != null && this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
            wysiwyg.setValue((Object)this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
        }
        if (this.isNotEditNode_) {
            if (this.getNode() != null && this.getNode().hasNode("jcr:content") && this.getChildNode() != null) {
                jcrContentNode = this.getNode().getNode("jcr:content");
                wysiwyg.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (this.getChildNode() != null) {
                wysiwyg.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                wysiwyg.setValue((Object)this.getNode().getName());
            } else {
                wysiwyg.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addSelectBoxField(String name, String[] arguments) throws Exception {
        this.addSelectBoxField(name, null, arguments);
    }

    public void addSelectBoxField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String multiValues = (String)parsedArguments.get("multiValues=");
        if ("true".equals(multiValues)) {
            this.renderMultiValuesInput(UIFormSelectBox.class, name, label);
            return;
        }
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String editable = (String)parsedArguments.get("editable=");
        String onchange = (String)parsedArguments.get("onchange=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String options = (String)parsedArguments.get("options=");
        String script = (String)parsedArguments.get("script=");
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox == null || this.isResetForm_) {
            uiSelectBox = new UIFormSelectBox(name, name, null);
            this.addUIFormInput((UIFormInput)uiSelectBox);
            if (script != null) {
                try {
                    String[] scriptParams = ((String)parsedArguments.get("scriptParams=")).split(",");
                    if ("repository".equals(scriptParams[0])) {
                        scriptParams[0] = this.repositoryName_;
                    }
                    this.executeScript(script, (Object)uiSelectBox, scriptParams);
                }
                catch (Exception e) {
                    uiSelectBox.setOptions(optionsList);
                }
            } else if (options != null && options.length() > 0) {
                String[] array = options.split(",");
                for (int i = 0; i < array.length; ++i) {
                    optionsList.add(new SelectItemOption(array[i].trim(), (Object)array[i].trim()));
                }
                uiSelectBox.setOptions(optionsList);
            } else {
                uiSelectBox.setOptions(optionsList);
            }
            if (defaultValue != null) {
                uiSelectBox.setValue(defaultValue);
            }
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        String[] arrNodes = jcrPath.split("/");
        Node childNode = null;
        if (this.getNode() != null && arrNodes.length == 4) {
            childNode = this.getNode().getNode(arrNodes[2]);
        }
        if (childNode != null) {
            uiSelectBox.setValue(childNode.getProperty(this.getPropertyName(jcrPath)).getValue().getString());
        } else if (this.getNode() != null && this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
            if (this.getNode().getProperty(this.getPropertyName(jcrPath)).getDefinition().isMultiple()) {
                uiSelectBox.setValue(this.getNode().getProperty(this.getPropertyName(jcrPath)).getValues().toString());
            } else if ("true".equals(onchange) && this.isOnchange_) {
                uiSelectBox.setValue((String)uiSelectBox.getValue());
            } else {
                uiSelectBox.setValue(this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
            }
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if ("false".equalsIgnoreCase(editable)) {
            uiSelectBox.setDisabled(false);
        } else {
            uiSelectBox.setEditable(true);
        }
        this.addUIFormInput((UIFormInput)uiSelectBox);
        if (this.isNotEditNode_ && this.getChildNode() != null) {
            uiSelectBox.setValue(this.getPropertyValue(jcrPath));
        }
        if ("true".equalsIgnoreCase(onchange)) {
            uiSelectBox.setOnChange("Onchange");
        }
        this.renderField(name);
    }

    public String getSelectBoxFieldValue(String name) {
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox != null) {
            return (String)uiSelectBox.getValue();
        }
        return null;
    }

    public void addUploadField(String name, String[] arguments) throws Exception {
        this.addUploadField(name, null, arguments);
    }

    public void addUploadField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String multiValues = (String)parsedArguments.get("multiValues=");
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        this.setMultiPart(true);
        if ("true".equalsIgnoreCase(multiValues)) {
            this.renderMultiValuesInput(UIFormUploadInput.class, name, label);
            return;
        }
        UIFormUploadInput uiInputUpload = (UIFormUploadInput)this.findComponentById(name);
        if (uiInputUpload == null) {
            uiInputUpload = new UIFormUploadInput(name, name);
            if (label != null) {
                uiInputUpload.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiInputUpload);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        this.renderField(name);
    }

    public void addMixinField(String name, String[] arguments) throws Exception {
        this.addMixinField(name, null, arguments);
    }

    public void addMixinField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String nodetype = (String)parsedArguments.get("nodetype=");
        String mixintype = (String)parsedArguments.get("mixintype=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String editable = (String)parsedArguments.get("editable=");
        String visible = (String)parsedArguments.get("visible=");
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (nodetype != null || mixintype != null) {
            inputProperty.setType(1);
            if (nodetype != null) {
                inputProperty.setNodetype(nodetype);
            }
            if (mixintype != null) {
                inputProperty.setMixintype(mixintype);
            }
        }
        this.setInputProperty(name, (Object)inputProperty);
        if (this.getNode() != null && "if-not-null".equals(visible)) {
            UIFormStringInput uiMixin = (UIFormStringInput)this.findComponentById(name);
            if (uiMixin == null) {
                uiMixin = new UIFormStringInput(name, name, defaultValue);
                if (label != null) {
                    uiMixin.setLabel(label);
                }
                this.addUIFormInput((UIFormInput)uiMixin);
            }
            uiMixin.setValue((Object)this.getNode().getName());
            uiMixin.setEditable(false);
            this.renderField(name);
        }
    }

    public void addCalendarField(String name, String[] arguments) throws Exception {
        this.addCalendarField(name, null, arguments);
    }

    public void addCalendarField(String name, String label, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String options = (String)parsedArguments.get("options=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String multiValues = (String)parsedArguments.get("multiValues=");
        String visible = (String)parsedArguments.get("visible=");
        String validateType = (String)parsedArguments.get("validate=");
        String[] arrDate = null;
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        Date date = new Date();
        if (options == null) {
            formatter = new SimpleDateFormat("MM/dd/yyyy");
        }
        if (defaultValue != null && defaultValue.length() > 0) {
            try {
                date = formatter.parse(defaultValue);
                if (defaultValue.indexOf("/") > -1) {
                    arrDate = defaultValue.split("/");
                }
                String[] arrDf = formatter.format(date).split("/");
                if (Integer.parseInt(arrDate[0]) != Integer.parseInt(arrDf[0])) {
                    date = new Date();
                }
            }
            catch (Exception e) {
                date = new Date();
            }
        }
        if (multiValues != null && multiValues.equals("true")) {
            this.renderMultiValuesInput(UIFormDateTimeInput.class, name, label);
            return;
        }
        UIFormDateTimeInput uiDateTime = (UIFormDateTimeInput)this.findComponentById(name);
        if (uiDateTime == null) {
            uiDateTime = options != null && options.equals("displaytime") ? new UIFormDateTimeInput(name, name, date) : new UIFormDateTimeInput(name, name, date, false);
            if (label != null) {
                uiDateTime.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiDateTime);
        }
        if (options != null && options.equals("displaytime")) {
            uiDateTime.setDisplayTime(true);
        } else {
            uiDateTime.setDisplayTime(false);
        }
        if (validateType != null) {
            this.addValidators((UIFormInputBase)uiDateTime, validateType);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null && this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
            uiDateTime.setCalendar(this.getNode().getProperty(this.getPropertyName(jcrPath)).getDate());
        }
        if (this.isNotEditNode_) {
            if (this.getChildNode() != null) {
                String propertyName = jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
                if (this.getChildNode().hasProperty(propertyName)) {
                    if (this.getChildNode().getProperty(propertyName).getDefinition().isMultiple()) {
                        Value[] values;
                        for (Value value : values = this.getChildNode().getProperty(propertyName).getValues()) {
                            uiDateTime.setCalendar(value.getDate());
                        }
                    } else {
                        uiDateTime.setCalendar(this.getChildNode().getProperty(propertyName).getValue().getDate());
                    }
                }
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiDateTime.setCalendar(this.getNode().getProperty(this.getPropertyName(jcrPath)).getDate());
            } else {
                uiDateTime.setCalendar((Calendar)new GregorianCalendar());
            }
        }
        if (!"false".equalsIgnoreCase(visible)) {
            this.renderField(name);
        }
    }

    public void addHiddenField(String name, String[] arguments) throws Exception {
        HashMap parsedArguments = this.parseArguments(arguments);
        String jcrPath = (String)parsedArguments.get("jcrPath=");
        String nodetype = (String)parsedArguments.get("nodetype=");
        String mixintype = (String)parsedArguments.get("mixintype=");
        String defaultValue = (String)parsedArguments.get("defaultValues=");
        String editable = (String)parsedArguments.get("editable=");
        String visible = (String)parsedArguments.get("visible=");
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (defaultValue != null && defaultValue.length() > 0) {
            inputProperty.setValue((Object)defaultValue);
        }
        if (nodetype != null || mixintype != null) {
            inputProperty.setType(1);
            if (nodetype != null) {
                inputProperty.setNodetype(nodetype);
            }
            if (mixintype != null) {
                inputProperty.setMixintype(mixintype);
            }
        }
        this.setInputProperty(name, (Object)inputProperty);
    }

    public void addInterceptor(String scriptPath, String type) {
        if (scriptPath.length() > 0 && type.length() > 0) {
            if (type.equals("prev")) {
                this.prevScriptInterceptor_.add(scriptPath + ";" + type);
            } else if (type.equals("post")) {
                this.postScriptInterceptor_.add(scriptPath + ";" + type);
            }
        }
    }

    private HashMap<String, String> parseArguments(String[] arguments) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String argument : arguments) {
            String value = null;
            if (argument.indexOf("=") <= 0) {
                value = argument;
                map.put("defaultValues=", value);
                continue;
            }
            value = argument.substring(argument.indexOf("=") + 1);
            if (argument.startsWith("jcrPath=")) {
                map.put("jcrPath=", value);
                continue;
            }
            if (argument.startsWith("editable=")) {
                map.put("editable=", value);
                continue;
            }
            if (argument.startsWith("selectorAction=")) {
                map.put("selectorAction=", value);
                continue;
            }
            if (argument.startsWith("selectorClass=")) {
                map.put("selectorClass=", value);
                continue;
            }
            if (argument.startsWith("multiValues=")) {
                map.put("multiValues=", value);
                continue;
            }
            if (argument.startsWith("selectorIcon=")) {
                map.put("selectorIcon=", value);
                continue;
            }
            if (argument.startsWith("selectorParams=")) {
                map.put("selectorParams=", value);
                continue;
            }
            if (argument.startsWith("workspaceField=")) {
                map.put("workspaceField=", value);
                continue;
            }
            if (argument.startsWith("validate=")) {
                map.put("validate=", value);
                continue;
            }
            if (argument.startsWith("defaultValues=")) {
                map.put("defaultValues=", value);
                continue;
            }
            if (argument.startsWith("options=")) {
                map.put("options=", value);
                continue;
            }
            if (argument.startsWith("script=")) {
                map.put("script=", value);
                continue;
            }
            if (argument.startsWith("scriptParams=")) {
                map.put("scriptParams=", value);
                continue;
            }
            if (argument.startsWith("visible=")) {
                map.put("visible=", value);
                continue;
            }
            if (argument.startsWith("type=")) {
                map.put("type=", value);
                continue;
            }
            if (argument.startsWith("onchange=")) {
                map.put("onchange=", value);
                continue;
            }
            if (argument.startsWith("mixintype=")) {
                map.put("mixintype=", value);
                continue;
            }
            map.put("defaultValues=", argument);
        }
        return map;
    }

    private void addValidators(UIFormInputBase uiInput, String validators) throws Exception {
        String[] validatorList = null;
        validatorList = validators.indexOf(44) > -1 ? validators.split(",") : new String[]{validators};
        for (String validator : validatorList) {
            uiInput.addValidator(this.getValidator(validator.trim()), new Object[0]);
        }
    }

    private Class getValidator(String validatorType) throws ClassNotFoundException {
        if (validatorType.equals("name")) {
            return ECMNameValidator.class;
        }
        if (validatorType.equals("email")) {
            return EmailAddressValidator.class;
        }
        if (validatorType.equals("number")) {
            return NumberFormatValidator.class;
        }
        if (validatorType.equals("empty")) {
            return MandatoryValidator.class;
        }
        if (validatorType.equals("datetime")) {
            return DateTimeValidator.class;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(validatorType);
    }

    private void renderMultiValuesInput(Class type, String name, String label) throws Exception {
        UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiMulti.setId(name);
        uiMulti.setName(name);
        uiMulti.setType(type);
        this.addUIFormInput((UIFormInput)uiMulti);
        if (label != null) {
            uiMulti.setLabel(label);
        }
        this.renderField(name);
    }

    private void executeScript(String script, Object o, String[] params) throws Exception {
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        try {
            CmsScript dialogScript = scriptService.getScript(script, this.repositoryName_);
            if (params != null) {
                if (params.equals("repository")) {
                    params = new String[]{this.repositoryName_};
                }
                dialogScript.setParams(params);
            }
            dialogScript.execute(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Writer w = context.getWriter();
        uiInput.processRender(context);
        if (this.components.get(name) != null) {
            Map fieldPropertiesMap = (Map)this.components.get(name);
            String fieldName = (String)fieldPropertiesMap.get("returnField");
            String iconClass = "Add16x16Icon";
            if (fieldPropertiesMap.get("selectorIcon") != null) {
                iconClass = (String)fieldPropertiesMap.get("selectorIcon");
            }
            if (name.equals(fieldName)) {
                w.write("<a style=\"cursor:pointer;\" onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + this.getId() + "','ShowComponent','&objectId=" + fieldName + "' )\"><img class='ActionIcon " + iconClass + "' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" /></a>");
            }
        }
    }

    public Node storeValue(Event event) throws Exception {
        return null;
    }

    public void onchange(Event event) throws Exception {
    }

    static /* synthetic */ String access$000(DialogFormFields x0) {
        return x0.storedPath_;
    }

    static /* synthetic */ String access$100(DialogFormFields x0) {
        return x0.workspaceName_;
    }

    static /* synthetic */ List access$200(DialogFormFields x0) {
        return x0.prevScriptInterceptor_;
    }

    static /* synthetic */ void access$300(DialogFormFields x0, String x1, Object x2, String[] x3) throws Exception {
        x0.executeScript(x1, x2, x3);
    }

    static /* synthetic */ List access$400(DialogFormFields x0) {
        return x0.postScriptInterceptor_;
    }

    static /* synthetic */ boolean access$502(DialogFormFields x0, boolean x1) {
        x0.isOnchange_ = x1;
        return x0.isOnchange_;
    }
}

