/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIPopupAction;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentHelp;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigTabPane;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIBrowseContentPortlet
extends UIPortletApplication {
    private boolean isViewModing_ = true;

    public UIBrowseContentPortlet() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String minWidth = portletPref.getValue(Utils.MIN_WIDTH, "");
        if (minWidth != null && minWidth.length() > 0) {
            this.setMinWidth(Integer.parseInt(minWidth));
        }
        this.addChild(UIBrowseContentHelp.class, null, null);
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        popup.setId("UICBPopupAction");
        ((UIPopupWindow)popup.getChild(UIPopupWindow.class)).setId("UICBPopupWindow");
        UIBrowseContainer uiBrowseContainer = (UIBrowseContainer)this.addChild(UIBrowseContainer.class, null, null);
        this.addChild(UIConfigTabPane.class, null, null);
        try {
            uiBrowseContainer.loadPortletConfig(this.getPortletPreferences());
        }
        catch (Throwable e) {
            this.setPorletMode(PortletMode.HELP);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        context.getJavascriptManager().importJavascript("eXo.ecm.ECMUtils", "/ecm/javascript/");
        context.getJavascriptManager().addJavascript((CharSequence)"eXo.ecm.ECMUtils.init('UIBrowseContentPortlet') ;");
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        UIConfigTabPane uiTabPane = (UIConfigTabPane)this.getChild(UIConfigTabPane.class);
        UIBrowseContainer uiContainer = (UIBrowseContainer)this.getChild(UIBrowseContainer.class);
        UIBrowseContentHelp uiBCHelp = (UIBrowseContentHelp)this.getChild(UIBrowseContentHelp.class);
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            uiTabPane.setRendered(false);
            uiBCHelp.setRendered(false);
            uiContainer.setRendered(true);
            if (!this.isViewModing_) {
                uiContainer.refreshContent();
            }
            this.isViewModing_ = true;
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            if (!uiTabPane.isNewConfig()) {
                uiTabPane.getCurrentConfig();
            }
            uiTabPane.setRendered(true);
            uiBCHelp.setRendered(false);
            uiContainer.setRendered(false);
            this.isViewModing_ = false;
        } else if (portletReqContext.getApplicationMode() == PortletMode.HELP) {
            uiTabPane.setRendered(false);
            uiBCHelp.setRendered(true);
            uiContainer.setRendered(false);
            this.isViewModing_ = false;
        }
        try {
            super.processRender(app, context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void reload() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        WebuiApplication app = (WebuiApplication)context.getApplication();
        this.processRender(app, context);
    }

    protected void setPorletMode(PortletMode mode) throws PortletModeException {
        PortletRequestContext portletReqContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        portletReqContext.setApplicationMode(mode);
    }

    protected boolean isExitsRepo(String repoName) {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        try {
            rService.getRepository(repoName);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest prequest = pcontext.getRequest();
        PortletPreferences portletPref = prequest.getPreferences();
        return portletPref;
    }

    public String getPreferenceRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }
}

