/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIMultiLanguageForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SetDefaultActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIMultiLanguageForm
extends UIForm {
    public UIMultiLanguageForm() throws Exception {
        ArrayList languages = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("languages", "languages", languages));
    }

    public void updateSelect(Node currentNode) throws Exception {
        ArrayList<SelectItemOption> languages = new ArrayList<SelectItemOption>();
        String defaultLang = currentNode.getProperty("exo:language").getString();
        languages.add(new SelectItemOption(defaultLang + "(default)", (Object)defaultLang));
        if (currentNode.hasNode("languages")) {
            Node languageNode = currentNode.getNode("languages");
            NodeIterator iter = languageNode.getNodes();
            while (iter.hasNext()) {
                Node lang = iter.nextNode();
                if (lang.getName().equals(defaultLang)) continue;
                languages.add(new SelectItemOption(lang.getName(), (Object)lang.getName()));
            }
        }
        this.getUIFormSelectBox("languages").setOptions(languages);
        this.getUIFormSelectBox("languages").setValue(defaultLang);
    }
}

