/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.upload;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIExternalMetadataForm;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadContainer;
import org.exoplatform.ecm.webui.component.explorer.upload.UIUploadManager;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class})})
public class UIExternalMetadataForm
extends UIForm {
    public void renderExternalList() throws Exception {
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        for (NodeType nodeType : metadataService.getAllMetadatasNodeType(repository)) {
            UIFormCheckBoxInput uiCheckBox = new UIFormCheckBoxInput(nodeType.getName(), nodeType.getName(), (Object)"");
            if (!this.isExternalUse(nodeType)) continue;
            if (this.hasExternalMetadata(nodeType.getName())) {
                uiCheckBox.setChecked(true);
                uiCheckBox.setEnable(false);
            } else {
                uiCheckBox.setChecked(false);
                uiCheckBox.setEnable(true);
            }
            this.addUIFormInput((UIFormInput)uiCheckBox);
        }
    }

    private boolean isExternalUse(NodeType nodeType) throws Exception {
        PropertyDefinition def = ((ExtendedNodeType)nodeType).getPropertyDefinitions("exo:internalUse").getAnyDefinition();
        return !def.getDefaultValues()[0].getBoolean();
    }

    private boolean hasExternalMetadata(String name) throws Exception {
        UIUploadManager uiUploadManager = (UIUploadManager)this.getAncestorOfType(UIUploadManager.class);
        UIUploadContainer uiUploadContainer = (UIUploadContainer)uiUploadManager.getChild(UIUploadContainer.class);
        Node uploaded = uiUploadContainer.getUploadedNode();
        for (NodeType mixin : uploaded.getMixinNodeTypes()) {
            if (!mixin.getName().equals(name)) continue;
            return true;
        }
        if (uploaded.hasNode("jcr:content")) {
            for (NodeType mixin : uploaded.getNode("jcr:content").getMixinNodeTypes()) {
                if (!mixin.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getLabel(ResourceBundle res, String id) {
        try {
            return res.getString("UIExternalMetadataForm.label." + id);
        }
        catch (MissingResourceException ex) {
            return id;
        }
    }
}

