/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.jcr.ECMViewComponent;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.versions.UINodeInfo;
import org.exoplatform.ecm.webui.component.explorer.versions.UINodeProperty;
import org.exoplatform.ecm.webui.component.explorer.versions.UIViewVersion;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(type=UIViewVersion.class, template="system:/groovy/webui/core/UITabPane.gtmpl", events={@EventConfig(listeners={ChangeLanguageActionListener.class}), @EventConfig(listeners={ChangeNodeActionListener.class}), @EventConfig(listeners={DownloadActionListener.class})})
public class UIViewVersion
extends UIContainer
implements ECMViewComponent {
    private Node node_;
    protected Node originalNode_;
    private String language_;

    public UIViewVersion() throws Exception {
        this.addChild(UINodeInfo.class, null, null);
        ((UINodeProperty)this.addChild(UINodeProperty.class, null, null)).setRendered(false);
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            Node node;
            this.originalNode_ = node = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
            String nodeType = node.getPrimaryNodeType().getName();
            if (this.isNodeTypeSupported(node)) {
                return templateService.getTemplatePathByUser(false, nodeType, userName, this.getRepository());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public boolean isNodeTypeSupported(Node node) {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String nodeTypeName = node.getPrimaryNodeType().getName();
            return templateService.isManagedNodeType(nodeTypeName, this.getRepository());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Node getNode() throws RepositoryException {
        return this.node_;
    }

    public Node getOriginalNode() throws Exception {
        return this.originalNode_;
    }

    public void setNode(Node node) {
        this.node_ = node;
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String[] workspaces;
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ManageableRepository manageRepo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository);
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return SessionsUtils.getSystemProvider().getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public List<Node> getRelations() throws Exception {
        ArrayList<Node> relations = new ArrayList<Node>();
        if (this.node_.hasProperty("exo:relation")) {
            Value[] vals = this.node_.getProperty("exo:relation").getValues();
            for (int i = 0; i < vals.length; ++i) {
                String uuid = vals[i].getString();
                Node node = this.getNodeByUUID(uuid);
                relations.add(node);
            }
        }
        return relations;
    }

    public List<Node> getAttachments() throws Exception {
        ArrayList<Node> attachments = new ArrayList<Node>();
        NodeIterator childrenIterator = this.node_.getNodes();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        while (childrenIterator.hasNext()) {
            Node childNode = childrenIterator.nextNode();
            String nodeType = childNode.getPrimaryNodeType().getName();
            List listCanCreateNodeType = Utils.getListAllowedFileType((Node)this.node_, (String)this.getRepository(), (TemplateService)templateService);
            if (!listCanCreateNodeType.contains(nodeType)) continue;
            attachments.add(childNode);
        }
        return attachments;
    }

    public String getIcons(Node node, String type) throws Exception {
        return Utils.getNodeTypeIcon((Node)node, (String)type);
    }

    public boolean hasPropertyContent(Node node, String property) {
        try {
            String value = node.getProperty(property).getString();
            if (value.length() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isRssLink() {
        return false;
    }

    public String getRssLink() {
        return null;
    }

    public void update() throws Exception {
        ((UINodeInfo)this.getChild(UINodeInfo.class)).update();
    }

    public List<Node> getComments() throws Exception {
        return ((CommentsService)this.getApplicationComponent(CommentsService.class)).getComments(this.node_, this.getLanguage());
    }

    public Object getComponentInstanceOfType(String className) {
        Object service = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> object = loader.loadClass(className);
            service = this.getApplicationComponent(object);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return service;
    }

    public String getDownloadLink(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        if (!node.getPrimaryNodeType().getName().equals("nt:file")) {
            node = this.originalNode_;
        }
        Node jcrContentNode = node.getNode("jcr:content");
        InputStream input = jcrContentNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public String getImage(Node node) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode("exo:image");
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String getLanguage() {
        return this.language_;
    }

    public String getNodeType() throws Exception {
        return this.node_.getPrimaryNodeType().getName();
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public List getSupportedLocalise() throws Exception {
        MultiLanguageService multiLanguageService = (MultiLanguageService)this.getApplicationComponent(MultiLanguageService.class);
        return multiLanguageService.getSupportedLanguages(this.node_);
    }

    public String getTemplatePath() throws Exception {
        return null;
    }

    public String getViewTemplate(String nodeTypeName, String templateName) throws Exception {
        TemplateService tempServ = (TemplateService)this.getApplicationComponent(TemplateService.class);
        return tempServ.getTemplatePath(false, nodeTypeName, templateName, this.getRepository());
    }

    public String getWebDAVServerPrefix() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getWorkspaceName() throws Exception {
        return this.node_.getSession().getWorkspace().getName();
    }

    public boolean isNodeTypeSupported() {
        try {
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            return templateService.isManagedNodeType(this.getNodeType(), this.getRepository());
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getRepository() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    public String encodeHTML(String text) throws Exception {
        return Utils.encodeHTML((String)text);
    }
}

