/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterConstant {
    public static final String CATEGORIES_PROPERTY_ADDMINISTRATOR = "exo:newsletteraddministrator";
    public static final String CATEGORY_NODETYPE = "exo:newsletterCategory";
    public static final String CATEGORY_PROPERTY_TITLE = "exo:newsletterCategoryTitle";
    public static final String CATEGORY_PROPERTY_DESCRIPTION = "exo:newsletterCategoryDescription";
    public static final String SUBSCRIPTION_NODETYPE = "exo:newsletterSubscription";
    public static final String SUBSCRIPTION_PROPERTY_USER = "exo:newsletterSubscribedUser";
    public static final String SUBSCRIPTION_PROPERTY_TITLE = "exo:newsletterSubscriptionTitle";
    public static final String SUBSCRIPTION_PROPERTY_DECRIPTION = "exo:newsletterSubscriptionDecription";
    public static final String SUBSCRIPTION_PROPERTY_CATEGORY_NAME = "exo:newsletterSubscriptionCategoryName";
    public static final String ENTRY_NODETYPE = "exo:newsletterEntry";
    public static final String ENTRY_PROPERTY_TYPE = "exo:newsletterEntryType";
    public static final String ENTRY_PROPERTY_DATE = "exo:newsletterEntryDate";
    public static final String ENTRY_PROPERTY_STATUS = "exo:newsletterEntryStatus";
    public static final String ENTRY_PROPERTY_SUBSCRIPTION_NAME = "exo:newsletterEntrySubscriptionName";
    public static final String ENTRY_PROPERTY_CATEGORY_NAME = "exo:newsletterEntryCategoryName";
    public static final String ENTRY_PROPERTY_CONTENT_MAIN = "exo:newsletterEntryContentMain";
    public static final String ENTRY_PROPERTY_NAME = "exo:newsletterEntryName";
    public static final String ENTRY_PROPERTY_TITLE = "exo:newsletterEntryTitle";
    public static final String USER_NODETYPE = "exo:newsletterUser";
    public static final String USER_PROPERTY_MAIL = "exo:newsletterUserMail";
    public static final String USER_PROPERTY_BANNED = "exo:newsletterUserBanned";
    public static final String USER_PROPERTY_VALIDATION_CODE = "exo:newsletterUserValidationCode";
    public static final String USER_PROPERTY_IS_CONFIRM = "exo:newsletterUserConfirm";
    public static final String STATUS_DRAFT = "draft";
    public static final String STATUS_AWAITING = "awaiting";
    public static final String STATUS_SENT = "sent";
    public static final String PORTAL_NAME = "portalName";
    public static String TEMPLATE_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/DefaultTemplates";
    public static String CATEGORY_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/Categories";
    public static String USER_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/Users";

    public static String generateDefaultTemplatePath(String portalName) {
        return TEMPLATE_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateCategoryTemplateBasePath(String portalName, String categoryName) {
        return NewsletterConstant.generateCategoryPath(portalName).concat("/" + categoryName).concat("/Templates");
    }

    public static String generateCategoryPath(String portalName) {
        return CATEGORY_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateUserPath(String portalName) {
        return USER_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateSubscriptionPath(String portalName, String categoryName, String subscriptionName) {
        return NewsletterConstant.generateCategoryPath(portalName).concat("/" + categoryName).concat("/" + subscriptionName);
    }

    public static String generateNewsletterPath(String portalName, String categoryName, String subscriptionName, String newsletterName) {
        return NewsletterConstant.generateSubscriptionPath(portalName, categoryName, subscriptionName).concat("/" + newsletterName);
    }

    public static List<String> getAllPermissionOfNode(Node node) throws Exception {
        ExtendedNode webContent = (ExtendedNode)node;
        Iterator permissionIterator = webContent.getACL().getPermissionEntries().iterator();
        HashMap<String, Integer> mapPermission = new HashMap<String, Integer>();
        while (permissionIterator.hasNext()) {
            AccessControlEntry accessControlEntry = (AccessControlEntry)permissionIterator.next();
            String currentIdentity = accessControlEntry.getIdentity();
            if (mapPermission.containsKey(currentIdentity)) {
                mapPermission.put(currentIdentity, (Integer)mapPermission.get(currentIdentity) + 1);
                continue;
            }
            mapPermission.put(currentIdentity, 1);
        }
        int size = PermissionType.ALL.length;
        ArrayList<String> listPermission = new ArrayList<String>();
        for (String key : mapPermission.keySet().toArray(new String[0])) {
            if ((Integer)mapPermission.get(key) != size) continue;
            listPermission.add(key);
        }
        return listPermission;
    }

    public static List<String> getAllGroupAndMembershipOfCurrentUser(String userId) throws Exception {
        ArrayList<String> userGroupMembership = new ArrayList<String>();
        userGroupMembership.add(userId);
        String value = "";
        String id = "";
        Membership membership = null;
        OrganizationService organizationService_ = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (Object object : organizationService_.getMembershipHandler().findMembershipsByUser(userId).toArray()) {
            id = object.toString();
            id = id.replace("Membership[", "").replace("]", "");
            membership = organizationService_.getMembershipHandler().findMembership(id);
            value = membership.getGroupId();
            userGroupMembership.add(value);
            value = membership.getMembershipType() + ":" + value;
            userGroupMembership.add(value);
        }
        return userGroupMembership;
    }

    public static boolean havePermission(List<String> list1, List<String> list2) {
        for (String str : list1) {
            if (!list2.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static void addPermissionsFromCateToSubs(Node categoryNode, String[] userIds, String[] permissions) throws Exception {
        NodeIterator ni = categoryNode.getNodes();
        while (ni.hasNext()) {
            ExtendedNode extendSubscriptionNode;
            Node subscriptionNode = ni.nextNode();
            if (!subscriptionNode.isNodeType(SUBSCRIPTION_NODETYPE) || !(extendSubscriptionNode = (ExtendedNode)ExtendedNode.class.cast(subscriptionNode)).canAddMixin("exo:privilegeable") && !extendSubscriptionNode.isNodeType("exo:privilegeable")) continue;
            if (extendSubscriptionNode.canAddMixin("exo:privilegeable")) {
                extendSubscriptionNode.addMixin("exo:privilegeable");
            }
            for (String userId : userIds) {
                extendSubscriptionNode.setPermission(userId, permissions);
            }
        }
    }
}

