/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterCategoryHandler {
    private static Log log = ExoLogger.getLogger(NewsletterCategoryHandler.class);
    private RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
    private String repository;
    private String workspace;

    public NewsletterCategoryHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    protected NewsletterCategoryConfig getCategoryFromNode(Node categoryNode) throws Exception {
        NewsletterCategoryConfig categoryConfig = null;
        categoryConfig = new NewsletterCategoryConfig();
        categoryConfig.setName(categoryNode.getName());
        categoryConfig.setTitle(categoryNode.getProperty("exo:newsletterCategoryTitle").getString());
        if (categoryNode.hasProperty("exo:newsletterCategoryDescription")) {
            categoryConfig.setDescription(categoryNode.getProperty("exo:newsletterCategoryDescription").getString());
        }
        String permission = "";
        for (String per : NewsletterConstant.getAllPermissionOfNode(categoryNode)) {
            if (permission.length() > 0) {
                permission = permission + ",";
            }
            permission = permission + per;
        }
        categoryConfig.setModerator(permission);
        return categoryConfig;
    }

    private List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                log.error((Object)"Error when convert values to array: ", e.fillInStackTrace());
            }
        }
        return listString;
    }

    private void updatePermissionForCategoryNode(Node categoryNode, NewsletterCategoryConfig categoryConfig, boolean isAddNew) throws Exception {
        ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
        if (extendedCategoryNode.canAddMixin("exo:privilegeable") || extendedCategoryNode.isNodeType("exo:privilegeable")) {
            Node categoriesNode;
            if (extendedCategoryNode.canAddMixin("exo:privilegeable")) {
                extendedCategoryNode.addMixin("exo:privilegeable");
            }
            ArrayList<String> newModerators = new ArrayList<String>();
            newModerators.addAll(Arrays.asList(categoryConfig.getModerator().split(",")));
            for (String permission : newModerators) {
                extendedCategoryNode.setPermission(permission, PermissionType.ALL);
            }
            String[] permissions = new String[]{"add_node", "remove", "set_property"};
            NewsletterConstant.addPermissionsFromCateToSubs(categoryNode, newModerators.toArray(new String[0]), permissions);
            if (isAddNew && (categoriesNode = categoryNode.getParent()).hasProperty("exo:newsletteraddministrator")) {
                Value[] values = categoriesNode.getProperty("exo:newsletteraddministrator").getValues();
                for (String per : this.convertValuesToArray(values)) {
                    if (newModerators.contains(per)) continue;
                    extendedCategoryNode.setPermission(per, permissions);
                    newModerators.add(per);
                }
            }
            for (String oldPer : NewsletterConstant.getAllPermissionOfNode(categoryNode)) {
                if (newModerators.contains(oldPer)) continue;
                extendedCategoryNode.removePermission(oldPer, "add_node");
                extendedCategoryNode.removePermission(oldPer, "remove");
                extendedCategoryNode.removePermission(oldPer, "set_property");
                extendedCategoryNode.removePermission(oldPer, "add_node,set_property,remove");
                extendedCategoryNode.setPermission(oldPer, new String[]{"read"});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig categoryConfig) {
        log.info((Object)("Trying to add category " + categoryConfig.getName()));
        Session session = null;
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            Node categoryNode = categoriesNode.addNode(categoryConfig.getName(), "exo:newsletterCategory");
            ExtendedNode extendedTemplateNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode.addNode("Templates", "nt:unstructured"));
            if (extendedTemplateNode.canAddMixin("exo:privilegeable")) {
                extendedTemplateNode.addMixin("exo:privilegeable");
                extendedTemplateNode.setPermission("any", new String[]{"add_node", "read"});
            }
            ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
            extendedCategoryNode.setProperty("exo:newsletterCategoryTitle", categoryConfig.getTitle());
            extendedCategoryNode.setProperty("exo:newsletterCategoryDescription", categoryConfig.getDescription());
            this.updatePermissionForCategoryNode(categoryNode, categoryConfig, true);
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Add category " + categoryConfig.getName() + " failed because of: "), e.fillInStackTrace());
        }
        finally {
            if (session != null) {
                session.logout();
            }
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void edit(SessionProvider sessionProvider, String portalName, NewsletterCategoryConfig categoryConfig) {
        log.info((Object)("Trying to edit category " + categoryConfig.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(categoryPath)).getNode(categoryConfig.getName());
            categoryNode.setProperty("exo:newsletterCategoryDescription", categoryConfig.getDescription());
            categoryNode.setProperty("exo:newsletterCategoryTitle", categoryConfig.getTitle());
            this.updatePermissionForCategoryNode(categoryNode, categoryConfig, false);
            session.save();
            session.logout();
        }
        catch (Exception e) {
            log.info((Object)("Edit category " + categoryConfig.getName() + " failed because of "), e.fillInStackTrace());
        }
        finally {
            sessionProvider.close();
        }
    }

    public void delete(SessionProvider sessionProvider, String portalName, String categoryName) {
        log.info((Object)("Trying to delete category " + categoryName));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(categoryPath)).getNode(categoryName);
            categoryNode.remove();
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Delete category " + categoryName + " failed because of "), e.fillInStackTrace());
        }
    }

    public NewsletterCategoryConfig getCategoryByName(SessionProvider sessionProvider, String portalName, String categoryName) throws Exception {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            return this.getCategoryFromNode(categoriesNode.getNode(categoryName));
        }
        catch (Exception ex) {
            log.error((Object)("Error when getCategoryByName: " + ex.fillInStackTrace()));
            return null;
        }
    }

    public List<NewsletterCategoryConfig> getListCategories(String portalName, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterCategoryConfig> listCategories = new ArrayList<NewsletterCategoryConfig>();
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            NodeIterator nodeIterator = categoriesNode.getNodes();
            while (nodeIterator.hasNext()) {
                try {
                    listCategories.add(this.getCategoryFromNode(nodeIterator.nextNode()));
                }
                catch (Exception ex) {
                    log.error((Object)("Get category " + nodeIterator.nextNode().getName() + " failed because of "), ex.fillInStackTrace());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Get list categories  failed because of ", e.fillInStackTrace());
        }
        return listCategories;
    }

    public List<NewsletterCategoryConfig> getListCategoriesCanView(String portalName, String userName, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterCategoryConfig> listCategories = new ArrayList<NewsletterCategoryConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
        Node categoriesNode = (Node)session.getItem(categoryPath);
        List<String> userGroupMembers = NewsletterConstant.getAllGroupAndMembershipOfCurrentUser(userName);
        NodeIterator nodeIterator = categoriesNode.getNodes();
        block0: while (nodeIterator.hasNext()) {
            Node categoryNode = nodeIterator.nextNode();
            List<String> allPermission = NewsletterConstant.getAllPermissionOfNode(categoryNode);
            if (NewsletterConstant.havePermission(allPermission, userGroupMembers)) {
                listCategories.add(this.getCategoryFromNode(categoryNode));
                continue;
            }
            NodeIterator ni = categoryNode.getNodes();
            while (ni.hasNext()) {
                Node subNode = ni.nextNode();
                if (!subNode.isNodeType("exo:newsletterSubscription") || !NewsletterConstant.havePermission(allPermission = NewsletterConstant.getAllPermissionOfNode(subNode), userGroupMembers)) continue;
                listCategories.add(this.getCategoryFromNode(categoryNode));
                continue block0;
            }
        }
        return listCategories;
    }
}

