/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPages;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIPublicationPagesContainer
extends UIContainer {
    public void init(Node node) throws Exception {
        UIPublicationPages publicationPages = (UIPublicationPages)this.addChild(UIPublicationPages.class, null, null);
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        String portalName = this.getPortalForContent(node);
        publicationPages.init(node, portalName, runningPortals);
        UIPopupWindow popupWindow = null;
        popupWindow = (UIPopupWindow)this.getChildById("UIClvPopupContainer");
        if (popupWindow == null) {
            popupWindow = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "UIClvPopupContainer");
        }
    }

    private String getPortalForContent(Node contentNode) throws Exception {
        LivePortalManagerService livePortalManagerService = PublicationUtil.getServices(LivePortalManagerService.class);
        for (String portalPath : livePortalManagerService.getLivePortalsPath()) {
            if (!contentNode.getPath().startsWith(portalPath)) continue;
            return livePortalManagerService.getPortalNameByPath(portalPath);
        }
        return null;
    }

    private List<String> getRunningPortals(String userId) throws Exception {
        ArrayList<String> listPortalName = new ArrayList<String>();
        DataStorage service = PublicationUtil.getServices(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        PageList pageList = service.find(query);
        UserACL userACL = PublicationUtil.getServices(UserACL.class);
        for (Object object : pageList.getAll()) {
            PortalConfig portalConfig = (PortalConfig)object;
            if (!userACL.hasPermission(portalConfig, userId)) continue;
            listPortalName.add(portalConfig.getName());
        }
        return listPortalName;
    }
}

