/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationAction;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPagesContainer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPublishClvChooser.gtmpl", events={@EventConfig(listeners={ChooseActionListener.class}), @EventConfig(listeners={CloseActionListener.class})})
public class UIPublishClvChooser
extends UIForm
implements UIPopupComponent {
    private Page page;
    private NodeLocation nodeLocation;

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Node getNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.nodeLocation);
    }

    public void setNode(Node node) {
        this.nodeLocation = NodeLocation.make((Node)node);
    }

    public List<Application> getClvPortlets() throws Exception {
        WCMConfigurationService wcmConfigurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        DataStorage dataStorage = PublicationUtil.getServices(DataStorage.class);
        List<String> clvPortletsId = PublicationUtil.findAppInstancesByName(this.page, wcmConfigurationService.getRuntimeContextParam("CLVPortlet"));
        ArrayList<Application> applications = new ArrayList<Application>();
        for (String clvPortletId : clvPortletsId) {
            boolean isManualViewerMode = false;
            Application application = PublicationUtil.findAppInstancesById((Container)this.page, clvPortletId);
            PortletPreferences portletPreferences = dataStorage.getPortletPreferences((WindowID)new ExoWindowID(clvPortletId));
            if (portletPreferences != null) {
                for (Object object : portletPreferences.getPreferences()) {
                    Preference preference = (Preference)object;
                    if ("header".equals(preference.getName()) && preference.getValues().size() > 0) {
                        application.setTitle(preference.getValues().get(0).toString());
                    }
                    if (!"mode".equals(preference.getName()) || preference.getValues().size() <= 0) continue;
                    isManualViewerMode = "ManualViewerMode".equals(preference.getValues().get(0).toString());
                }
            }
            if (!isManualViewerMode) continue;
            applications.add(application);
        }
        return applications;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIPublishClvChooser> {
        public void execute(Event<UIPublishClvChooser> event) throws Exception {
            UIPublishClvChooser clvChooser = (UIPublishClvChooser)((Object)event.getSource());
            UIPopupWindow popupWindow = (UIPopupWindow)clvChooser.getAncestorOfType(UIPopupWindow.class);
            popupWindow.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChooseActionListener
    extends EventListener<UIPublishClvChooser> {
        public void execute(Event<UIPublishClvChooser> event) throws Exception {
            UIPublishClvChooser clvChooser = (UIPublishClvChooser)((Object)event.getSource());
            String clvPortletId = URLDecoder.decode(event.getRequestContext().getRequestParameter("objectId"), "UTF-8");
            WCMPublicationService presentationService = (WCMPublicationService)clvChooser.getApplicationComponent(WCMPublicationService.class);
            DataStorage dataStorage = PublicationUtil.getServices(DataStorage.class);
            PortletPreferences portletPreferences = dataStorage.getPortletPreferences((WindowID)new ExoWindowID(clvPortletId));
            Node node = clvChooser.getNode();
            if (portletPreferences != null) {
                for (Object object : portletPreferences.getPreferences()) {
                    String contentValues;
                    Preference preference = (Preference)object;
                    if (!"contents".equals(preference.getName()) || (contentValues = preference.getValues().get(0).toString()).indexOf(node.getPath()) < 0) continue;
                    UIApplication application = (UIApplication)clvChooser.getAncestorOfType(UIApplication.class);
                    application.addMessage(new ApplicationMessage("UIPublishClvChooser.msg.duplicate", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
                    return;
                }
            }
            StageAndVersionPublicationPlugin publicationPlugin = (StageAndVersionPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME);
            publicationPlugin.publishContentToCLV(node, clvChooser.page, clvPortletId, Util.getUIPortal().getOwner(), event.getRequestContext().getRemoteUser());
            UIPublicationPagesContainer uiPublicationPagesContainer = (UIPublicationPagesContainer)clvChooser.getAncestorOfType(UIPublicationPagesContainer.class);
            UIPublicationAction publicationAction = (UIPublicationAction)((UIContainer)uiPublicationPagesContainer.getChildById("UIPublicationPages")).getChildById("UIPublicationAction");
            publicationAction.updateUI();
            UIPopupWindow popupWindow = (UIPopupWindow)clvChooser.getAncestorOfType(UIPopupWindow.class);
            popupWindow.setShow(false);
        }
    }
}

