/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.page;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEventListenerDelegate {
    private String lifecycleName;

    public PageEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreatePage(Page page, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        this.updateAddedApplication(page, remoteUser, plugin);
    }

    public void updateLifecyleOnChangePage(Page page, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        this.updateAddedApplication(page, remoteUser, plugin);
        this.updateRemovedApplication(page, remoteUser, plugin);
    }

    public void updateLifecycleOnRemovePage(Page page, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        WCMConfigurationService wcmConfigurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        List<String> listPageApplicationId = PublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"));
        for (String applicationId : listPageApplicationId) {
            Node content = PublicationUtil.getNodeByApplicationId(applicationId);
            if (content == null) continue;
            this.saveRemovedApplication(page, applicationId, content, remoteUser, plugin);
        }
    }

    private void updateAddedApplication(Page page, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        WCMConfigurationService wcmConfigurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        List<String> listPageApplicationId = PublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"));
        for (String applicationtId : listPageApplicationId) {
            Node content = PublicationUtil.getNodeByApplicationId(applicationtId);
            if (content == null) continue;
            this.saveAddedApplication(page, applicationtId, content, this.lifecycleName, remoteUser, plugin);
        }
    }

    private void updateRemovedApplication(Page page, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        List<Node> listNode = this.getListNodeByApplicationId(page, plugin);
        WCMConfigurationService wcmConfigurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        ArrayList<String> listApplicationId = new ArrayList<String>();
        listApplicationId.addAll(PublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet")));
        listApplicationId.addAll(PublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("CLVPortlet")));
        for (Node content : listNode) {
            for (Value value : content.getProperty("publication:applicationIDs").getValues()) {
                String[] tmp = PublicationUtil.parseMixedApplicationId(value.getString());
                String nodeApplicationId = tmp[1];
                if (!tmp[0].equals(page.getPageId()) || listApplicationId.contains(nodeApplicationId)) continue;
                this.saveRemovedApplication(page, nodeApplicationId, content, remoteUser, plugin);
            }
        }
    }

    private List<Node> getListNodeByApplicationId(Page page, WebpagePublicationPlugin plugin) throws Exception {
        RepositoryService repositoryService = PublicationUtil.getServices(RepositoryService.class);
        WCMConfigurationService configurationService = PublicationUtil.getServices(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = configurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String repositoryName = nodeLocation.getRepository();
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = WCMCoreUtils.getSessionProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
        ArrayList<Node> listPublishedNode = new ArrayList<Node>();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from " + plugin.getLifecycleType() + " where publication:lifecycleName='" + this.lifecycleName + "' and publication:webPageIDs like '%" + page.getPageId() + "%' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            listPublishedNode.add(nodeIterator.nextNode());
        }
        session.logout();
        sessionProvider.close();
        return listPublishedNode;
    }

    private void saveAddedApplication(Page page, String applicationId, Node content, String lifecycleName, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        String mixedAppId;
        List<String> nodeAppIds;
        PublicationService publicationService = PublicationUtil.getServices(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        if (content.canAddMixin("publication:webpagesPublication")) {
            content.addMixin("publication:webpagesPublication");
        }
        if ((nodeAppIds = PublicationUtil.getValuesAsString(content, "publication:applicationIDs")).contains(mixedAppId = PublicationUtil.setMixedApplicationId(page.getPageId(), applicationId))) {
            return;
        }
        List<String> listExistedNavigationNodeUri = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        List<String> listPageNavigationUri = plugin.getListPageNavigationUri(page, remoteUser);
        if (listPageNavigationUri.isEmpty()) {
            return;
        }
        for (String uri : listPageNavigationUri) {
            listExistedNavigationNodeUri.add(uri);
        }
        content.setProperty("publication:navigationNodeURIs", PublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        List<String> nodeWebPageIds = PublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        nodeWebPageIds.add(page.getPageId());
        nodeAppIds.add(mixedAppId);
        content.setProperty("publication:applicationIDs", PublicationUtil.toValues(valueFactory, nodeAppIds));
        content.setProperty("publication:webPageIDs", PublicationUtil.toValues(valueFactory, nodeWebPageIds));
        session.save();
    }

    private void saveRemovedApplication(Page page, String applicationId, Node content, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        listExistedApplicationId.remove(PublicationUtil.setMixedApplicationId(page.getPageId(), applicationId));
        content.setProperty("publication:applicationIDs", PublicationUtil.toValues(valueFactory, listExistedApplicationId));
        List<String> listExistedPageId = PublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        listExistedPageId.remove(page.getPageId());
        content.setProperty("publication:webPageIDs", PublicationUtil.toValues(valueFactory, listExistedPageId));
        List<String> listPageNavigationUri = plugin.getListPageNavigationUri(page, remoteUser);
        List<String> listExistedNavigationNodeUri = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        ArrayList<String> listExistedNavigationNodeUriTmp = new ArrayList<String>();
        listExistedNavigationNodeUriTmp.addAll(listExistedNavigationNodeUri);
        for (String existedNavigationNodeUri : listExistedNavigationNodeUriTmp) {
            if (!listPageNavigationUri.contains(existedNavigationNodeUri)) continue;
            listExistedNavigationNodeUri.remove(existedNavigationNodeUri);
            break;
        }
        content.setProperty("publication:navigationNodeURIs", PublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        session.save();
    }
}

