/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.images;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;

@URITemplate(value="/images/{repositoryName}/{workspaceName}/{nodeIdentifier}/")
public class RESTImagesRendererService
implements ResourceContainer {
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";
    private SessionProviderService sessionProviderService;
    private RepositoryService repositoryService;
    static Log log = ExoLogger.getLogger(RESTImagesRendererService.class);
    private String baseRestURI = "/portal/rest/";

    public RESTImagesRendererService(RepositoryService repositoryService, SessionProviderService sessionProviderService) {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HTTPMethod(value="GET")
    @QueryTemplate(value="type=file")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response serveImage(@URIParam(value="repositoryName") String repository, @URIParam(value="workspaceName") String workspace, @URIParam(value="nodeIdentifier") String nodeIdentifier, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) {
        Response response;
        Node node = null;
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = null;
        try {
            VersionHistory versionHistory2;
            session = sessionProvider.getSession(workspace, this.repositoryService.getRepository(repository));
            node = nodeIdentifier.contains("/") ? session.getRootNode().getNode(nodeIdentifier) : session.getNodeByUUID(nodeIdentifier);
            if (node == null) {
                Response response2 = Response.Builder.withStatus((int)404).build();
                return response2;
            }
            Node dataNode = null;
            InputStream jcrData = null;
            if (node.isNodeType("nt:file")) {
                dataNode = node;
            } else if (node.isNodeType("nt:versionedChild")) {
                versionHistory2 = (VersionHistory)node.getProperty("jcr:childVersionHistory").getNode();
                String versionableUUID = versionHistory2.getVersionableUUID();
                dataNode = session.getNodeByUUID(versionableUUID);
            } else {
                Response versionHistory2 = Response.Builder.withStatus((int)404).build();
                return versionHistory2;
            }
            if (ifModifiedSince != null && !this.isModified(ifModifiedSince, dataNode)) {
                versionHistory2 = Response.Builder.notModified().build();
                return versionHistory2;
            }
            jcrData = dataNode.getNode("jcr:content").getProperty("jcr:data").getStream();
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            Response response3 = Response.Builder.ok().header(LAST_MODIFIED_PROPERTY, dateFormat.format(new Date())).entity((Object)jcrData, "image").build();
            return response3;
        }
        catch (PathNotFoundException e) {
            response = Response.Builder.withStatus((int)404).build();
            return response;
        }
        catch (ItemNotFoundException e) {
            response = Response.Builder.withStatus((int)404).build();
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Error when serveImage: ", e.fillInStackTrace());
            response = Response.Builder.serverError().build();
            return response;
        }
        finally {
            if (session != null) {
                session.logout();
            }
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HTTPMethod(value="GET")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response serveImage(@URIParam(value="repositoryName") String repository, @URIParam(value="workspaceName") String workspace, @URIParam(value="nodeIdentifier") String nodeIdentifier, @QueryParam(value="propertyName") String propertyName, @HeaderParam(value="If-Modified-Since") String ifModifiedSince) {
        Node node = null;
        SessionProvider sessionProvider = this.sessionProviderService.getSessionProvider(null);
        Session session = null;
        try {
            session = sessionProvider.getSession(workspace, this.repositoryService.getRepository(repository));
            node = nodeIdentifier.contains("/") ? session.getRootNode().getNode(nodeIdentifier) : session.getNodeByUUID(nodeIdentifier);
            if (node == null) {
                Response response = Response.Builder.withStatus((int)404).build();
                return response;
            }
            if (ifModifiedSince != null && !this.isModified(ifModifiedSince, node)) {
                Response response = Response.Builder.notModified().build();
                return response;
            }
            InputStream jcrData = node.getProperty(propertyName).getStream();
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            Response response = Response.Builder.ok().header(LAST_MODIFIED_PROPERTY, dateFormat.format(new Date())).entity((Object)jcrData, "image").build();
            return response;
        }
        catch (PathNotFoundException e) {
            Response response = Response.Builder.withStatus((int)404).build();
            return response;
        }
        catch (ItemNotFoundException e) {
            Response response = Response.Builder.withStatus((int)404).build();
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Error when serve image: ", e.fillInStackTrace());
            Response response = Response.Builder.serverError().build();
            return response;
        }
        finally {
            if (session != null) {
                session.logout();
            }
            sessionProvider.close();
        }
    }

    public String generateURI(Node file) throws Exception {
        if (!file.isNodeType("nt:file")) {
            throw new UnsupportedOperationException("The node isn't nt:file");
        }
        StringBuilder builder = new StringBuilder();
        String repository = ((ManageableRepository)file.getSession().getRepository()).getConfiguration().getName();
        String workspaceName = file.getSession().getWorkspace().getName();
        String nodeIdentifiler = null;
        InputStream stream = file.getNode("jcr:content").getProperty("jcr:data").getStream();
        if (stream.available() == 0) {
            return null;
        }
        stream.close();
        nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String accessURI = this.baseRestURI;
        String userId = file.getSession().getUserID();
        if (!SystemIdentity.ANONIM.equals(userId) && SystemIdentity.SYSTEM.equalsIgnoreCase(userId)) {
            accessURI = this.baseRestURI.concat("private/");
        }
        return builder.append(accessURI).append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?type=file").toString();
    }

    public String generateURI(Node file, String propertyName) throws Exception {
        StringBuilder builder = new StringBuilder();
        String repository = ((ManageableRepository)file.getSession().getRepository()).getConfiguration().getName();
        String workspaceName = file.getSession().getWorkspace().getName();
        String nodeIdentifiler = null;
        nodeIdentifiler = file.isNodeType("mix:referenceable") ? file.getUUID() : file.getPath().replaceFirst("/", "");
        String accessURI = this.baseRestURI;
        String userId = file.getSession().getUserID();
        if (!SystemIdentity.ANONIM.equals(userId) && SystemIdentity.SYSTEM.equalsIgnoreCase(userId)) {
            accessURI = this.baseRestURI.concat("private/");
        }
        return builder.append(accessURI).append("images/").append(repository).append("/").append(workspaceName).append("/").append(nodeIdentifiler).append("?propertyName=").append(propertyName).toString();
    }

    private Date getLastModifiedDate(Node node) throws Exception {
        Date lastModifiedDate = null;
        lastModifiedDate = node.hasNode("jcr:content") ? node.getNode("jcr:content").getProperty("jcr:lastModified").getDate().getTime() : (node.hasNode("exo:dateModified") ? node.getProperty("exo:dateModified").getDate().getTime() : node.getProperty("jcr:created").getDate().getTime());
        return lastModifiedDate;
    }

    private boolean isModified(String ifModifiedSince, Node node) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        Date ifModifiedSinceDate = dateFormat.parse(ifModifiedSince);
        Date lastModifiedDate = this.getLastModifiedDate(node);
        return ifModifiedSinceDate.getTime() < lastModifiedDate.getTime();
    }
}

