/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.utils;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMCoreUtils {
    private static Log log = ExoLogger.getLogger((String)"wcm.WCMCoreUtils");

    public static <T> T getService(Class<T> clazz) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return clazz.cast(container.getComponentInstanceOfType(clazz));
    }

    public static SessionProvider getSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSystemSessionProvider(null);
        return sessionProvider;
    }

    public static SessionProvider getUserSessionProvider() {
        SessionProviderService sessionProviderService = WCMCoreUtils.getService(SessionProviderService.class);
        SessionProvider sessionProvider = sessionProviderService.getSessionProvider(null);
        return sessionProvider;
    }

    public static boolean hasPermission(String userId, List<String> permissions, boolean isNeedFullAccess) {
        try {
            OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
            Collection memberships = null;
            Membership userMembership2 = null;
            String userMembershipTmp = null;
            int count = 0;
            String permissionTmp = "";
            for (String permission : permissions) {
                if (!permissionTmp.equals(permission)) {
                    count = 0;
                }
                memberships = organizationService.getMembershipHandler().findMembershipsByUser(userId);
                for (Membership userMembership2 : memberships) {
                    if (permission.equals(userMembership2.getUserName())) {
                        return true;
                    }
                    if ("any".equals(permission)) {
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    if (permission.startsWith("*") && permission.contains(userMembership2.getGroupId())) {
                        if (isNeedFullAccess) {
                            if (++count != 4) continue;
                            return true;
                        }
                        return true;
                    }
                    userMembershipTmp = userMembership2.getMembershipType() + ":" + userMembership2.getGroupId();
                    if (!permission.equals(userMembershipTmp)) continue;
                    if (isNeedFullAccess) {
                        if (++count != 4) continue;
                        return true;
                    }
                    return true;
                }
                permissionTmp = permission;
            }
        }
        catch (Exception e) {
            log.error((Object)"hasPermission() failed because of ", (Throwable)e);
        }
        return false;
    }
}

